/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.util.Date;
import visad.CoordinateSystem;
import visad.DataImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarType;
import visad.jmet.MetGridDirectory;

public class MetGrid {
    protected MetGridDirectory dir;
    protected FlatField data;
    protected CoordinateSystem coordinateSystem;
    protected Date referenceTime;
    protected Date validTime;
    RealTupleType grid_domain;
    Integer2DSet dom_set;

    public Integer2DSet getDomainSet() {
        return this.dom_set;
    }

    public MetGridDirectory getGridDirectory() {
        return this.dir;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public DataImpl getData() {
        return this.data;
    }

    public MetGrid(MetGridDirectory metGridDirectory, double[] dArray) {
        this.coordinateSystem = metGridDirectory.getCoordinateSystem();
        this.dir = metGridDirectory;
        try {
            RealType realType = ScalarType.getScalarTypeByName("Nx") == null ? new RealType("Nx", null, null) : (RealType)ScalarType.getScalarTypeByName("Nx");
            RealType realType2 = ScalarType.getScalarTypeByName("Ny") == null ? new RealType("Ny", null, null) : (RealType)ScalarType.getScalarTypeByName("Ny");
            String string = metGridDirectory.getParamName().trim();
            RealType realType3 = ScalarType.getScalarTypeByName(string) == null ? new RealType(string, null, null) : (RealType)ScalarType.getScalarTypeByName(string);
            RealType[] realTypeArray = new RealType[]{realType, realType2};
            this.grid_domain = new RealTupleType(realTypeArray, this.coordinateSystem, null);
            this.dom_set = new Integer2DSet((MathType)this.grid_domain, this.dir.getColumns(), this.dir.getRows());
            FunctionType functionType = new FunctionType(this.grid_domain, realType3);
            this.data = new FlatField(functionType, this.dom_set);
            double[][] dArray2 = new double[][]{dArray};
            this.data.setSamples(dArray2, false);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

