/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.geom.Rectangle2D;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.LambertConformalConic;
import visad.data.hdfeos.PolarStereographic;
import visad.georef.MapProjection;
import visad.util.DataUtility;

public class GRIBCoordinateSystem
extends MapProjection {
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    private CoordinateSystem c;
    private double spacing;
    private boolean isLambert = false;
    private boolean isLatLon = false;
    private boolean isPolarStereo = false;
    private double La1;
    private double Lo1;
    private double LoMax;
    private double Di;
    private double Dj;
    private double aspectRatio = 1.0;
    private double[] range;

    private void doLatLon(RealTupleType realTupleType, int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) throws VisADException {
        this.isLambert = false;
        this.isLatLon = true;
        this.La1 = d;
        this.Lo1 = d2;
        this.Di = d5;
        this.Dj = d6;
        this.LoMax = d2 + d5 * (double)(n - 1);
        this.aspectRatio = d5 / d6;
        this.range = new double[4];
        this.range[0] = 0.0;
        this.range[1] = 0.0;
        this.range[2] = n - 1;
        this.range[3] = n2 - 1;
    }

    private void doPolarStereo(RealTupleType realTupleType, int n, int n2, double d, double d2, double d3, double d4) throws VisADException {
        this.isPolarStereo = true;
        this.spacing = d3 * 1000.0;
        this.aspectRatio = 1.0;
        this.range = new double[4];
        this.range[0] = 0.0;
        this.range[1] = 0.0;
        this.range[2] = n - 1;
        this.range[3] = n2 - 1;
        this.c = PolarStereographic.makePolarStereographic(realTupleType, d * (Math.PI / 180), d2 * (Math.PI / 180), d4 * (Math.PI / 180));
    }

    private void doLambert(RealTupleType realTupleType, int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) throws VisADException {
        this.isLambert = true;
        this.spacing = d3 * 1000.0;
        double d7 = 6371230.0;
        this.aspectRatio = 1.0;
        this.range = new double[4];
        this.range[0] = 0.0;
        this.range[1] = 0.0;
        this.range[2] = n - 1;
        this.range[3] = n2 - 1;
        this.c = new LambertConformalConic(realTupleType, d7, d7, d4 * (Math.PI / 180), d5 * (Math.PI / 180), d6 * (Math.PI / 180), d4 * (Math.PI / 180), 0.0, 0.0);
        double[][] dArray = new double[2][1];
        double[][] dArray2 = new double[2][1];
        dArray[0][0] = d2 * (Math.PI / 180);
        dArray[1][0] = d * (Math.PI / 180);
        dArray2 = this.c.fromReference(dArray);
        this.c = new LambertConformalConic(realTupleType, d7, d7, d4 * (Math.PI / 180), d5 * (Math.PI / 180), d6 * (Math.PI / 180), d4 * (Math.PI / 180), -dArray2[0][0], -dArray2[1][0]);
    }

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("GRIBCoordinateSystem.toReference: tuples wrong dimension");
        }
        if (this.isLambert || this.isPolarStereo) {
            int n = 0;
            while (n < dArray[0].length) {
                dArray[0][n] = dArray[0][n] * this.spacing;
                dArray[1][n] = dArray[1][n] * this.spacing;
                ++n;
            }
            double[][] dArray2 = this.c.toReference(dArray);
            int n2 = 0;
            while (n2 < dArray2[0].length) {
                double d = dArray2[0][n2] * 57.29577951308232;
                dArray2[0][n2] = dArray2[1][n2] * 57.29577951308232;
                dArray2[1][n2] = d;
                ++n2;
            }
            return dArray2;
        }
        if (this.isLatLon) {
            double[][] dArray3 = new double[2][dArray[0].length];
            int n = 0;
            while (n < dArray[0].length) {
                dArray3[0][n] = this.La1 + this.Dj * dArray[1][n];
                dArray3[1][n] = this.Lo1 + this.Di * dArray[0][n];
                ++n;
            }
            return dArray3;
        }
        return null;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 2) {
            throw new CoordinateSystemException("GRIBCoordinateSystem.toReference: tuples wrong dimension");
        }
        if (this.isLambert || this.isPolarStereo) {
            int n = 0;
            while (n < dArray[0].length) {
                double d = dArray[0][n] * (Math.PI / 180);
                dArray[0][n] = dArray[1][n] * (Math.PI / 180);
                dArray[1][n] = d;
                ++n;
            }
            double[][] dArray2 = this.c.fromReference(dArray);
            int n2 = 0;
            while (n2 < dArray2[0].length) {
                dArray2[0][n2] = dArray2[0][n2] / this.spacing;
                dArray2[1][n2] = dArray2[1][n2] / this.spacing;
                ++n2;
            }
            return dArray2;
        }
        if (this.isLatLon) {
            double[][] dArray3 = new double[2][dArray[0].length];
            int n = 0;
            while (n < dArray[0].length) {
                double d = dArray[1][n];
                if (this.LoMax > 180.0 && d < 0.0 && d < this.Lo1) {
                    d = 360.0 + d;
                }
                dArray3[0][n] = (d - this.Lo1) / this.Di;
                dArray3[1][n] = (dArray[0][n] - this.La1) / this.Dj;
                ++n;
            }
            return dArray3;
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof GRIBCoordinateSystem;
    }

    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Double(this.range[0], this.range[1], this.range[2], this.range[3]);
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public static boolean isGridNumberKnown(int n) {
        int[] nArray = new int[]{201, 202, 203, 211, 212, 215, 236};
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            RealTupleType realTupleType = new RealTupleType(RealType.Latitude, RealType.Longitude);
            GRIBCoordinateSystem gRIBCoordinateSystem = new GRIBCoordinateSystem(211);
            System.out.println("isSerializable? " + DataUtility.isSerializable(gRIBCoordinateSystem, true));
            double[][] dArray = new double[2][1];
            double[][] dArray2 = new double[2][1];
            dArray2[0][0] = 92.0;
            dArray2[1][0] = 64.0;
            dArray = gRIBCoordinateSystem.toReference(dArray2);
            System.out.println(" (93,65) lat=" + dArray[0][0] + " lon=" + dArray[1][0]);
            dArray[0][0] = 12.19;
            dArray[1][0] = -133.459;
            dArray2 = gRIBCoordinateSystem.fromReference(dArray);
            System.out.println(" at (1,1) x=" + dArray2[0][0] + " y=" + dArray2[1][0]);
            dArray[0][0] = 57.29;
            dArray[1][0] = -49.385;
            dArray2 = gRIBCoordinateSystem.fromReference(dArray);
            System.out.println(" max row/col x=" + dArray2[0][0] + " y=" + dArray2[1][0]);
            dArray[0][0] = 35.0;
            dArray[1][0] = -95.0;
            dArray2 = gRIBCoordinateSystem.fromReference(dArray);
            System.out.println(" at 35N/95W x=" + dArray2[0][0] + " y=" + dArray2[1][0]);
            gRIBCoordinateSystem = new GRIBCoordinateSystem(202);
            System.out.println("PolarStereo.......isSerializable? " + DataUtility.isSerializable(gRIBCoordinateSystem, true));
            dArray = new double[2][1];
            dArray2 = new double[2][1];
            dArray2[0][0] = 64.0;
            dArray2[1][0] = 42.0;
            dArray = gRIBCoordinateSystem.toReference(dArray2);
            System.out.println(" (65,42) lat=" + dArray[0][0] + " lon=" + dArray[1][0]);
            dArray[0][0] = 7.838;
            dArray[1][0] = -1141.028;
            dArray2 = gRIBCoordinateSystem.fromReference(dArray);
            System.out.println(" at (1,1) x=" + dArray2[0][0] + " y=" + dArray2[1][0]);
            dArray[0][0] = 35.617;
            dArray[1][0] = -18.576;
            dArray2 = gRIBCoordinateSystem.fromReference(dArray);
            System.out.println(" max row/col x=" + dArray2[0][0] + " y=" + dArray2[1][0]);
            dArray[0][0] = 35.0;
            dArray[1][0] = -95.0;
            dArray2 = gRIBCoordinateSystem.fromReference(dArray);
            System.out.println(" at 35N/95W x=" + dArray2[0][0] + " y=" + dArray2[1][0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public GRIBCoordinateSystem(int n, double d, double d2, double d3, double d4) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, n, d, d2, d3, d4);
    }

    public GRIBCoordinateSystem(RealTupleType realTupleType, int n, double d, double d2, double d3, double d4) throws VisADException {
        super(realTupleType, coordinate_system_units);
        if (n != 5) {
            System.out.println("GRIB Grid type not Polar Stereographic = " + n);
            throw new VisADException("Invalid grid type for PolarStereographic = " + n);
        }
        this.doPolarStereo(realTupleType, 2, 2, d, d2, d3, d4);
    }

    public GRIBCoordinateSystem(RealTupleType realTupleType, int n, double d, double d2, double d3, double d4, double d5, double d6) throws VisADException {
        this(realTupleType, n, 2, 2, d, d2, d3, d4, d5, d6);
    }

    public GRIBCoordinateSystem(int n, double d, double d2, double d3, double d4, double d5, double d6) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, n, 2, 2, d, d2, d3, d4, d5, d6);
    }

    public GRIBCoordinateSystem(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, n, n2, n3, d, d2, d3, d4, d5, d6);
    }

    public GRIBCoordinateSystem(RealTupleType realTupleType, int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6) throws VisADException {
        super(realTupleType, coordinate_system_units);
        if (n == 0) {
            this.doLatLon(realTupleType, n2, n3, d, d2, d3, d4, d5, d6);
        } else if (n == 3) {
            this.doLambert(realTupleType, n2, n3, d, d2, d3, d4, d5, d6);
        } else {
            System.out.println("GRIB Grid type not Lat/Lon = " + n);
            throw new VisADException("Invalid grid type for Lat/Lon = " + n);
        }
    }

    public GRIBCoordinateSystem(int n) throws VisADException {
        this(RealTupleType.LatitudeLongitudeTuple, n);
    }

    public GRIBCoordinateSystem(RealTupleType realTupleType, int n) throws VisADException {
        super(realTupleType, coordinate_system_units);
        if (n == 201) {
            this.doPolarStereo(realTupleType, 65, 65, -20.826, -150.0, 381.0, -105.0);
        } else if (n == 202) {
            this.doPolarStereo(realTupleType, 65, 43, 7.838, -141.028, 190.5, -105.0);
        } else if (n == 203) {
            this.doPolarStereo(realTupleType, 45, 39, 19.132, -185.837, 190.5, -150.0);
        } else if (n == 211) {
            this.doLambert(realTupleType, 93, 65, 12.19, -133.459, 81.2705, 25.0, 25.0, -95.0);
        } else if (n == 212) {
            this.doLambert(realTupleType, 185, 129, 12.19, -133.459, 40.63525, 25.0, 25.0, -95.0);
        } else if (n == 215) {
            this.doLambert(realTupleType, 369, 257, 12.19, -133.459, 20.317625, 25.0, 25.0, -95.0);
        } else if (n == 236) {
            this.doLambert(realTupleType, 151, 113, 16.281, 233.862, 40.635, 25.0, 25.0, 265.0);
        } else {
            System.out.println("GRIB Grid type unknown = " + n);
            throw new VisADException("Unknown grid number = " + n);
        }
    }
}

