/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import visad.Data;
import visad.DataImpl;
import visad.DoubleSet;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.Function;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.data.DefaultFamily;

public class DumpType {
    private static boolean init = true;
    private static OutputStream os;

    public static void dumpDataType(Data data) {
        DumpType.dumpDataType(data, System.out);
    }

    public static void dumpDataType(Data data, OutputStream outputStream) {
        os = outputStream;
        DumpType.dumpDT(data, " ");
    }

    private static void dumpDT(Data data, String string) {
        if (init) {
            System.out.println("VisAD Data analysis");
        }
        init = false;
        try {
            if (data instanceof FlatField) {
                int n = ((FlatField)data).getRangeDimension();
                int n2 = ((FlatField)data).getDomainDimension();
                Set set = ((FlatField)data).getDomainSet();
                string = string + "  ";
                System.out.println(string + " FlatField of length = " + ((FlatField)data).getLength());
                System.out.println(string + " " + ((FlatField)data).getType().prettyString());
                string = string + "  ";
                System.out.println(string + " Domain has " + n2 + " components:");
                DumpType.dumpDT(set, string + "  ");
                System.out.println(string + " Range has " + n + " components:");
                Set[] setArray = ((FlatField)data).getRangeSets();
                float[][] fArray = ((FlatField)data).getFloats();
                int n3 = 0;
                while (n3 < setArray.length) {
                    DumpType.dumpDT(setArray[n3], string + "   " + n3 + ".");
                    int n4 = 0;
                    if (fArray[n3] == null) {
                        n4 = ((FlatField)data).getLength();
                    } else {
                        int n5 = 0;
                        while (n5 < fArray[n3].length) {
                            if (fArray[n3][n5] != fArray[n3][n5]) {
                                ++n4;
                            }
                            ++n5;
                        }
                    }
                    System.out.println(string + "   " + n3 + ". number missing = " + n4);
                    ++n3;
                }
            } else if (data instanceof FieldImpl) {
                int n = ((FieldImpl)data).getDomainDimension();
                Set set = ((FieldImpl)data).getDomainSet();
                System.out.println(string + " FieldImpl of length = " + ((FieldImpl)data).getLength());
                System.out.println(string + " " + ((FieldImpl)data).getType().prettyString());
                System.out.println(string + " Domain has " + n + " components:");
                DumpType.dumpDT(set, string + "  ");
                System.out.println(string + " first sample = ");
                DumpType.dumpDT(((FieldImpl)data).getSample(0), string + "   " + "0" + ".");
            } else if (data instanceof Field) {
                System.out.println(string + " Field: ");
            } else if (data instanceof Function) {
                System.out.println(string + " Function: ");
                System.out.println(string + "    Domain dimension= " + ((Function)data).getDomainDimension());
            } else if (data instanceof Irregular3DSet) {
                System.out.println(string + " Irregular3DSet " + DumpType.name(((Irregular3DSet)data).getType().toString()) + " Length = " + ((Irregular3DSet)data).getLength());
            } else if (data instanceof Irregular2DSet) {
                System.out.println(string + " Irregular2DSet " + DumpType.name(((Irregular2DSet)data).getType().toString()) + " Length = " + ((Irregular2DSet)data).getLength());
            } else if (data instanceof Irregular1DSet) {
                System.out.println(string + " Irregular1DSet " + DumpType.name(((Irregular1DSet)data).getType().toString()) + " Length = " + ((Irregular1DSet)data).getLength());
            } else if (data instanceof IrregularSet) {
                System.out.println(string + " IrregularSet " + DumpType.name(((IrregularSet)data).getType().toString()) + " Length = " + ((IrregularSet)data).getLength());
            } else if (data instanceof Integer3DSet) {
                System.out.println(string + " Integer3DSet: Length = " + ((Integer3DSet)data).getLength());
                int n = 0;
                while (n < 3) {
                    DumpType.dumpDT(((Linear3DSet)data).getLinear1DComponent(n), string + "   " + n + ".");
                    ++n;
                }
            } else if (data instanceof Linear3DSet) {
                System.out.println(string + " Linear3DSet: Length = " + ((Linear3DSet)data).getLength());
                int n = 0;
                while (n < 3) {
                    DumpType.dumpDT(((Linear3DSet)data).getLinear1DComponent(n), string + "   " + n + ".");
                    ++n;
                }
            } else if (data instanceof Gridded3DSet) {
                System.out.println(string + " Gridded3DSet " + DumpType.name(((Gridded3DSet)data).getType().toString()) + " Length = " + ((Gridded3DSet)data).getLength());
            } else if (data instanceof Integer2DSet) {
                System.out.println(string + " Integer2DSet: Length = " + ((Integer2DSet)data).getLength());
                int n = 0;
                while (n < 2) {
                    DumpType.dumpDT(((Linear2DSet)data).getLinear1DComponent(n), string + "   " + n + ".");
                    ++n;
                }
            } else if (data instanceof Linear2DSet) {
                System.out.println(string + " Linear2DSet: Length = " + ((Linear2DSet)data).getLength());
                int n = 0;
                while (n < 2) {
                    DumpType.dumpDT(((Linear2DSet)data).getLinear1DComponent(n), string + "   " + n + ".");
                    ++n;
                }
            } else if (data instanceof Gridded2DSet) {
                System.out.println(string + " Gridded2DSet " + DumpType.name(((Gridded2DSet)data).getType().toString()) + " Length = " + ((Gridded2DSet)data).getLength());
            } else if (data instanceof Integer1DSet) {
                System.out.println(string + " Integer1DSet " + DumpType.name(((Integer1DSet)data).getType().toString()) + " Range = 0 to " + (((Integer1DSet)data).getLength() - 1));
            } else if (data instanceof Linear1DSet) {
                System.out.println(string + " Linear1DSet " + DumpType.name(((Linear1DSet)data).getType().toString()) + " Range = " + ((Linear1DSet)data).getFirst() + " to " + ((Linear1DSet)data).getLast() + " step " + ((Linear1DSet)data).getStep());
            } else if (data instanceof Gridded1DSet) {
                System.out.println(string + " Gridded1DSet " + DumpType.name(((Gridded1DSet)data).getType().toString()) + "  Length = " + ((Gridded1DSet)data).getLength());
            } else if (data instanceof IntegerNDSet) {
                System.out.println(string + " IntegerNDSet: Dimension = " + ((IntegerNDSet)data).getDimension());
                int n = 0;
                while (n < ((IntegerNDSet)data).getDimension()) {
                    DumpType.dumpDT(((LinearNDSet)data).getLinear1DComponent(n), string + "   " + n + ".");
                    ++n;
                }
            } else if (data instanceof LinearNDSet) {
                System.out.println(string + " LinearNDSet: Dimension = " + ((LinearNDSet)data).getDimension());
                int n = 0;
                while (n < ((LinearNDSet)data).getDimension()) {
                    DumpType.dumpDT(((LinearNDSet)data).getLinear1DComponent(n), string + "   " + n + ".");
                    ++n;
                }
            } else if (data instanceof GriddedSet) {
                System.out.println(string + " GriddedSet " + DumpType.name(((GriddedSet)data).getType().toString()) + "  Dimension = " + ((GriddedSet)data).getDimension());
            } else if (data instanceof UnionSet) {
                System.out.println(string + " UnionSet " + DumpType.name(((UnionSet)data).getType().toString()) + "  Dimension = " + ((UnionSet)data).getDimension());
            } else if (data instanceof ProductSet) {
                System.out.println(string + " ProductSet " + DumpType.name(((ProductSet)data).getType().toString()) + "  Dimension = " + ((ProductSet)data).getDimension());
            } else if (data instanceof SampledSet) {
                System.out.println(string + " SampledSet " + DumpType.name(((SampledSet)data).getType().toString()) + "  Dimension = " + ((SampledSet)data).getDimension());
            } else if (data instanceof FloatSet) {
                System.out.println(string + " FloatSet " + DumpType.name(((FloatSet)data).getType().toString()) + " Dimension = " + ((FloatSet)data).getDimension());
            } else if (data instanceof DoubleSet) {
                System.out.println(string + " DoubleSet " + DumpType.name(((DoubleSet)data).getType().toString()) + "  Dimension = " + ((DoubleSet)data).getDimension());
            } else if (data instanceof SimpleSet) {
                System.out.println(string + " SimpleSet: ");
            } else if (data instanceof Set) {
                System.out.println(string + " Set: ");
            } else if (data instanceof RealTuple) {
                int n = ((RealTuple)data).getDimension();
                System.out.println(string + " RealTuple has " + n + " components:");
                RealTuple realTuple = (RealTuple)data;
                int n6 = 0;
                while (n6 < n) {
                    DumpType.dumpDT(((RealTuple)data).getComponent(n6), string + "   " + n6 + ".");
                    ++n6;
                }
            } else if (data instanceof Tuple) {
                int n = ((Tuple)data).getDimension();
                System.out.println(string + " Tuple has " + n + " components:");
                Tuple tuple = (Tuple)data;
                int n7 = 0;
                while (n7 < n) {
                    System.out.println("  ");
                    DumpType.dumpDT(((Tuple)data).getComponent(n7), string + "   " + n7 + ".");
                    ++n7;
                }
            } else if (data instanceof Text) {
                System.out.println(string + " Text: " + data);
            } else if (data instanceof Real) {
                System.out.println(string + " Real: " + data);
            } else {
                System.out.println("Unknown type for " + data);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:" + exception);
            return;
        }
    }

    private static String name(String string) {
        return string.substring(string.lastIndexOf("("));
    }

    public static void dumpMathType(MathType mathType) {
        DumpType.dumpMathType(mathType, System.out);
    }

    public static void dumpMathType(MathType mathType, OutputStream outputStream) {
        os = outputStream;
        DumpType.dumpMT(mathType, " ");
    }

    private static void dumpMT(MathType mathType, String string) {
        if (init) {
            System.out.println("VisAD MathType analysis");
        }
        init = false;
        try {
            if (mathType instanceof FunctionType) {
                System.out.println(string + " FunctionType: ");
                RealTupleType realTupleType = ((FunctionType)mathType).getDomain();
                int n = realTupleType.getDimension();
                System.out.println(string + " Domain has " + n + " components:");
                int n2 = 0;
                while (n2 < n) {
                    MathType mathType2 = realTupleType.getComponent(n2);
                    DumpType.dumpMT(mathType2, string + "  " + n2 + ".");
                    ++n2;
                }
                System.out.println(string + " Range:");
                MathType mathType3 = ((FunctionType)mathType).getRange();
                DumpType.dumpMT(mathType3, string + "  ");
            } else if (mathType instanceof SetType) {
                System.out.println(string + " SetType: " + mathType);
            } else if (mathType instanceof RealTupleType) {
                int n = ((RealTupleType)mathType).getDimension();
                System.out.println(string + " RealTupleType has " + n + " components:");
                int n3 = 0;
                while (n3 < n) {
                    MathType mathType4 = ((RealTupleType)mathType).getComponent(n3);
                    DumpType.dumpMT(mathType4, string + "  " + n3 + ".");
                    ++n3;
                }
            } else if (mathType instanceof TupleType) {
                int n = ((TupleType)mathType).getDimension();
                System.out.println(string + " TupleType has " + n + " components:");
                int n4 = 0;
                while (n4 < n) {
                    MathType mathType5 = ((TupleType)mathType).getComponent(n4);
                    DumpType.dumpMT(mathType5, string + "  " + n4 + ".");
                    ++n4;
                }
            } else if (mathType instanceof TextType) {
                System.out.println(string + " TextType: " + mathType);
            } else if (mathType instanceof RealType) {
                Set set;
                System.out.println(string + " RealType: " + mathType);
                string = string + "  ";
                System.out.println(string + " Name = " + ((RealType)mathType).toString());
                Unit unit = ((RealType)mathType).getDefaultUnit();
                String string2 = null;
                if (unit != null) {
                    string2 = unit.toString();
                }
                if (string2 != null) {
                    System.out.println(string + " Unit: " + string2);
                }
                if ((set = ((RealType)mathType).getDefaultSet()) != null) {
                    MathType mathType6 = set.getType();
                    System.out.println(string + " Set: " + mathType6);
                }
            } else if (mathType instanceof ScalarType) {
                System.out.println(string + " ScaleType: " + mathType);
            } else {
                System.out.println("Unknown type for " + mathType);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:" + exception);
            return;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: visad.jmet.DumpType <infile> ");
            System.exit(1);
            return;
        }
        DefaultFamily defaultFamily = new DefaultFamily("sample");
        URL uRL = null;
        try {
            uRL = new URL(stringArray[0]);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            if (uRL != null) {
                System.out.println("Trying URL " + uRL.toString());
            } else {
                System.out.println("Trying file " + stringArray[0]);
            }
            DataImpl dataImpl = uRL == null ? defaultFamily.open(stringArray[0]) : defaultFamily.open(uRL);
            System.out.println(stringArray[0] + ": " + dataImpl.getType().prettyString());
            System.out.println("  ");
            if (dataImpl != null) {
                DumpType.dumpDataType(dataImpl, System.out);
                MathType mathType = dataImpl.getType();
                init = true;
                System.out.println("  ");
                DumpType.dumpMathType(mathType, System.out);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(1);
        }
        System.exit(0);
    }
}

