/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.util.Enumeration;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3f;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.MouseBehavior;
import visad.VisADException;
import visad.VisADRay;
import visad.java3d.ImmersaDeskDisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.TrackdJNI;

public class WandBehaviorJ3D
extends MouseBehaviorJ3D
implements Runnable,
MouseBehavior {
    private static int DELAY = 50;
    private static int NSENSORS = 4;
    private static int NBUTTONS = 3;
    private static int HEAD = 0;
    private static int WAND = 1;
    private static int LEFT = 0;
    private static int CENTER = 1;
    private static int RIGHT = 2;
    private static int ELEVATION = 0;
    private static int AZIMUTH = 1;
    private static int ROLL = 2;
    ImmersaDeskDisplayRendererJ3D display_renderer;
    DisplayImpl display;
    private Thread wandThread;
    private TransformGroup vpTrans;
    private Transform3D init_trans;
    private float[] head_position = new float[3];
    private float[] wand_position = new float[3];
    private float[] wand_vector = new float[3];
    private float[] travel_position = new float[3];
    private boolean left = false;
    private boolean center = false;
    private boolean right = false;
    private boolean last_right;
    private DataRenderer direct_renderer = null;
    private TrackdJNI hack;
    private float TRAVEL_SPEED = 4.0f;
    private float HEAD_SCALE = 0.1f;
    private float WAND_SCALE = 1.5f;
    private float HEADX_OFFSET = 0.0f;
    private float HEADY_OFFSET = -3.0f;
    private float HEADZ_OFFSET = 5.0f;
    private float WANDX_OFFSET = -0.5f;
    private float WANDY_OFFSET = -2.0f;
    private float WANDZ_OFFSET = 0.0f;
    private float RAY_LENGTH = 2.0f;

    public void initialize() {
        this.wandThread = new Thread(this);
        this.wandThread.start();
        this.vpTrans = this.display_renderer.getViewTrans();
        this.init_trans = new Transform3D();
        this.vpTrans.getTransform(this.init_trans);
    }

    public void processStimulus(Enumeration enumeration) {
    }

    public void stop() {
        this.wandThread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        int[] nArray = new int[1];
        float[] fArray = new float[NSENSORS * 3];
        float[] fArray2 = new float[NSENSORS * 3];
        float[] fArray3 = new float[NSENSORS * 4 * 4];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[NBUTTONS];
        int n = 1000 / DELAY;
        this.travel_position[0] = 0.0f;
        this.travel_position[1] = 0.0f;
        this.travel_position[2] = 0.0f;
        while (this.wandThread == thread) {
            try {
                WandBehaviorJ3D wandBehaviorJ3D = this;
                synchronized (wandBehaviorJ3D) {
                    this.wait(DELAY);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            nArray[0] = NSENSORS;
            nArray2[0] = NBUTTONS;
            this.hack.getTrackd(nArray, fArray, fArray2, fArray3, nArray2, nArray3);
            this.last_right = this.right;
            this.left = nArray3[LEFT] != 0;
            this.center = nArray3[CENTER] != 0;
            this.right = nArray3[RIGHT] != 0;
            this.head_position[0] = fArray[3 * HEAD];
            this.head_position[1] = fArray[3 * HEAD + 1];
            this.head_position[2] = fArray[3 * HEAD + 2];
            this.wand_position[0] = fArray[3 * WAND];
            this.wand_position[1] = fArray[3 * WAND + 1];
            this.wand_position[2] = fArray[3 * WAND + 2];
            float f = (float)((double)fArray2[3 * WAND + ELEVATION] * (Math.PI / 180));
            float f2 = (float)((double)fArray2[3 * WAND + AZIMUTH] * (Math.PI / 180));
            float f3 = (float)((double)fArray2[3 * WAND + ROLL] * (Math.PI / 180));
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = -1.0f;
            float f7 = f4;
            float f8 = (float)(Math.cos(f) * (double)f5 - Math.sin(f) * (double)f6);
            float f9 = (float)(Math.cos(f) * (double)f6 + Math.sin(f) * (double)f5);
            f4 = (float)(Math.cos(f2) * (double)f7 + Math.sin(f2) * (double)f9);
            f5 = f8;
            f6 = (float)(Math.cos(f2) * (double)f9 - Math.sin(f2) * (double)f7);
            this.wand_vector[0] = f4;
            this.wand_vector[1] = f5;
            this.wand_vector[2] = f6;
            if (this.left) {
                float f10 = this.TRAVEL_SPEED * (float)DELAY / 1000.0f;
                this.travel_position[0] = this.travel_position[0] + f10 * this.wand_vector[0];
                this.travel_position[1] = this.travel_position[1] + f10 * this.wand_vector[1];
                this.travel_position[2] = this.travel_position[2] + f10 * this.wand_vector[2];
            }
            double d = this.HEAD_SCALE * (this.head_position[0] + this.travel_position[0] + this.HEADX_OFFSET);
            double d2 = this.HEAD_SCALE * (this.head_position[1] + this.travel_position[1] + this.HEADY_OFFSET);
            double d3 = this.HEAD_SCALE * (this.head_position[2] + this.travel_position[2] + this.HEADZ_OFFSET);
            double[] dArray = MouseBehaviorJ3D.static_make_matrix(0.0, 0.0, 0.0, 1.0, d, d2, d3);
            Transform3D transform3D = new Transform3D(this.init_trans);
            Transform3D transform3D2 = new Transform3D(dArray);
            transform3D.mul(transform3D2);
            this.vpTrans.setTransform(transform3D);
            Transform3D transform3D3 = new Transform3D();
            this.display_renderer.getTrans().getTransform(transform3D3);
            float f11 = this.WAND_SCALE * (this.wand_position[0] + this.travel_position[0] + this.WANDX_OFFSET);
            float f12 = this.WAND_SCALE * (this.wand_position[1] + this.travel_position[1] + this.WANDY_OFFSET);
            float f13 = this.WAND_SCALE * (this.wand_position[2] + this.travel_position[2] + this.WANDZ_OFFSET);
            Point3f point3f = new Point3f(f11, f12, f13);
            transform3D3.transform(point3f);
            f11 = point3f.x;
            f12 = point3f.y;
            f13 = point3f.z;
            this.display_renderer.setCursorOn(this.center);
            if (this.center) {
                this.display_renderer.setCursorLoc(f11, f12, f13);
            }
            if (this.right && this.display_renderer.anyDirects()) {
                float f14 = f11 + this.WAND_SCALE * (this.RAY_LENGTH * this.wand_vector[0]);
                float f15 = f12 + this.WAND_SCALE * (this.RAY_LENGTH * this.wand_vector[1]);
                float f16 = f13 + this.WAND_SCALE * (this.RAY_LENGTH * this.wand_vector[2]);
                point3f = new Point3f(f14, f15, f16);
                transform3D3.transform(point3f);
                f14 = point3f.x;
                f15 = point3f.y;
                f16 = point3f.z;
                float[] fArray4 = new float[]{f11, f12, f13, f14, f15, f16};
                this.display_renderer.setRayOn(true, fArray4);
                VisADRay visADRay = new VisADRay();
                visADRay.position[0] = f11;
                visADRay.position[1] = f12;
                visADRay.position[2] = f13;
                visADRay.vector[0] = this.wand_vector[0];
                visADRay.vector[1] = this.wand_vector[1];
                visADRay.vector[2] = this.wand_vector[2];
                if (!this.last_right) {
                    this.direct_renderer = this.display_renderer.findDirect(visADRay, 0);
                    if (this.direct_renderer == null) continue;
                    this.display_renderer.setDirectOn(true);
                    this.direct_renderer.drag_direct(visADRay, true, 0);
                    continue;
                }
                if (this.direct_renderer == null) continue;
                this.direct_renderer.drag_direct(visADRay, false, 0);
                continue;
            }
            this.display_renderer.setRayOn(false, null);
            this.direct_renderer = null;
        }
    }

    public WandBehaviorJ3D(ImmersaDeskDisplayRendererJ3D immersaDeskDisplayRendererJ3D, int n, int n2) throws VisADException {
        this.display_renderer = immersaDeskDisplayRendererJ3D;
        this.display = this.display_renderer.getDisplay();
        this.hack = new TrackdJNI(n, n2);
        this.last_right = false;
    }
}

