/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.java3d.DisplayAppletJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayPanelJ3D;
import visad.java3d.DisplayRendererJ3D;

public class VisADCanvasJ3D
extends Canvas3D {
    private static GraphicsConfiguration defaultConfig = VisADCanvasJ3D.makeConfig();
    private static final double METER_RATIO = 2.8222222222222223E-4;
    private DisplayRendererJ3D displayRenderer;
    private DisplayImplJ3D display;
    private Component component;
    Dimension prefSize = new Dimension(0, 0);
    boolean captureFlag = false;
    BufferedImage captureImage = null;
    private int width;
    private int height;
    private boolean offscreen = false;

    private static GraphicsConfiguration makeConfig() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        GraphicsConfiguration graphicsConfiguration = graphicsConfigTemplate3D.getBestConfiguration(graphicsDevice.getConfigurations());
        return graphicsConfiguration;
    }

    public boolean getOffscreen() {
        return this.offscreen;
    }

    public void renderField(int n) {
        this.displayRenderer.drawCursorStringVector(this);
    }

    public void postSwap() {
        if (this.captureFlag || this.display.hasSlaves()) {
            this.captureFlag = false;
            int n = ((Component)((Object)this)).getSize().width;
            int n2 = ((Component)((Object)this)).getSize().height;
            GraphicsContext3D graphicsContext3D = this.getGraphicsContext3D();
            Raster raster = new Raster();
            raster.setType(1);
            raster.setSize(n, n2);
            raster.setOffset(0, 0);
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage);
            raster.setImage(imageComponent2D);
            graphicsContext3D.readRaster(raster);
            ImageComponent2D imageComponent2D2 = raster.getImage();
            if (this.captureImage != null) {
                this.captureImage.flush();
            }
            this.captureImage = imageComponent2D2.getImage();
            this.displayRenderer.notifyCapture();
            if (this.display.hasSlaves()) {
                this.display.updateSlaves(this.captureImage);
            }
        }
        try {
            this.display.notifyListeners(3, 0, 0);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public static void main(String[] stringArray) throws RemoteException, VisADException {
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("offscreen", 300, 300);
        RealType[] realTypeArray = new RealType[]{RealType.Latitude, RealType.Longitude};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType realType = new RealType("vis_radiance", null, null);
        RealType realType2 = new RealType("ir_radiance", null, null);
        RealType[] realTypeArray2 = new RealType[]{realType, realType2};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        int n = 32;
        FlatField flatField = FlatField.makeField(functionType, n, false);
        displayImplJ3D.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        displayImplJ3D.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap(realType, Display.RGB));
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("ref_imaget1");
        dataReferenceImpl.setData(flatField);
        displayImplJ3D.addReference(dataReferenceImpl, null);
        JFrame jFrame = new JFrame("test off screen");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.setContentPane(jPanel);
        jFrame.pack();
        ((Component)jFrame).setSize(300, 300);
        ((Component)jFrame).setVisible(true);
        while (true) {
            Graphics graphics = jPanel.getGraphics();
            BufferedImage bufferedImage = displayImplJ3D.getImage();
            graphics.drawImage(bufferedImage, 0, 0, jPanel);
            System.out.println("drawImage");
            graphics.dispose();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void stop() {
        this.stopRenderer();
        this.display = null;
        this.displayRenderer = null;
        if (this.component instanceof DisplayPanelJ3D) {
            ((DisplayPanelJ3D)this.component).destroy();
        } else if (this.component instanceof DisplayAppletJ3D) {
            ((DisplayAppletJ3D)this.component).destroy();
        }
        this.component = null;
    }

    VisADCanvasJ3D(DisplayRendererJ3D displayRendererJ3D, Component component) {
        this(displayRendererJ3D, component, null);
    }

    VisADCanvasJ3D(DisplayRendererJ3D displayRendererJ3D, Component component, GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration == null ? defaultConfig : graphicsConfiguration);
        this.displayRenderer = displayRendererJ3D;
        this.display = (DisplayImplJ3D)displayRendererJ3D.getDisplay();
        this.component = component;
    }

    VisADCanvasJ3D(DisplayRendererJ3D displayRendererJ3D, int n, int n2) throws VisADException {
        super(defaultConfig);
        throw new VisADException("\n\nFor off screen rendering in Java3D\nplease edit visad/java3d/VisADCanvasJ3D.java as follows:\nremove or comment-out \"super(defaultConfig);\" and the\n  throw statement for this Exception,\nand un-comment the body of this constructor\n");
    }
}

