/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Texture;
import visad.BadMappingException;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayInterruptException;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.ShadowType;
import visad.TextType;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.ShadowRealTupleTypeJ3D;
import visad.java3d.ShadowRealTypeJ3D;
import visad.java3d.ShadowSetTypeJ3D;
import visad.java3d.ShadowTextTypeJ3D;
import visad.java3d.ShadowTupleTypeJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.util.Delay;

public abstract class RendererJ3D
extends DataRenderer {
    private static final int currentIndex = 0;
    Switch sw;
    BranchGroup swParent;
    BranchGroup[] branches;
    boolean[] switchFlags = new boolean[]{false, false, false};
    boolean[] branchNonEmpty = new boolean[]{false, false, false};
    int actualIndex;

    public void setLinks(DataDisplayLink[] dataDisplayLinkArray, DisplayImpl displayImpl) throws VisADException {
        if (this.getDisplay() != null || this.getLinks() != null) {
            throw new DisplayException("RendererJ3D.setLinks: already set\nyou are probably re-using a DataRenderer");
        }
        if (!(displayImpl instanceof DisplayImplJ3D)) {
            throw new DisplayException("RendererJ3D.setLinks: must be DisplayImplJ3D");
        }
        this.setDisplay(displayImpl);
        this.setDisplayRenderer(displayImpl.getDisplayRenderer());
        this.setLinks(dataDisplayLinkArray);
        this.sw = new Switch();
        this.sw.setCapability(12);
        this.sw.setCapability(13);
        this.sw.setCapability(14);
        this.sw.setCapability(17);
        this.sw.setCapability(18);
        this.swParent = new BranchGroup();
        this.swParent.setCapability(17);
        this.swParent.setCapability(12);
        this.swParent.addChild((Node)this.sw);
        this.addSwitch((DisplayRendererJ3D)this.getDisplayRenderer(), this.swParent);
        this.branches = new BranchGroup[3];
        int n = 0;
        while (n < 3) {
            this.branches[n] = new BranchGroup();
            this.branches[n].setCapability(12);
            this.branches[n].setCapability(13);
            this.branches[n].setCapability(14);
            this.sw.addChild((Node)this.branches[n]);
            ++n;
        }
        this.sw.setWhichChild(0);
        this.actualIndex = 0;
    }

    public void toggle(boolean bl) {
        if (this.sw != null) {
            this.sw.setWhichChild(bl ? 0 : 1);
        }
        super.toggle(bl);
    }

    public ShadowType makeShadowFunctionType(FunctionType functionType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowFunctionTypeJ3D(functionType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealTupleType(RealTupleType realTupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowRealTupleTypeJ3D(realTupleType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealType(RealType realType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowRealTypeJ3D(realType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowSetType(SetType setType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowSetTypeJ3D(setType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowTextType(TextType textType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowTextTypeJ3D(textType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowTupleType(TupleType tupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowTupleTypeJ3D(tupleType, dataDisplayLink, shadowType);
    }

    abstract void addSwitch(DisplayRendererJ3D var1, BranchGroup var2);

    public boolean doAction() throws VisADException, RemoteException {
        boolean bl = this.get_all_feasible();
        boolean bl2 = this.get_any_changed();
        boolean bl3 = this.get_any_transform_control();
        if (bl && (bl2 || bl3)) {
            BranchGroup branchGroup;
            this.clearAVControls();
            try {
                branchGroup = this.doTransform();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.clearBranch();
                branchGroup = null;
                new Delay(250);
                Runtime.getRuntime().gc();
                Runtime.getRuntime().runFinalization();
                try {
                    branchGroup = this.doTransform();
                }
                catch (BadMappingException badMappingException) {
                    this.addException(badMappingException);
                    branchGroup = null;
                }
                catch (UnimplementedException unimplementedException) {
                    this.addException(unimplementedException);
                    branchGroup = null;
                }
                catch (RemoteException remoteException) {
                    this.addException(remoteException);
                    branchGroup = null;
                }
                catch (DisplayInterruptException displayInterruptException) {
                    branchGroup = null;
                }
            }
            catch (BadMappingException badMappingException) {
                this.addException(badMappingException);
                branchGroup = null;
            }
            catch (UnimplementedException unimplementedException) {
                this.addException(unimplementedException);
                branchGroup = null;
            }
            catch (RemoteException remoteException) {
                this.addException(remoteException);
                branchGroup = null;
            }
            catch (DisplayInterruptException displayInterruptException) {
                branchGroup = null;
            }
            if (branchGroup != null) {
                boolean bl4 = false;
                branchGroup.detach();
                RendererJ3D rendererJ3D = this;
                synchronized (rendererJ3D) {
                    if (!this.branchNonEmpty[0] || this.branches[0].numChildren() == 0) {
                        this.branches[0].addChild((Node)branchGroup);
                        this.branchNonEmpty[0] = true;
                    } else {
                        this.flush((Group)this.branches[0]);
                        this.branches[0].setChild((Node)branchGroup, 0);
                    }
                }
            } else {
                this.clearBranch();
                bl = false;
                this.set_all_feasible(bl);
            }
        } else {
            DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
            int n = 0;
            while (n < dataDisplayLinkArray.length) {
                dataDisplayLinkArray[n].clearData();
                ++n;
            }
        }
        return bl && (bl2 || bl3);
    }

    public BranchGroup getBranch() {
        RendererJ3D rendererJ3D = this;
        synchronized (rendererJ3D) {
            if (this.branchNonEmpty[0]) {
                BranchGroup branchGroup = (BranchGroup)this.branches[0].getChild(0);
                Object var2_4 = null;
                return branchGroup;
            }
            BranchGroup branchGroup = null;
            Object var2_5 = null;
            return branchGroup;
        }
    }

    public void setBranchEarly(BranchGroup branchGroup) {
        ShadowTypeJ3D shadowTypeJ3D = (ShadowTypeJ3D)this.getLinks()[0].getShadow();
        shadowTypeJ3D.ensureNotEmpty(branchGroup);
        branchGroup.detach();
        RendererJ3D rendererJ3D = this;
        synchronized (rendererJ3D) {
            if (!this.branchNonEmpty[0] || this.branches[0].numChildren() == 0) {
                this.branches[0].addChild((Node)branchGroup);
                this.branchNonEmpty[0] = true;
            } else {
                this.flush((Group)this.branches[0]);
                this.branches[0].setChild((Node)branchGroup, 0);
            }
        }
    }

    public void clearBranch() {
        BranchGroup branchGroup = this.branches[0];
        synchronized (branchGroup) {
            if (this.branchNonEmpty[0]) {
                this.flush((Group)this.branches[0]);
                Enumeration enumeration = this.branches[0].getAllChildren();
                while (enumeration.hasMoreElements()) {
                    BranchGroup branchGroup2 = (BranchGroup)enumeration.nextElement();
                    branchGroup2.detach();
                }
            }
        }
        this.branchNonEmpty[0] = false;
    }

    public void flush(Group group) {
        Enumeration enumeration = group.getAllChildren();
        while (enumeration.hasMoreElements()) {
            BufferedImage[] bufferedImageArray;
            ImageComponent imageComponent;
            Texture texture;
            Appearance appearance;
            Node node = (Node)enumeration.nextElement();
            if (node instanceof Group) {
                this.flush((Group)node);
                continue;
            }
            if (!(node instanceof Shape3D) || !((Shape3D)node).getCapability(14) || (appearance = ((Shape3D)node).getAppearance()) == null || !appearance.getCapability(2) || (texture = appearance.getTexture()) == null || !texture.getCapability(4) || (imageComponent = texture.getImage(0)) == null || !imageComponent.getCapability(2)) continue;
            if (imageComponent instanceof ImageComponent2D) {
                bufferedImageArray = ((ImageComponent2D)imageComponent).getImage();
                if (bufferedImageArray == null) continue;
                bufferedImageArray.flush();
                continue;
            }
            if (!(imageComponent instanceof ImageComponent3D) || (bufferedImageArray = ((ImageComponent3D)imageComponent).getImage()) == null) continue;
            int n = 0;
            while (n < bufferedImageArray.length) {
                if (bufferedImageArray[n] != null) {
                    bufferedImageArray[n].flush();
                }
                ++n;
            }
        }
    }

    public void clearScene() {
        this.flush((Group)this.swParent);
        this.swParent.detach();
        ((DisplayRendererJ3D)this.getDisplayRenderer()).clearScene(this);
    }

    public abstract BranchGroup doTransform() throws VisADException, RemoteException;
}

