/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.ProjectionControl;
import visad.VisADException;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;

public class ProjectionControlJ3D
extends ProjectionControl {
    public static final int X_PLUS = 0;
    public static final int X_MINUS = 1;
    public static final int Y_PLUS = 2;
    public static final int Y_MINUS = 3;
    public static final int Z_PLUS = 4;
    public static final int Z_MINUS = 5;
    private transient Transform3D Matrix;
    transient Vector switches = new Vector();
    int which_child = 2;

    public void setMatrix(double[] dArray) throws VisADException, RemoteException {
        super.setMatrix(dArray);
        this.Matrix = new Transform3D(this.matrix);
        ((DisplayRendererJ3D)this.getDisplayRenderer()).setTransform3D(this.Matrix);
        if (!this.switches.isEmpty()) {
            this.selectSwitches();
        }
        this.changeControl(false);
    }

    public void setAspect(double[] dArray) throws VisADException, RemoteException {
        if (dArray == null || dArray.length != 3) {
            throw new DisplayException("aspect array must be length = 3");
        }
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(new Vector3d(dArray[0], dArray[1], dArray[2]));
        double[] dArray2 = new double[16];
        transform3D.get(dArray2);
        Transform3D transform3D2 = this.init();
        double[] dArray3 = new double[16];
        transform3D2.get(dArray3);
        this.setMatrix(this.getDisplay().multiply_matrix(dArray2, dArray3));
        this.saveProjection();
    }

    private Transform3D init() {
        Transform3D transform3D = new Transform3D();
        double d = 0.5;
        if (this.getDisplayRenderer().getMode2D()) {
            d = 0.65;
        }
        Transform3D transform3D2 = new Transform3D(MouseBehaviorJ3D.static_make_matrix(0.0, 0.0, 0.0, d, 0.0, 0.0, 0.0));
        transform3D.mul(transform3D2);
        return transform3D;
    }

    public void addPair(Switch switch_, DataRenderer dataRenderer) {
        this.switches.addElement(new SwitchProjection(switch_, dataRenderer));
        switch_.setWhichChild(this.which_child);
    }

    private void selectSwitches() {
        int n = this.which_child;
        Transform3D transform3D = new Transform3D(this.Matrix);
        transform3D.invert();
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(0.0, 0.0, 1.0);
        transform3D.transform(point3d);
        transform3D.transform(point3d2);
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        double d4 = Math.abs(d);
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        if (d6 >= d5 && d6 >= d4) {
            this.which_child = d3 > 0.0 ? 2 : 5;
        } else if (d5 >= d4) {
            this.which_child = d2 > 0.0 ? 1 : 4;
        } else {
            int n2 = this.which_child = d > 0.0 ? 0 : 3;
        }
        if (n == this.which_child) {
            return;
        }
        Enumeration enumeration = ((Vector)this.switches.clone()).elements();
        while (enumeration.hasMoreElements()) {
            SwitchProjection switchProjection = (SwitchProjection)enumeration.nextElement();
            switchProjection.swit.setWhichChild(this.which_child);
        }
    }

    public void clearSwitches(DataRenderer dataRenderer) {
        Enumeration enumeration = ((Vector)this.switches.clone()).elements();
        while (enumeration.hasMoreElements()) {
            SwitchProjection switchProjection = (SwitchProjection)enumeration.nextElement();
            if (!switchProjection.renderer.equals(dataRenderer)) continue;
            this.switches.removeElement(switchProjection);
        }
    }

    public void setOrthoView(int n) throws VisADException, RemoteException {
        double[] dArray;
        if (this.getDisplayRenderer().getMode2D()) {
            return;
        }
        switch (n) {
            case 4: {
                dArray = this.getDisplay().make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                dArray = this.getDisplay().make_matrix(0.0, 180.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                dArray = this.getDisplay().make_matrix(-90.0, 180.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 3: {
                dArray = this.getDisplay().make_matrix(90.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 0: {
                dArray = this.getDisplay().make_matrix(0.0, 90.0, 90.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 1: {
                dArray = this.getDisplay().make_matrix(0.0, -90.0, -90.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            default: {
                dArray = this.getDisplay().make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
        }
        this.setMatrix(this.getDisplay().multiply_matrix(dArray, this.getSavedProjectionMatrix()));
    }

    public ProjectionControlJ3D(DisplayImpl displayImpl) throws VisADException {
        super(displayImpl);
        this.Matrix = new Transform3D();
        this.matrix = new double[16];
        this.Matrix.get(this.matrix);
        this.saveProjection();
    }

    private class SwitchProjection {
        Switch swit;
        DataRenderer renderer;

        SwitchProjection(Switch switch_, DataRenderer dataRenderer) {
            this.swit = switch_;
            this.renderer = dataRenderer;
        }
    }
}

