/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3d;
import visad.DisplayRenderer;
import visad.KeyboardBehavior;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.VisADException;
import visad.java3d.DisplayRendererJ3D;

public class KeyboardBehaviorJ3D
extends Behavior
implements KeyboardBehavior {
    public static final int ROTATE_Z_POS = 7;
    public static final int ROTATE_Z_NEG = 8;
    public static final int ROTATE_X_POS = 9;
    public static final int ROTATE_X_NEG = 10;
    public static final int ROTATE_Y_POS = 11;
    public static final int ROTATE_Y_NEG = 12;
    private ProjectionControl proj;
    private DisplayRenderer displayRenderer;
    private MouseBehavior mouseBehavior;
    private double rotateAmount = 5.0;
    private double scaleAmount = 0.05;
    private double transAmount = 0.1;
    private int MAX_FUNCTIONS;
    private int[] functionKeys = null;
    private int[] functionMods = null;
    protected WakeupCondition wakeupCondition = null;

    public void initialize() {
        this.wakeupOn(this.wakeupCondition);
    }

    public void processStimulus(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (wakeupCriterion instanceof WakeupOnAWTEvent) {
                WakeupOnAWTEvent wakeupOnAWTEvent = (WakeupOnAWTEvent)wakeupCriterion;
                AWTEvent[] aWTEventArray = wakeupOnAWTEvent.getAWTEvent();
                int n = 0;
                while (n < aWTEventArray.length) {
                    if (aWTEventArray[n] instanceof KeyEvent) {
                        this.processKeyEvent((KeyEvent)aWTEventArray[n]);
                    }
                    ++n;
                }
            }
            this.wakeupOn(this.wakeupCondition);
        }
    }

    public void mapKeyToFunction(int n, int n2, int n3) {
        if (n < 0 || n >= this.MAX_FUNCTIONS) {
            return;
        }
        this.functionKeys[n] = n2;
        this.functionMods[n] = n3;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        int n3 = 0;
        while (n3 < this.MAX_FUNCTIONS) {
            if (this.functionKeys[n3] == n2 && n == this.functionMods[n3]) {
                this.execFunction(n3);
                break;
            }
            ++n3;
        }
    }

    public void execFunction(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray = null;
        double[] dArray2 = this.proj.getMatrix();
        switch (n) {
            case 10: {
                if (this.displayRenderer.getMode2D()) break;
                dArray = this.mouseBehavior.make_matrix(d6 += this.rotateAmount, d5, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 9: {
                if (this.displayRenderer.getMode2D()) break;
                dArray = this.mouseBehavior.make_matrix(d6 -= this.rotateAmount, d5, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 11: {
                if (this.displayRenderer.getMode2D()) break;
                dArray = this.mouseBehavior.make_matrix(d6, d5 += this.rotateAmount, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 12: {
                if (this.displayRenderer.getMode2D()) break;
                dArray = this.mouseBehavior.make_matrix(d6, d5 -= this.rotateAmount, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 7: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, d4 -= this.rotateAmount, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 8: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, d4 += this.rotateAmount, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 0: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, d, d2 += this.transAmount, 0.0);
                break;
            }
            case 1: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, d, d2 -= this.transAmount, 0.0);
                break;
            }
            case 2: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, d -= this.transAmount, d2, 0.0);
                break;
            }
            case 3: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, d += this.transAmount, d2, 0.0);
                break;
            }
            case 4: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, d3 += this.scaleAmount, 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, d3 -= this.scaleAmount, 0.0, 0.0, 0.0);
                break;
            }
            case 6: {
                dArray2 = this.proj.getSavedProjectionMatrix();
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
        }
        if (dArray != null) {
            dArray = this.mouseBehavior.multiply_matrix(dArray, dArray2);
            try {
                this.proj.setMatrix(dArray);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public KeyboardBehaviorJ3D(DisplayRendererJ3D displayRendererJ3D) {
        this.displayRenderer = displayRendererJ3D;
        boolean bl = this.displayRenderer.getMode2D();
        this.proj = this.displayRenderer.getDisplay().getProjectionControl();
        this.mouseBehavior = this.displayRenderer.getMouseBehavior();
        WakeupOnAWTEvent wakeupOnAWTEvent = new WakeupOnAWTEvent(401);
        WakeupCriterion[] wakeupCriterionArray = new WakeupCriterion[]{wakeupOnAWTEvent};
        this.wakeupCondition = new WakeupOr(wakeupCriterionArray);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        this.setSchedulingBounds((Bounds)boundingSphere);
        this.MAX_FUNCTIONS = 13;
        this.functionKeys = new int[this.MAX_FUNCTIONS];
        this.functionMods = new int[this.MAX_FUNCTIONS];
        this.mapKeyToFunction(0, 38, bl ? 0 : 2);
        this.mapKeyToFunction(1, 40, bl ? 0 : 2);
        this.mapKeyToFunction(2, 37, bl ? 0 : 2);
        this.mapKeyToFunction(3, 39, bl ? 0 : 2);
        this.mapKeyToFunction(4, 38, 1);
        this.mapKeyToFunction(5, 40, 1);
        this.mapKeyToFunction(6, 82, 2);
        this.mapKeyToFunction(9, 40, 0);
        this.mapKeyToFunction(10, 38, 0);
        this.mapKeyToFunction(11, 37, 0);
        this.mapKeyToFunction(12, 39, 0);
        this.mapKeyToFunction(7, 37, 1);
        this.mapKeyToFunction(8, 39, 1);
    }

    public KeyboardBehaviorJ3D(DisplayRendererJ3D displayRendererJ3D, int n) {
        this.displayRenderer = displayRendererJ3D;
        boolean bl = this.displayRenderer.getMode2D();
        this.proj = this.displayRenderer.getDisplay().getProjectionControl();
        this.mouseBehavior = this.displayRenderer.getMouseBehavior();
        WakeupOnAWTEvent wakeupOnAWTEvent = new WakeupOnAWTEvent(401);
        WakeupCriterion[] wakeupCriterionArray = new WakeupCriterion[]{wakeupOnAWTEvent};
        this.wakeupCondition = new WakeupOr(wakeupCriterionArray);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        this.setSchedulingBounds((Bounds)boundingSphere);
        this.MAX_FUNCTIONS = n;
        this.functionKeys = new int[this.MAX_FUNCTIONS];
        this.functionMods = new int[this.MAX_FUNCTIONS];
    }
}

