/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import visad.VisADException;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.VisADCanvasJ3D;
import visad.java3d.WandBehaviorJ3D;

public class ImmersaDeskDisplayRendererJ3D
extends DisplayRendererJ3D {
    private static final float[] box_verts = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f};
    private static final float[] cursor_verts = new float[]{0.0f, 0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.1f, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f};
    private static final float[] init_ray_verts = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -10.0f};
    private ColoringAttributes box_color = null;
    private ColoringAttributes cursor_color = null;
    private LineArray ray_geometry = null;
    private ColoringAttributes ray_color = null;
    private Switch ray_switch = null;
    private BranchGroup ray_on = null;
    private BranchGroup ray_off = null;
    private boolean rayOn = false;
    private WandBehaviorJ3D wand = null;

    public BranchGroup createSceneGraph(View view, TransformGroup transformGroup, VisADCanvasJ3D visADCanvasJ3D) {
        BranchGroup branchGroup = this.getRoot();
        if (branchGroup != null) {
            return branchGroup;
        }
        this.getDisplay().setMouseBehavior(this.wand);
        this.box_color = new ColoringAttributes();
        this.cursor_color = new ColoringAttributes();
        branchGroup = this.createBasicSceneGraph(view, transformGroup, visADCanvasJ3D, this.wand, this.box_color, this.cursor_color);
        TransformGroup transformGroup2 = this.getTrans();
        this.wand.initialize();
        LineArray lineArray = new LineArray(24, 1);
        lineArray.setCapability(1);
        lineArray.setCoordinates(0, box_verts);
        Appearance appearance = new Appearance();
        this.box_color.setCapability(0);
        this.box_color.setCapability(1);
        float[] fArray = this.getRendererControl().getBoxColor();
        this.box_color.setColor(fArray[0], fArray[1], fArray[2]);
        appearance.setColoringAttributes(this.box_color);
        Shape3D shape3D = new Shape3D((Geometry)lineArray, appearance);
        shape3D.setCapability(12);
        BranchGroup branchGroup2 = this.getBoxOnBranch();
        branchGroup2.addChild((Node)shape3D);
        Appearance appearance2 = new Appearance();
        this.cursor_color.setCapability(0);
        this.cursor_color.setCapability(1);
        float[] fArray2 = this.getRendererControl().getCursorColor();
        this.cursor_color.setColor(fArray2[0], fArray2[1], fArray2[2]);
        appearance2.setColoringAttributes(this.cursor_color);
        BranchGroup branchGroup3 = this.getCursorOnBranch();
        LineArray lineArray2 = new LineArray(6, 1);
        lineArray2.setCoordinates(0, cursor_verts);
        Shape3D shape3D2 = new Shape3D((Geometry)lineArray2, appearance2);
        branchGroup3.addChild((Node)shape3D2);
        this.ray_switch = new Switch();
        this.ray_switch.setCapability(17);
        this.ray_switch.setCapability(18);
        transformGroup2.addChild((Node)this.ray_switch);
        this.ray_on = new BranchGroup();
        this.ray_on.setCapability(12);
        this.ray_on.setCapability(13);
        this.ray_off = new BranchGroup();
        this.ray_switch.addChild((Node)this.ray_off);
        this.ray_switch.addChild((Node)this.ray_on);
        this.ray_switch.setWhichChild(1);
        this.ray_geometry = new LineArray(2, 1);
        this.ray_geometry.setCoordinates(0, init_ray_verts);
        this.ray_geometry.setCapability(0);
        this.ray_geometry.setCapability(1);
        Appearance appearance3 = new Appearance();
        this.ray_color = new ColoringAttributes();
        this.ray_color.setCapability(0);
        this.ray_color.setCapability(1);
        this.ray_color.setColor(1.0f, 1.0f, 1.0f);
        appearance3.setColoringAttributes(this.ray_color);
        Shape3D shape3D3 = new Shape3D((Geometry)this.ray_geometry, appearance3);
        this.ray_on.addChild((Node)shape3D3);
        Color3f color3f = new Color3f(0.6f, 0.6f, 0.6f);
        AmbientLight ambientLight = new AmbientLight(color3f);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)ambientLight);
        Color3f color3f2 = new Color3f(0.9f, 0.9f, 0.9f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, -1.0f);
        DirectionalLight directionalLight = new DirectionalLight(true, color3f2, vector3f);
        directionalLight.setInfluencingBounds((Bounds)boundingSphere);
        DirectionalLight directionalLight2 = new DirectionalLight(true, color3f2, vector3f2);
        directionalLight2.setInfluencingBounds((Bounds)boundingSphere);
        branchGroup.addChild((Node)directionalLight);
        branchGroup.addChild((Node)directionalLight2);
        return branchGroup;
    }

    public void setRayOn(boolean bl, float[] fArray) {
        this.rayOn = bl;
        if (this.ray_switch != null) {
            if (bl) {
                this.ray_geometry.setCoordinates(0, fArray);
                this.ray_switch.setWhichChild(1);
            } else {
                this.ray_switch.setWhichChild(0);
            }
        }
    }

    public void setBoxAspect(double[] dArray) {
        float[] fArray = new float[box_verts.length];
        int n = 0;
        while (n < box_verts.length) {
            fArray[n] = (float)((double)box_verts[n] * dArray[0]);
            fArray[n + 1] = (float)((double)box_verts[n + 1] * dArray[1]);
            fArray[n + 2] = (float)((double)box_verts[n + 2] * dArray[2]);
            n += 3;
        }
        BranchGroup branchGroup = this.getBoxOnBranch();
        Shape3D shape3D = (Shape3D)branchGroup.getChild(0);
        LineArray lineArray = (LineArray)shape3D.getGeometry();
        lineArray.setCoordinates(0, fArray);
    }

    public ImmersaDeskDisplayRendererJ3D(int n, int n2) throws VisADException {
        this.wand = new WandBehaviorJ3D(this, n, n2);
    }
}

