/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import visad.Control;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.VisADException;
import visad.java3d.DisplayRendererJ3D;
import visad.util.Util;

public class GraphicsModeControlJ3D
extends GraphicsModeControl {
    private float lineWidth = 1.0f;
    private float pointSize = 1.0f;
    private boolean pointMode = false;
    private boolean textureEnable = true;
    private boolean scaleEnable = false;
    private int transparencyMode = 0;
    private int projectionPolicy = 1;
    private int polygonMode = 2;
    private boolean missingTransparent = true;
    private int curvedSize = 10;

    public boolean getMode2D() {
        return this.getDisplayRenderer().getMode2D();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) throws VisADException, RemoteException {
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.lineWidth = f;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setLineWidth(float f, boolean bl) {
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.lineWidth = f;
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(float f) throws VisADException, RemoteException {
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.pointSize = f;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setPointSize(float f, boolean bl) {
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.pointSize = f;
    }

    public boolean getPointMode() {
        return this.pointMode;
    }

    public void setPointMode(boolean bl) throws VisADException, RemoteException {
        this.pointMode = bl;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setTextureEnable(boolean bl) throws VisADException, RemoteException {
        this.textureEnable = bl;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public boolean getTextureEnable() {
        return this.textureEnable;
    }

    public void setScaleEnable(boolean bl) throws VisADException, RemoteException {
        this.scaleEnable = bl;
        this.getDisplayRenderer().setScaleOn(bl);
        this.changeControl(true);
    }

    public boolean getScaleEnable() {
        return this.scaleEnable;
    }

    public int getTransparencyMode() {
        return this.transparencyMode;
    }

    public void setTransparencyMode(int n) throws VisADException, RemoteException {
        if (n != 3 && n != 2 && n != 4 && n != 0 && n != 1) {
            throw new DisplayException("GraphicsModeControlJ3D.setTransparencyMode: bad mode");
        }
        this.transparencyMode = n;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setProjectionPolicy(int n) throws VisADException, RemoteException {
        if (n == 0 || n == 1) {
            this.projectionPolicy = n;
            DisplayRendererJ3D displayRendererJ3D = (DisplayRendererJ3D)this.getDisplayRenderer();
            if (displayRendererJ3D != null) {
                displayRendererJ3D.getView().setProjectionPolicy(this.projectionPolicy);
            }
        } else {
            throw new DisplayException("GraphicsModeControlJ3D.setProjectionPolicy: bad policy");
        }
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public int getProjectionPolicy() {
        return this.projectionPolicy;
    }

    public void setPolygonMode(int n) throws VisADException, RemoteException {
        if (n != 2 && n != 1 && n != 0) {
            throw new DisplayException("GraphicsModeControlJ3D.setPolygonMode: bad mode");
        }
        this.polygonMode = n;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public int getPolygonMode() {
        return this.polygonMode;
    }

    public boolean getMissingTransparent() {
        return this.missingTransparent;
    }

    public void setMissingTransparent(boolean bl) {
        this.missingTransparent = bl;
    }

    public int getCurvedSize() {
        return this.curvedSize;
    }

    public void setCurvedSize(int n) {
        this.curvedSize = n;
    }

    public Object clone() {
        GraphicsModeControlJ3D graphicsModeControlJ3D = new GraphicsModeControlJ3D(this.getDisplay());
        graphicsModeControlJ3D.lineWidth = this.lineWidth;
        graphicsModeControlJ3D.pointSize = this.pointSize;
        graphicsModeControlJ3D.pointMode = this.pointMode;
        graphicsModeControlJ3D.textureEnable = this.textureEnable;
        graphicsModeControlJ3D.scaleEnable = this.scaleEnable;
        graphicsModeControlJ3D.transparencyMode = this.transparencyMode;
        graphicsModeControlJ3D.projectionPolicy = this.projectionPolicy;
        graphicsModeControlJ3D.missingTransparent = this.missingTransparent;
        graphicsModeControlJ3D.polygonMode = this.polygonMode;
        graphicsModeControlJ3D.curvedSize = this.curvedSize;
        return graphicsModeControlJ3D;
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof GraphicsModeControlJ3D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        GraphicsModeControlJ3D graphicsModeControlJ3D = (GraphicsModeControlJ3D)control;
        boolean bl = false;
        boolean bl2 = false;
        if (!Util.isApproximatelyEqual(this.lineWidth, graphicsModeControlJ3D.lineWidth)) {
            bl = true;
            bl2 = true;
            this.lineWidth = graphicsModeControlJ3D.lineWidth;
        }
        if (!Util.isApproximatelyEqual(this.pointSize, graphicsModeControlJ3D.pointSize)) {
            bl = true;
            bl2 = true;
            this.pointSize = graphicsModeControlJ3D.pointSize;
        }
        if (this.pointMode != graphicsModeControlJ3D.pointMode) {
            bl = true;
            bl2 = true;
            this.pointMode = graphicsModeControlJ3D.pointMode;
        }
        if (this.textureEnable != graphicsModeControlJ3D.textureEnable) {
            bl = true;
            bl2 = true;
            this.textureEnable = graphicsModeControlJ3D.textureEnable;
        }
        if (this.scaleEnable != graphicsModeControlJ3D.scaleEnable) {
            bl = true;
            this.getDisplayRenderer().setScaleOn(this.scaleEnable);
            this.scaleEnable = graphicsModeControlJ3D.scaleEnable;
        }
        if (this.transparencyMode != graphicsModeControlJ3D.transparencyMode) {
            bl = true;
            bl2 = true;
            this.transparencyMode = graphicsModeControlJ3D.transparencyMode;
        }
        if (this.projectionPolicy != graphicsModeControlJ3D.projectionPolicy) {
            bl = true;
            bl2 = true;
            this.projectionPolicy = graphicsModeControlJ3D.projectionPolicy;
            DisplayRendererJ3D displayRendererJ3D = (DisplayRendererJ3D)this.getDisplayRenderer();
            if (displayRendererJ3D != null) {
                displayRendererJ3D.getView().setProjectionPolicy(this.projectionPolicy);
            }
        }
        if (this.polygonMode != graphicsModeControlJ3D.polygonMode) {
            bl = true;
            this.polygonMode = graphicsModeControlJ3D.polygonMode;
        }
        if (this.missingTransparent != graphicsModeControlJ3D.missingTransparent) {
            bl = true;
            this.missingTransparent = graphicsModeControlJ3D.missingTransparent;
        }
        if (this.curvedSize != graphicsModeControlJ3D.curvedSize) {
            bl = true;
            this.curvedSize = graphicsModeControlJ3D.curvedSize;
        }
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
        if (bl2) {
            this.getDisplay().reDisplayAll();
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        GraphicsModeControlJ3D graphicsModeControlJ3D = (GraphicsModeControlJ3D)object;
        boolean bl = false;
        if (!Util.isApproximatelyEqual(this.lineWidth, graphicsModeControlJ3D.lineWidth)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.pointSize, graphicsModeControlJ3D.pointSize)) {
            return false;
        }
        if (this.pointMode != graphicsModeControlJ3D.pointMode) {
            return false;
        }
        if (this.textureEnable != graphicsModeControlJ3D.textureEnable) {
            return false;
        }
        if (this.scaleEnable != graphicsModeControlJ3D.scaleEnable) {
            return false;
        }
        if (this.transparencyMode != graphicsModeControlJ3D.transparencyMode) {
            return false;
        }
        if (this.projectionPolicy != graphicsModeControlJ3D.projectionPolicy) {
            return false;
        }
        if (this.polygonMode != graphicsModeControlJ3D.polygonMode) {
            return false;
        }
        if (this.missingTransparent != graphicsModeControlJ3D.missingTransparent) {
            return false;
        }
        return this.curvedSize == graphicsModeControlJ3D.curvedSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GraphicsModeControlJ3D[");
        stringBuffer.append("lw ");
        stringBuffer.append(this.lineWidth);
        stringBuffer.append(",ps ");
        stringBuffer.append(this.pointSize);
        stringBuffer.append(this.pointMode ? "pm" : "!pm");
        stringBuffer.append(this.textureEnable ? "te" : "!te");
        stringBuffer.append(this.scaleEnable ? "se" : "!se");
        stringBuffer.append(this.missingTransparent ? "mt" : "!mt");
        stringBuffer.append(",tm ");
        stringBuffer.append(this.transparencyMode);
        stringBuffer.append(",pp ");
        stringBuffer.append(this.projectionPolicy);
        stringBuffer.append(",pm ");
        stringBuffer.append(this.polygonMode);
        stringBuffer.append(",cs ");
        stringBuffer.append(this.curvedSize);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public GraphicsModeControlJ3D(DisplayImpl displayImpl) {
        super(displayImpl);
        DisplayRendererJ3D displayRendererJ3D = (DisplayRendererJ3D)this.getDisplayRenderer();
        if (displayRendererJ3D != null && displayRendererJ3D.getMode2D()) {
            this.projectionPolicy = 0;
            displayRendererJ3D.getView().setProjectionPolicy(this.projectionPolicy);
        }
    }
}

