/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import visad.AxisScale;
import visad.ColorAlphaControl;
import visad.ColorControl;
import visad.ContourControl;
import visad.Control;
import visad.ControlEvent;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.Flow1Control;
import visad.Flow2Control;
import visad.GraphicsModeControl;
import visad.MouseBehavior;
import visad.PlotText;
import visad.ProjectionControl;
import visad.RangeControl;
import visad.RealType;
import visad.RendererControl;
import visad.RendererSourceListener;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.TextControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.VisADTriangleArray;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.java3d.ValueControlJ3D;
import visad.java3d.VisADCanvasJ3D;
import visad.util.Util;

public abstract class DisplayRendererJ3D
extends DisplayRenderer
implements RendererSourceListener {
    private View view;
    private VisADCanvasJ3D canvas;
    private BranchGroup root = null;
    private TransformGroup trans = null;
    private OrderedGroup non_direct = null;
    private TransformGroup vpTrans = null;
    private MouseBehaviorJ3D mouse = null;
    private double back_clip = 0.0;
    private double front_clip = 0.0;
    private ColoringAttributes box_color = null;
    private ColoringAttributes cursor_color = null;
    private Background background = null;
    private TransformGroup cursor_trans = null;
    private Switch cursor_switch = null;
    private BranchGroup cursor_on = null;
    private BranchGroup cursor_off = null;
    private boolean cursorOn = false;
    private boolean directOn = false;
    private Switch box_switch = null;
    private BranchGroup box_on = null;
    private BranchGroup box_off = null;
    private boolean boxOn = false;
    private Switch scale_switch = null;
    private BranchGroup scale_on = null;
    private BranchGroup scale_off = null;
    private Vector axis_vector = new Vector();
    private Vector directs = new Vector();
    private float cursorX;
    private float cursorY;
    private float cursorZ;
    private float line_x;
    private float line_y;
    private float line_z;
    private float point_x;
    private float point_y;
    private float point_z;
    private Method modelClipSetEnable = null;
    private Method modelClipSetPlane = null;
    private Method modelClipAddScope = null;
    private Object modelClip = null;
    private boolean[] modelClipEnables = new boolean[]{false, false, false, false, false, false};
    private static /* synthetic */ Class class$Ljavax$media$j3d$Canvas3D;
    private static /* synthetic */ Class class$Ljavax$vecmath$Vector4d;
    private static /* synthetic */ Class class$Ljavax$media$j3d$Group;
    private static /* synthetic */ Class class$Ljavax$media$j3d$Bounds;
    private static /* synthetic */ Class class$Lvisad$java3d$AnimationControlJ3D;
    private static /* synthetic */ Class class$Lvisad$Flow1Control;
    private static /* synthetic */ Class class$Lvisad$Flow2Control;

    public void destroy() {
        if (this.canvas != null) {
            this.canvas.stop();
        }
        if (this.mouse != null) {
            this.mouse.destroy();
        }
        if (this.root != null) {
            this.root.detach();
            this.root = null;
        }
        this.trans = null;
        this.vpTrans = null;
        this.non_direct = null;
        this.view = null;
        this.canvas = null;
    }

    public void setDisplay(DisplayImpl displayImpl) throws VisADException {
        super.setDisplay(displayImpl);
        displayImpl.addRendererSourceListener(this);
        this.boxOn = this.getRendererControl().getBoxOn();
    }

    public View getView() {
        return this.view;
    }

    public TransformGroup getViewTrans() {
        return this.vpTrans;
    }

    public VisADCanvasJ3D getCanvas() {
        return this.canvas;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        while (bufferedImage == null) {
            try {
                ProjectionControl projectionControl = this.getDisplay().getProjectionControl();
                DisplayRendererJ3D displayRendererJ3D = this;
                synchronized (displayRendererJ3D) {
                    this.canvas.captureFlag = true;
                    if (this.canvas.getOffscreen()) {
                        try {
                            Method method = (class$Ljavax$media$j3d$Canvas3D != null ? class$Ljavax$media$j3d$Canvas3D : DisplayRendererJ3D.class$("javax.media.j3d.Canvas3D")).getMethod("renderOffScreenBuffer", new Class[0]);
                            method.invoke((Object)this.canvas, new Object[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                    try {
                        projectionControl.setMatrix(projectionControl.getMatrix());
                    }
                    catch (RemoteException remoteException) {
                    }
                    catch (VisADException visADException) {
                        // empty catch block
                    }
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bufferedImage = this.canvas.captureImage;
            this.canvas.captureImage = null;
        }
        return bufferedImage;
    }

    void notifyCapture() {
        DisplayRendererJ3D displayRendererJ3D = this;
        synchronized (displayRendererJ3D) {
            this.notify();
        }
    }

    public BranchGroup getRoot() {
        return this.root;
    }

    public void initControl(RendererControl rendererControl) {
        Color3f color3f = new Color3f();
        if (this.box_color != null) {
            this.box_color.getColor(color3f);
            try {
                rendererControl.setBoxColor(color3f.x, color3f.y, color3f.z);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.cursor_color != null) {
            this.cursor_color.getColor(color3f);
            try {
                rendererControl.setCursorColor(color3f.x, color3f.y, color3f.z);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.background != null) {
            this.background.getColor(color3f);
            try {
                rendererControl.setBackgroundColor(color3f.x, color3f.y, color3f.z);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            rendererControl.setBoxOn(this.boxOn);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void controlChanged(ControlEvent controlEvent) {
        boolean bl;
        float[] fArray;
        RendererControl rendererControl = (RendererControl)controlEvent.getControl();
        Color3f color3f = new Color3f();
        if (this.box_color != null) {
            fArray = rendererControl.getBoxColor();
            this.box_color.getColor(color3f);
            if (!(Util.isApproximatelyEqual(fArray[0], color3f.x) && Util.isApproximatelyEqual(fArray[1], color3f.y) && Util.isApproximatelyEqual(fArray[2], color3f.z))) {
                this.box_color.setColor(fArray[0], fArray[1], fArray[2]);
            }
        }
        if (this.cursor_color != null) {
            fArray = rendererControl.getCursorColor();
            this.cursor_color.getColor(color3f);
            if (!(Util.isApproximatelyEqual(fArray[0], color3f.x) && Util.isApproximatelyEqual(fArray[1], color3f.y) && Util.isApproximatelyEqual(fArray[2], color3f.z))) {
                this.cursor_color.setColor(fArray[0], fArray[1], fArray[2]);
            }
        }
        fArray = rendererControl.getBackgroundColor();
        this.background.getColor(color3f);
        if (!(Util.isApproximatelyEqual(fArray[0], color3f.x) && Util.isApproximatelyEqual(fArray[1], color3f.y) && Util.isApproximatelyEqual(fArray[2], color3f.z))) {
            this.background.setColor(fArray[0], fArray[1], fArray[2]);
        }
        if ((bl = rendererControl.getBoxOn()) != this.boxOn) {
            this.boxOn = bl;
            this.box_switch.setWhichChild(this.boxOn ? 1 : 0);
        }
    }

    public TransformGroup getTrans() {
        return this.trans;
    }

    public BranchGroup getCursorOnBranch() {
        return this.cursor_on;
    }

    public BranchGroup getBoxOnBranch() {
        return this.box_on;
    }

    public void setCursorOn(boolean bl) {
        this.cursorOn = bl;
        if (bl) {
            this.cursor_switch.setWhichChild(1);
            this.setCursorStringVector();
        } else {
            this.cursor_switch.setWhichChild(0);
            this.setCursorStringVector(null);
        }
    }

    public void setDirectOn(boolean bl) {
        this.directOn = bl;
        if (!bl) {
            this.setCursorStringVector(null);
        }
    }

    public abstract BranchGroup createSceneGraph(View var1, TransformGroup var2, VisADCanvasJ3D var3);

    public BranchGroup createBasicSceneGraph(View view, TransformGroup transformGroup, VisADCanvasJ3D visADCanvasJ3D, MouseBehaviorJ3D mouseBehaviorJ3D) {
        this.box_color = new ColoringAttributes();
        this.box_color.setCapability(0);
        this.box_color.setCapability(1);
        this.cursor_color = new ColoringAttributes();
        this.cursor_color.setCapability(0);
        this.cursor_color.setCapability(1);
        return this.createBasicSceneGraph(view, transformGroup, visADCanvasJ3D, mouseBehaviorJ3D, this.box_color, this.cursor_color);
    }

    public BranchGroup createBasicSceneGraph(View view, TransformGroup transformGroup, VisADCanvasJ3D visADCanvasJ3D, MouseBehaviorJ3D mouseBehaviorJ3D, ColoringAttributes coloringAttributes, ColoringAttributes coloringAttributes2) {
        if (this.root != null) {
            return this.root;
        }
        this.mouse = mouseBehaviorJ3D;
        this.view = view;
        this.vpTrans = transformGroup;
        this.box_color = coloringAttributes;
        this.cursor_color = coloringAttributes2;
        this.back_clip = this.view.getBackClipDistance();
        this.front_clip = this.view.getFrontClipDistance();
        view.setDepthBufferFreezeTransparent(false);
        this.canvas = visADCanvasJ3D;
        this.root = new BranchGroup();
        this.root.setCapability(17);
        this.root.setCapability(12);
        this.root.setCapability(13);
        this.root.setCapability(14);
        this.setTransform3D(null);
        this.root.addChild((Node)this.trans);
        this.background = new Background();
        this.background.setCapability(17);
        this.background.setCapability(16);
        float[] fArray = this.getRendererControl().getBackgroundColor();
        this.background.setColor(fArray[0], fArray[1], fArray[2]);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        this.background.setApplicationBounds((Bounds)boundingSphere);
        this.root.addChild((Node)this.background);
        this.non_direct = new OrderedGroup();
        this.non_direct.setCapability(12);
        this.non_direct.setCapability(13);
        this.non_direct.setCapability(14);
        this.non_direct.setCapability(1);
        this.trans.addChild((Node)this.non_direct);
        this.cursor_trans = new TransformGroup();
        this.cursor_trans.setCapability(17);
        this.cursor_trans.setCapability(18);
        this.cursor_trans.setCapability(12);
        this.cursor_trans.setCapability(13);
        this.cursor_trans.setCapability(14);
        this.trans.addChild((Node)this.cursor_trans);
        this.cursor_switch = new Switch();
        this.cursor_switch.setCapability(17);
        this.cursor_switch.setCapability(18);
        this.cursor_trans.addChild((Node)this.cursor_switch);
        this.cursor_on = new BranchGroup();
        this.cursor_on.setCapability(12);
        this.cursor_on.setCapability(13);
        this.cursor_off = new BranchGroup();
        this.cursor_switch.addChild((Node)this.cursor_off);
        this.cursor_switch.addChild((Node)this.cursor_on);
        this.cursor_switch.setWhichChild(0);
        this.cursorOn = false;
        this.box_switch = new Switch();
        this.box_switch.setCapability(17);
        this.box_switch.setCapability(18);
        this.trans.addChild((Node)this.box_switch);
        this.box_on = new BranchGroup();
        this.box_on.setCapability(12);
        this.box_on.setCapability(13);
        this.box_off = new BranchGroup();
        this.box_switch.addChild((Node)this.box_off);
        this.box_switch.addChild((Node)this.box_on);
        this.box_switch.setWhichChild(1);
        try {
            this.setBoxOn(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scale_switch = new Switch();
        this.scale_switch.setCapability(17);
        this.scale_switch.setCapability(18);
        this.trans.addChild((Node)this.scale_switch);
        this.scale_on = new BranchGroup();
        this.scale_on.setCapability(12);
        this.scale_on.setCapability(13);
        this.scale_on.setCapability(14);
        this.scale_off = new BranchGroup();
        this.scale_switch.addChild((Node)this.scale_off);
        this.scale_switch.addChild((Node)this.scale_on);
        this.scale_switch.setWhichChild(0);
        try {
            Class<?> clazz = Class.forName("javax.media.j3d.ModelClip");
            Class[] classArray = new Class[]{};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            classArray = new Class[]{Integer.TYPE, Boolean.TYPE};
            this.modelClipSetEnable = clazz.getMethod("setEnable", classArray);
            classArray = new Class[]{Integer.TYPE, class$Ljavax$vecmath$Vector4d != null ? class$Ljavax$vecmath$Vector4d : (class$Ljavax$vecmath$Vector4d = DisplayRendererJ3D.class$("javax.vecmath.Vector4d"))};
            this.modelClipSetPlane = clazz.getMethod("setPlane", classArray);
            classArray = new Class[]{class$Ljavax$media$j3d$Group != null ? class$Ljavax$media$j3d$Group : (class$Ljavax$media$j3d$Group = DisplayRendererJ3D.class$("javax.media.j3d.Group"))};
            this.modelClipAddScope = clazz.getMethod("addScope", classArray);
            classArray = new Class[]{Integer.TYPE};
            Method method = clazz.getMethod("setCapability", classArray);
            classArray = new Class[]{class$Ljavax$media$j3d$Bounds != null ? class$Ljavax$media$j3d$Bounds : (class$Ljavax$media$j3d$Bounds = DisplayRendererJ3D.class$("javax.media.j3d.Bounds"))};
            Method method2 = clazz.getMethod("setInfluencingBounds", classArray);
            this.modelClip = constructor.newInstance(new Object[0]);
            int n = clazz.getField("ALLOW_PLANE_WRITE").getInt(this.modelClip);
            method.invoke(this.modelClip, new Integer(n));
            int n2 = clazz.getField("ALLOW_ENABLE_WRITE").getInt(this.modelClip);
            method.invoke(this.modelClip, new Integer(n2));
            Boolean bl = new Boolean(false);
            int n3 = 0;
            while (n3 < 6) {
                this.modelClipSetEnable.invoke(this.modelClip, new Integer(n3), bl);
                ++n3;
            }
            BoundingSphere boundingSphere2 = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
            method2.invoke(this.modelClip, boundingSphere2);
            this.background.setApplicationBounds((Bounds)boundingSphere);
            this.modelClipAddScope.invoke(this.modelClip, this.non_direct);
            this.trans.addChild((Node)this.modelClip);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return this.root;
    }

    public void setClip(int n, boolean bl, float f, float f2, float f3, float f4) throws VisADException {
        if (n < 0 || 5 < n) {
            throw new DisplayException("plane must be in 0,...,5 range " + n);
        }
        if (this.modelClip == null || this.modelClipSetEnable == null || this.modelClipSetPlane == null) {
            throw new DisplayException("model clipping not supported in this version of Java3D");
        }
        Vector4d vector4d = new Vector4d((double)f, (double)f2, (double)f3, (double)f4);
        try {
            Object[] objectArray = new Object[]{new Integer(n), new Boolean(bl)};
            this.modelClipSetEnable.invoke(this.modelClip, objectArray);
            objectArray = new Object[]{new Integer(n), vector4d};
            this.modelClipSetPlane.invoke(this.modelClip, objectArray);
            this.modelClipEnables[n] = bl;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private void clipOff() {
        try {
            int n = 0;
            while (n < 6) {
                if (this.modelClipEnables[n]) {
                    Object[] objectArray = new Object[]{new Integer(n), new Boolean(false)};
                    this.modelClipSetEnable.invoke(this.modelClip, objectArray);
                }
                ++n;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private void clipOn() {
        try {
            int n = 0;
            while (n < 6) {
                if (this.modelClipEnables[n]) {
                    Object[] objectArray = new Object[]{new Integer(n), new Boolean(true)};
                    this.modelClipSetEnable.invoke(this.modelClip, objectArray);
                }
                ++n;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public MouseBehavior getMouseBehavior() {
        return this.mouse;
    }

    public void addSceneGraphComponent(Group group) {
        this.non_direct.addChild((Node)group);
    }

    public void addDirectManipulationSceneGraphComponent(Group group, DirectManipulationRendererJ3D directManipulationRendererJ3D) {
        this.non_direct.addChild((Node)group);
        this.directs.addElement(directManipulationRendererJ3D);
    }

    public void clearScene(DataRenderer dataRenderer) {
        this.directs.removeElement(dataRenderer);
    }

    public double[] getCursor() {
        double[] dArray = new double[]{this.cursorX, this.cursorY, this.cursorZ};
        return dArray;
    }

    public void depth_cursor(VisADRay visADRay) {
        this.line_x = (float)visADRay.vector[0];
        this.line_y = (float)visADRay.vector[1];
        this.line_z = (float)visADRay.vector[2];
        this.point_x = this.cursorX;
        this.point_y = this.cursorY;
        this.point_z = this.cursorZ;
    }

    public void drag_depth(float f) {
        this.cursorX = this.point_x + f * this.line_x;
        this.cursorY = this.point_y + f * this.line_y;
        this.cursorZ = this.point_z + f * this.line_z;
        this.setCursorLoc();
    }

    public void drag_cursor(VisADRay visADRay, boolean bl) {
        float f = (float)visADRay.position[0];
        float f2 = (float)visADRay.position[1];
        float f3 = (float)visADRay.position[2];
        float f4 = (float)visADRay.vector[0];
        float f5 = (float)visADRay.vector[1];
        float f6 = (float)visADRay.vector[2];
        if (bl) {
            this.line_x = f4;
            this.line_y = f5;
            this.line_z = f6;
        }
        float f7 = (this.cursorX - f) * this.line_x + (this.cursorY - f2) * this.line_y + (this.cursorZ - f3) * this.line_z;
        float f8 = f4 * this.line_x + f5 * this.line_y + f6 * this.line_z;
        if ((double)f8 == 0.0) {
            return;
        }
        this.cursorX = f + (f7 /= f8) * f4;
        this.cursorY = f2 + f7 * f5;
        this.cursorZ = f3 + f7 * f6;
        this.setCursorLoc();
    }

    private void setCursorLoc() {
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(this.cursorX, this.cursorY, this.cursorZ));
        this.cursor_trans.setTransform(transform3D);
        if (this.cursorOn) {
            this.setCursorStringVector();
        }
    }

    public void setCursorLoc(float f, float f2, float f3) {
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(f, f2, f3));
        this.cursor_trans.setTransform(transform3D);
        if (this.cursorOn) {
            this.setCursorStringVector();
        }
    }

    public void drawCursorStringVector(VisADCanvasJ3D visADCanvasJ3D) {
        Serializable serializable;
        Object object;
        Cloneable cloneable;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Transform3D transform3D;
        ColoringAttributes coloringAttributes;
        Appearance appearance;
        Object object8;
        GraphicsContext3D graphicsContext3D = visADCanvasJ3D.getGraphicsContext3D();
        try {
            object8 = this.getCursorColor();
            appearance = new Appearance();
            coloringAttributes = new ColoringAttributes();
            coloringAttributes.setColor(new Color3f(object8));
            appearance.setColoringAttributes(coloringAttributes);
            graphicsContext3D.setAppearance(appearance);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object8 = new Point3d();
        appearance = new Point3d();
        coloringAttributes = new Point3d();
        visADCanvasJ3D.getPixelLocationInImagePlate(1, 10, (Point3d)object8);
        visADCanvasJ3D.getPixelLocationInImagePlate(10, 10, (Point3d)appearance);
        visADCanvasJ3D.getPixelLocationInImagePlate(1, 1, (Point3d)coloringAttributes);
        DisplayImpl displayImpl = this.getDisplay();
        if (displayImpl != null && displayImpl.getGraphicsModeControl() != null && this.getDisplay().getGraphicsModeControl().getProjectionPolicy() == 1) {
            transform3D = new Point3d();
            object7 = new Point3d();
            visADCanvasJ3D.getLeftEyeInImagePlate((Point3d)transform3D);
            visADCanvasJ3D.getRightEyeInImagePlate((Point3d)object7);
            object6 = new Point3d((transform3D.x + object7.x) / 2.0, (transform3D.y + object7.y) / 2.0, (transform3D.z + object7.z) / 2.0);
            double d = 0.3;
            object8.x = d * object8.x + (1.0 - d) * object6.x;
            object8.y = d * object8.y + (1.0 - d) * object6.y;
            object8.z = d * object8.z + (1.0 - d) * object6.z;
            appearance.x = d * appearance.x + (1.0 - d) * object6.x;
            appearance.y = d * appearance.y + (1.0 - d) * object6.y;
            appearance.z = d * appearance.z + (1.0 - d) * object6.z;
            coloringAttributes.x = d * coloringAttributes.x + (1.0 - d) * object6.x;
            coloringAttributes.y = d * coloringAttributes.y + (1.0 - d) * object6.y;
            coloringAttributes.z = d * coloringAttributes.z + (1.0 - d) * object6.z;
        }
        transform3D = new Transform3D();
        visADCanvasJ3D.getImagePlateToVworld(transform3D);
        transform3D.transform((Point3d)object8);
        transform3D.transform((Point3d)appearance);
        transform3D.transform((Point3d)coloringAttributes);
        object7 = new double[]{object8.x, object8.y, object8.z};
        object6 = new double[]{appearance.x - object8.x, appearance.y - object8.y, appearance.z - object8.z};
        double[] dArray = new double[]{coloringAttributes.x - object8.x, coloringAttributes.y - object8.y, coloringAttributes.z - object8.z};
        if (this.cursorOn || this.directOn) {
            object5 = this.getCursorStringVector().elements();
            while (object5.hasMoreElements()) {
                object4 = (String)object5.nextElement();
                try {
                    object3 = PlotText.render_label((String)object4, (double[])object7, (double[])object6, dArray, false);
                    graphicsContext3D.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry((VisADGeometryArray)object3));
                    Object object9 = object7;
                    object9[1] = object9[1] - 1.2 * dArray[1];
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
            }
        }
        object5 = new double[]{coloringAttributes.x, -coloringAttributes.y, coloringAttributes.z};
        object4 = this.getDisplay().getRendererVector();
        object3 = ((Vector)object4).elements();
        while (object3.hasMoreElements()) {
            object2 = (String[])object3.nextElement();
            cloneable = object2.getExceptionVector();
            object = cloneable.elements();
            while (object.hasMoreElements()) {
                serializable = (Exception)object.nextElement();
                String string = serializable.getMessage();
                try {
                    VisADLineArray visADLineArray = PlotText.render_label(string, (double[])object5, (double[])object6, dArray, false);
                    graphicsContext3D.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(visADLineArray));
                    Object object10 = object5;
                    object10[1] = object10[1] + 1.2 * dArray[1];
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
            }
        }
        if (this.getWaitFlag()) {
            try {
                object2 = PlotText.render_label("please wait . . .", (double[])object5, (double[])object6, dArray, false);
                graphicsContext3D.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry((VisADGeometryArray)object2));
                Object object11 = object5;
                object11[1] = object11[1] + 1.2 * dArray[1];
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        if ((object2 = this.getAnimationString())[0] != null) {
            int n = object2[0].length();
            if (n < 12) {
                n = 12;
            }
            object = new double[]{-appearance.x - (double)n * (appearance.x - object8.x), -coloringAttributes.y + 1.2 * dArray[1], appearance.z};
            try {
                serializable = PlotText.render_label(object2[0], (double[])object, (double[])object6, dArray, false);
                graphicsContext3D.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry((VisADGeometryArray)serializable));
                Object object12 = object;
                object12[1] = object12[1] - 1.2 * dArray[1];
                if (object2[1] != null) {
                    serializable = PlotText.render_label(object2[1], (double[])object, (double[])object6, dArray, false);
                    graphicsContext3D.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry((VisADGeometryArray)serializable));
                    Object object13 = object;
                    object13[1] = object13[1] - 1.2 * dArray[1];
                }
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        if (this.scale_switch.getWhichChild() == 1) {
            cloneable = ((Component)((Object)visADCanvasJ3D)).getSize();
            int n = ((Dimension)cloneable).width;
            int n2 = ((Dimension)cloneable).height;
            double d = 3.0 * (double)n / 256.0;
            double d2 = Math.abs(d * appearance.x - (d - 1.0) * coloringAttributes.x);
            double d3 = Math.abs(d * appearance.y - (d - 1.0) * coloringAttributes.y);
            double d4 = -d2;
            double d5 = -d3;
            TransformGroup transformGroup = this.getTrans();
            Transform3D transform3D2 = new Transform3D();
            transformGroup.getTransform(transform3D2);
            transform3D2.invert();
            Point3d point3d = new Point3d(d2, d3, 0.0);
            Point3d point3d2 = new Point3d(d4, d5, 0.0);
            transform3D2.transform(point3d);
            transform3D2.transform(point3d2);
            double d6 = point3d.x;
            double d7 = point3d.y;
            double d8 = point3d2.x;
            double d9 = point3d2.y;
            Enumeration enumeration = this.axis_vector.elements();
            while (enumeration.hasMoreElements()) {
                AxisScale axisScale = (AxisScale)enumeration.nextElement();
                try {
                    boolean bl = axisScale.makeScreenBasedScale(d4, d5, d2, d3, d8, d9, d6, d7);
                    if (!bl) continue;
                    int n3 = axisScale.getAxis();
                    int n4 = axisScale.getAxisOrdinal();
                    VisADLineArray visADLineArray = axisScale.getScaleArray();
                    VisADTriangleArray visADTriangleArray = axisScale.getLabelArray();
                    float[] fArray = axisScale.getColor().getColorComponents(null);
                    Appearance appearance2 = new Appearance();
                    ColoringAttributes coloringAttributes2 = new ColoringAttributes();
                    coloringAttributes2.setColor(new Color3f(fArray));
                    appearance2.setColoringAttributes(coloringAttributes2);
                    graphicsContext3D.setAppearance(appearance2);
                    graphicsContext3D.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(visADLineArray));
                    graphicsContext3D.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(visADTriangleArray));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public DataRenderer findDirect(VisADRay visADRay, int n) {
        DirectManipulationRendererJ3D directManipulationRendererJ3D = null;
        float f = Float.MAX_VALUE;
        Enumeration enumeration = ((Vector)this.directs.clone()).elements();
        while (enumeration.hasMoreElements()) {
            DirectManipulationRendererJ3D directManipulationRendererJ3D2 = (DirectManipulationRendererJ3D)enumeration.nextElement();
            if (!directManipulationRendererJ3D2.getEnabled()) continue;
            directManipulationRendererJ3D2.setLastMouseModifiers(n);
            float f2 = directManipulationRendererJ3D2.checkClose(visADRay.position, visADRay.vector);
            if (!(f2 < f)) continue;
            f = f2;
            directManipulationRendererJ3D = directManipulationRendererJ3D2;
        }
        if (f < this.getPickThreshhold()) {
            return directManipulationRendererJ3D;
        }
        return null;
    }

    public boolean anyDirects() {
        return !this.directs.isEmpty();
    }

    public void setScaleOn(boolean bl) {
        if (bl) {
            this.scale_switch.setWhichChild(1);
        } else {
            this.scale_switch.setWhichChild(0);
        }
    }

    public void setScale(AxisScale axisScale) throws VisADException {
        if (axisScale.getScreenBased() && this.getMode2D()) {
            if (!this.axis_vector.contains(axisScale)) {
                this.axis_vector.addElement(axisScale);
                this.clearScale(axisScale);
            }
        } else {
            this.setScale(axisScale.getAxis(), axisScale.getAxisOrdinal(), axisScale.getScaleArray(), axisScale.getLabelArray(), axisScale.getColor().getColorComponents(null));
        }
    }

    public void setScale(int n, int n2, VisADLineArray visADLineArray, float[] fArray) throws VisADException {
        this.setScale(n, n2, visADLineArray, null, fArray);
    }

    public void setScale(int n, int n2, VisADLineArray visADLineArray, VisADTriangleArray visADTriangleArray, float[] fArray) throws VisADException {
        BranchGroup branchGroup;
        BranchGroup branchGroup2;
        DisplayImplJ3D displayImplJ3D = (DisplayImplJ3D)this.getDisplay();
        GeometryArray geometryArray = displayImplJ3D.makeGeometry(visADLineArray);
        GraphicsModeControl graphicsModeControl = displayImplJ3D.getGraphicsModeControl();
        ColoringAttributes coloringAttributes = new ColoringAttributes();
        coloringAttributes.setColor(fArray[0], fArray[1], fArray[2]);
        Appearance appearance = ShadowTypeJ3D.makeAppearance(graphicsModeControl, null, coloringAttributes, geometryArray, false);
        Shape3D shape3D = new Shape3D((Geometry)geometryArray, appearance);
        BranchGroup branchGroup3 = new BranchGroup();
        branchGroup3.setCapability(17);
        branchGroup3.setCapability(12);
        branchGroup3.addChild((Node)shape3D);
        if (visADTriangleArray != null) {
            GeometryArray geometryArray2 = displayImplJ3D.makeGeometry(visADTriangleArray);
            branchGroup2 = ShadowTypeJ3D.makeAppearance(graphicsModeControl, null, null, geometryArray2, true);
            Shape3D shape3D2 = new Shape3D((Geometry)geometryArray2, (Appearance)branchGroup2);
            branchGroup3.addChild((Node)shape3D2);
            if (visADTriangleArray instanceof VisADTriangleArray) {
                GeometryArray geometryArray3 = displayImplJ3D.makeGeometry(visADTriangleArray);
                Appearance appearance2 = ShadowTypeJ3D.makeAppearance(graphicsModeControl, null, null, geometryArray3, true);
                PolygonAttributes polygonAttributes = appearance2.getPolygonAttributes();
                polygonAttributes.setPolygonMode(1);
                branchGroup = new Shape3D((Geometry)geometryArray3, appearance2);
                branchGroup3.addChild((Node)branchGroup);
            }
        }
        int n3 = this.getMode2D() ? 2 : 3;
        branchGroup2 = this.scale_on;
        synchronized (branchGroup2) {
            int n4 = this.scale_on.numChildren();
            int n5 = n3 * n2 + n;
            if (n5 >= n4) {
                int n6 = n4;
                while (n6 <= n5) {
                    branchGroup = new BranchGroup();
                    branchGroup.setCapability(17);
                    branchGroup.setCapability(12);
                    this.scale_on.addChild((Node)branchGroup);
                    ++n6;
                }
            }
            this.scale_on.setChild((Node)branchGroup3, n5);
        }
    }

    public void clearScales() {
        if (this.scale_on != null) {
            BranchGroup branchGroup = this.scale_on;
            synchronized (branchGroup) {
                int n = this.scale_on.numChildren();
                int n2 = n - 1;
                while (n2 >= 0) {
                    this.scale_on.removeChild(n2);
                    --n2;
                }
            }
        }
        this.axis_vector.removeAllElements();
    }

    public void clearScale(AxisScale axisScale) {
        int n = axisScale.getAxis();
        int n2 = axisScale.getAxisOrdinal();
        int n3 = this.getMode2D() ? 2 : 3;
        BranchGroup branchGroup = this.scale_on;
        synchronized (branchGroup) {
            int n4 = this.scale_on.numChildren();
            int n5 = n3 * n2 + n;
            if (n5 >= n4) {
                int n6 = n4;
                while (n6 <= n5) {
                    BranchGroup branchGroup2 = new BranchGroup();
                    branchGroup2.setCapability(17);
                    branchGroup2.setCapability(12);
                    this.scale_on.addChild((Node)branchGroup2);
                    ++n6;
                }
            }
            BranchGroup branchGroup3 = new BranchGroup();
            branchGroup3.setCapability(17);
            branchGroup3.setCapability(12);
            this.scale_on.setChild((Node)branchGroup3, n5);
        }
    }

    public void setTransform3D(Transform3D transform3D) {
        if (this.trans == null) {
            this.trans = new TransformGroup();
            this.trans.setCapability(17);
            this.trans.setCapability(18);
            this.trans.setCapability(12);
            this.trans.setCapability(13);
            this.trans.setCapability(14);
        }
        if (transform3D != null) {
            this.trans.setTransform(transform3D);
        }
    }

    public Control makeControl(ScalarMap scalarMap) {
        DisplayRealType displayRealType = scalarMap.getDisplayScalar();
        DisplayImplJ3D displayImplJ3D = (DisplayImplJ3D)this.getDisplay();
        if (displayRealType == null) {
            return null;
        }
        if (displayRealType.equals(Display.XAxis) || displayRealType.equals(Display.YAxis) || displayRealType.equals(Display.ZAxis) || displayRealType.equals(Display.Latitude) || displayRealType.equals(Display.Longitude) || displayRealType.equals(Display.Radius)) {
            return (ProjectionControlJ3D)displayImplJ3D.getProjectionControl();
        }
        if (displayRealType.equals(Display.RGB) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY)) {
            return new ColorControl(displayImplJ3D);
        }
        if (displayRealType.equals(Display.RGBA)) {
            return new ColorAlphaControl(displayImplJ3D);
        }
        if (displayRealType.equals(Display.Animation)) {
            Control control = displayImplJ3D.getControl(class$Lvisad$java3d$AnimationControlJ3D != null ? class$Lvisad$java3d$AnimationControlJ3D : (class$Lvisad$java3d$AnimationControlJ3D = DisplayRendererJ3D.class$("visad.java3d.AnimationControlJ3D")));
            if (control != null) {
                return control;
            }
            return new AnimationControlJ3D(displayImplJ3D, (RealType)scalarMap.getScalar());
        }
        if (displayRealType.equals(Display.SelectValue)) {
            return new ValueControlJ3D(displayImplJ3D);
        }
        if (displayRealType.equals(Display.SelectRange)) {
            return new RangeControl(displayImplJ3D);
        }
        if (displayRealType.equals(Display.IsoContour)) {
            return new ContourControl(displayImplJ3D);
        }
        if (displayRealType.equals(Display.Flow1X) || displayRealType.equals(Display.Flow1Y) || displayRealType.equals(Display.Flow1Z) || displayRealType.equals(Display.Flow1Elevation) || displayRealType.equals(Display.Flow1Azimuth) || displayRealType.equals(Display.Flow1Radial)) {
            Control control = displayImplJ3D.getControl(class$Lvisad$Flow1Control != null ? class$Lvisad$Flow1Control : (class$Lvisad$Flow1Control = DisplayRendererJ3D.class$("visad.Flow1Control")));
            if (control != null) {
                return control;
            }
            return new Flow1Control(displayImplJ3D);
        }
        if (displayRealType.equals(Display.Flow2X) || displayRealType.equals(Display.Flow2Y) || displayRealType.equals(Display.Flow2Z) || displayRealType.equals(Display.Flow2Elevation) || displayRealType.equals(Display.Flow2Azimuth) || displayRealType.equals(Display.Flow2Radial)) {
            Control control = displayImplJ3D.getControl(class$Lvisad$Flow2Control != null ? class$Lvisad$Flow2Control : (class$Lvisad$Flow2Control = DisplayRendererJ3D.class$("visad.Flow2Control")));
            if (control != null) {
                return control;
            }
            return new Flow2Control(displayImplJ3D);
        }
        if (displayRealType.equals(Display.Shape)) {
            return new ShapeControl(displayImplJ3D);
        }
        if (displayRealType.equals(Display.Text)) {
            return new TextControl(displayImplJ3D);
        }
        return null;
    }

    public DataRenderer makeDefaultRenderer() {
        return new DefaultRendererJ3D();
    }

    public boolean legalDataRenderer(DataRenderer dataRenderer) {
        return dataRenderer instanceof RendererJ3D;
    }

    public void rendererDeleted(DataRenderer dataRenderer) {
        this.clearScene(dataRenderer);
    }

    public void addKeyboardBehavior(KeyboardBehaviorJ3D keyboardBehaviorJ3D) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)keyboardBehaviorJ3D);
        this.trans.addChild((Node)branchGroup);
    }

    public void setWaitFlag(boolean bl) {
        boolean bl2 = this.getWaitFlag();
        super.setWaitFlag(bl);
        if (bl != bl2) {
            ProjectionControl projectionControl = this.getDisplay().getProjectionControl();
            try {
                if (projectionControl != null) {
                    projectionControl.setMatrix(projectionControl.getMatrix());
                }
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

