/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import com.sun.j3d.utils.applet.MainFrame;
import java.applet.Applet;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.PointArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Screen3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleStripArray;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.ProjectionControl;
import visad.RemoteDisplay;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;
import visad.VisADQuadArray;
import visad.VisADTriangleArray;
import visad.VisADTriangleStripArray;
import visad.java3d.DefaultDisplayRendererJ3D;
import visad.java3d.DisplayAppletJ3D;
import visad.java3d.DisplayPanelJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.GraphicsModeControlJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.TransformOnlyDisplayRendererJ3D;
import visad.java3d.UniverseBuilderJ3D;
import visad.java3d.VisADCanvasJ3D;

public class DisplayImplJ3D
extends DisplayImpl {
    public static final float BACK2D = -2.0f;
    public static final int PARALLEL_PROJECTION = 0;
    public static final int PERSPECTIVE_PROJECTION = 1;
    public static final int POLYGON_FILL = 2;
    public static final int POLYGON_LINE = 1;
    public static final int POLYGON_POINT = 0;
    public static final int NICEST = 1;
    public static final int FASTEST = 0;
    public static final int UNKNOWN = 0;
    public static final int JPANEL = 1;
    public static final int OFFSCREEN = 2;
    public static final int APPLETFRAME = 3;
    public static final int TRANSFORM_ONLY = 4;
    private DisplayAppletJ3D applet = null;
    private ProjectionControlJ3D projection = null;
    private GraphicsModeControlJ3D mode = null;
    private int apiValue = 0;

    private void initialize(int n, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        this.initialize(n, graphicsConfiguration, -1, -1);
    }

    private void initialize(int n, GraphicsConfiguration graphicsConfiguration, int n2, int n3) throws VisADException, RemoteException {
        this.projection = new ProjectionControlJ3D(this);
        this.addControl(this.projection);
        if (n == 3) {
            this.applet = new DisplayAppletJ3D(this, graphicsConfiguration);
            MainFrame mainFrame = new MainFrame((Applet)this.applet, 256, 256);
            this.setComponent((Component)mainFrame);
            this.apiValue = n;
        } else if (n == 1) {
            DisplayPanelJ3D displayPanelJ3D = new DisplayPanelJ3D(this, graphicsConfiguration);
            this.setComponent(displayPanelJ3D);
            this.apiValue = n;
        } else if (n == 4) {
            if (!(this.getDisplayRenderer() instanceof TransformOnlyDisplayRendererJ3D)) {
                throw new DisplayException("must be TransformOnlyDisplayRendererJ3D for api = TRANSFORM_ONLY");
            }
            this.setComponent(null);
            this.apiValue = n;
        } else if (n == 2) {
            DisplayRendererJ3D displayRendererJ3D = (DisplayRendererJ3D)this.getDisplayRenderer();
            VisADCanvasJ3D visADCanvasJ3D = new VisADCanvasJ3D(displayRendererJ3D, n2, n3);
            UniverseBuilderJ3D universeBuilderJ3D = new UniverseBuilderJ3D(visADCanvasJ3D);
            BranchGroup branchGroup = displayRendererJ3D.createSceneGraph(universeBuilderJ3D.view, universeBuilderJ3D.vpTrans, visADCanvasJ3D);
            universeBuilderJ3D.addBranchGraph(branchGroup);
            this.setComponent(null);
            this.apiValue = n;
        } else {
            throw new DisplayException("DisplayImplJ3D: bad graphics API " + n);
        }
        if (n != 4) {
            this.projection.setAspect(new double[]{1.0, 1.0, 1.0});
        }
        this.mode = new GraphicsModeControlJ3D(this);
        this.addControl(this.mode);
    }

    protected DisplayRenderer getDefaultDisplayRenderer() {
        return new DefaultDisplayRendererJ3D();
    }

    public void setScreenAspect(double d, double d2) {
        DisplayRendererJ3D displayRendererJ3D = (DisplayRendererJ3D)this.getDisplayRenderer();
        Screen3D screen3D = displayRendererJ3D.getCanvas().getScreen3D();
        screen3D.setPhysicalScreenHeight(d);
        screen3D.setPhysicalScreenWidth(d2);
    }

    public ProjectionControl getProjectionControl() {
        return this.projection;
    }

    public GraphicsModeControl getGraphicsModeControl() {
        return this.mode;
    }

    public DisplayAppletJ3D getApplet() {
        return this.applet;
    }

    public int getAPI() throws VisADException {
        return this.apiValue;
    }

    public GeometryArray makeGeometry(VisADGeometryArray visADGeometryArray) throws VisADException {
        if (visADGeometryArray == null) {
            return null;
        }
        boolean bl = this.getDisplayRenderer().getMode2D();
        if (visADGeometryArray instanceof VisADIndexedTriangleStripArray) {
            VisADIndexedTriangleStripArray visADIndexedTriangleStripArray = (VisADIndexedTriangleStripArray)visADGeometryArray;
            if (visADGeometryArray.vertexCount == 0) {
                return null;
            }
            IndexedTriangleStripArray indexedTriangleStripArray = new IndexedTriangleStripArray(visADGeometryArray.vertexCount, DisplayImplJ3D.makeFormat(visADGeometryArray), visADIndexedTriangleStripArray.indexCount, visADIndexedTriangleStripArray.stripVertexCounts);
            this.basicGeometry(visADGeometryArray, (GeometryArray)indexedTriangleStripArray, bl);
            if (visADGeometryArray.coordinates != null) {
                indexedTriangleStripArray.setCoordinateIndices(0, visADIndexedTriangleStripArray.indices);
            }
            if (visADGeometryArray.colors != null) {
                indexedTriangleStripArray.setColorIndices(0, visADIndexedTriangleStripArray.indices);
            }
            if (visADGeometryArray.normals != null) {
                indexedTriangleStripArray.setNormalIndices(0, visADIndexedTriangleStripArray.indices);
            }
            if (visADGeometryArray.texCoords != null) {
                indexedTriangleStripArray.setTextureCoordinateIndices(0, visADIndexedTriangleStripArray.indices);
            }
            return indexedTriangleStripArray;
        }
        if (visADGeometryArray instanceof VisADTriangleStripArray) {
            VisADTriangleStripArray visADTriangleStripArray = (VisADTriangleStripArray)visADGeometryArray;
            if (visADGeometryArray.vertexCount == 0) {
                return null;
            }
            TriangleStripArray triangleStripArray = new TriangleStripArray(visADGeometryArray.vertexCount, DisplayImplJ3D.makeFormat(visADGeometryArray), visADTriangleStripArray.stripVertexCounts);
            this.basicGeometry(visADGeometryArray, (GeometryArray)triangleStripArray, bl);
            return triangleStripArray;
        }
        if (visADGeometryArray instanceof VisADLineArray) {
            if (visADGeometryArray.vertexCount == 0) {
                return null;
            }
            LineArray lineArray = new LineArray(visADGeometryArray.vertexCount, DisplayImplJ3D.makeFormat(visADGeometryArray));
            this.basicGeometry(visADGeometryArray, (GeometryArray)lineArray, false);
            return lineArray;
        }
        if (visADGeometryArray instanceof VisADLineStripArray) {
            if (visADGeometryArray.vertexCount == 0) {
                return null;
            }
            VisADLineStripArray visADLineStripArray = (VisADLineStripArray)visADGeometryArray;
            LineStripArray lineStripArray = new LineStripArray(visADGeometryArray.vertexCount, DisplayImplJ3D.makeFormat(visADGeometryArray), visADLineStripArray.stripVertexCounts);
            this.basicGeometry(visADGeometryArray, (GeometryArray)lineStripArray, false);
            return lineStripArray;
        }
        if (visADGeometryArray instanceof VisADPointArray) {
            if (visADGeometryArray.vertexCount == 0) {
                return null;
            }
            PointArray pointArray = new PointArray(visADGeometryArray.vertexCount, DisplayImplJ3D.makeFormat(visADGeometryArray));
            this.basicGeometry(visADGeometryArray, (GeometryArray)pointArray, false);
            return pointArray;
        }
        if (visADGeometryArray instanceof VisADTriangleArray) {
            if (visADGeometryArray.vertexCount == 0) {
                return null;
            }
            TriangleArray triangleArray = new TriangleArray(visADGeometryArray.vertexCount, DisplayImplJ3D.makeFormat(visADGeometryArray));
            this.basicGeometry(visADGeometryArray, (GeometryArray)triangleArray, bl);
            return triangleArray;
        }
        if (visADGeometryArray instanceof VisADQuadArray) {
            if (visADGeometryArray.vertexCount == 0) {
                return null;
            }
            QuadArray quadArray = new QuadArray(visADGeometryArray.vertexCount, DisplayImplJ3D.makeFormat(visADGeometryArray));
            this.basicGeometry(visADGeometryArray, (GeometryArray)quadArray, bl);
            return quadArray;
        }
        throw new DisplayException("DisplayImplJ3D.makeGeometry");
    }

    private void basicGeometry(VisADGeometryArray visADGeometryArray, GeometryArray geometryArray, boolean bl) {
        if (bl) {
            if (visADGeometryArray.coordinates != null) {
                int n = visADGeometryArray.coordinates.length;
                float[] fArray = new float[n];
                System.arraycopy(visADGeometryArray.coordinates, 0, fArray, 0, n);
                int n2 = 2;
                while (n2 < n) {
                    fArray[n2] = -2.0f;
                    n2 += 3;
                }
                geometryArray.setCoordinates(0, fArray);
            }
        } else if (visADGeometryArray.coordinates != null) {
            geometryArray.setCoordinates(0, visADGeometryArray.coordinates);
        }
        if (visADGeometryArray.colors != null) {
            geometryArray.setColors(0, visADGeometryArray.colors);
        }
        if (visADGeometryArray.normals != null) {
            geometryArray.setNormals(0, visADGeometryArray.normals);
        }
        if (visADGeometryArray.texCoords != null) {
            geometryArray.setTextureCoordinates(0, visADGeometryArray.texCoords);
        }
    }

    private static int makeFormat(VisADGeometryArray visADGeometryArray) {
        int n = 0;
        if (visADGeometryArray.coordinates != null) {
            n |= 1;
        }
        if (visADGeometryArray.colors != null) {
            n = visADGeometryArray.colors.length == 3 * visADGeometryArray.vertexCount ? (n |= 4) : (n |= 0xC);
        }
        if (visADGeometryArray.normals != null) {
            n |= 2;
        }
        if (visADGeometryArray.texCoords != null) {
            n = visADGeometryArray.texCoords.length == 2 * visADGeometryArray.vertexCount ? (n |= 0x20) : (n |= 0x40);
        }
        return n;
    }

    public void destroy() throws VisADException, RemoteException {
        ((DisplayRendererJ3D)this.getDisplayRenderer()).destroy();
        super.destroy();
    }

    public DisplayImplJ3D(String string) throws VisADException, RemoteException {
        this(string, null, 1, null);
    }

    public DisplayImplJ3D(String string, DisplayRendererJ3D displayRendererJ3D) throws VisADException, RemoteException {
        this(string, displayRendererJ3D, 1, null);
    }

    public DisplayImplJ3D(String string, int n) throws VisADException, RemoteException {
        this(string, null, n, null);
    }

    public DisplayImplJ3D(String string, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        this(string, null, 1, graphicsConfiguration);
    }

    public DisplayImplJ3D(String string, DisplayRendererJ3D displayRendererJ3D, int n) throws VisADException, RemoteException {
        this(string, displayRendererJ3D, n, null);
    }

    public DisplayImplJ3D(String string, DisplayRendererJ3D displayRendererJ3D, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        this(string, displayRendererJ3D, 1, graphicsConfiguration);
    }

    public DisplayImplJ3D(String string, int n, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        this(string, null, n, graphicsConfiguration);
    }

    public DisplayImplJ3D(String string, DisplayRendererJ3D displayRendererJ3D, int n, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        super(string, (DisplayRenderer)displayRendererJ3D);
        this.initialize(n, graphicsConfiguration);
    }

    public DisplayImplJ3D(String string, int n, int n2) throws VisADException, RemoteException {
        this(string, null, n, n2);
    }

    public DisplayImplJ3D(String string, DisplayRendererJ3D displayRendererJ3D, int n, int n2) throws VisADException, RemoteException {
        super(string, (DisplayRenderer)displayRendererJ3D);
        this.initialize(2, null, n, n2);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay) throws VisADException, RemoteException {
        this(remoteDisplay, null, remoteDisplay.getDisplayAPI(), null);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay, DisplayRendererJ3D displayRendererJ3D) throws VisADException, RemoteException {
        this(remoteDisplay, displayRendererJ3D, remoteDisplay.getDisplayAPI(), null);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay, int n) throws VisADException, RemoteException {
        this(remoteDisplay, null, n, null);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        this(remoteDisplay, null, remoteDisplay.getDisplayAPI(), graphicsConfiguration);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay, DisplayRendererJ3D displayRendererJ3D, int n) throws VisADException, RemoteException {
        this(remoteDisplay, displayRendererJ3D, n, null);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay, DisplayRendererJ3D displayRendererJ3D, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        this(remoteDisplay, displayRendererJ3D, remoteDisplay.getDisplayAPI(), graphicsConfiguration);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay, int n, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        this(remoteDisplay, null, n, graphicsConfiguration);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay, DisplayRendererJ3D displayRendererJ3D, int n, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        super(remoteDisplay, (DisplayRenderer)(displayRendererJ3D == null && n == 4 ? new TransformOnlyDisplayRendererJ3D() : displayRendererJ3D));
        this.initialize(n, graphicsConfiguration);
        this.syncRemoteData(remoteDisplay);
    }

    public DisplayImplJ3D(RemoteDisplay remoteDisplay, TransformOnlyDisplayRendererJ3D transformOnlyDisplayRendererJ3D, GraphicsConfiguration graphicsConfiguration) throws VisADException, RemoteException {
        super(remoteDisplay, transformOnlyDisplayRendererJ3D, true);
        this.initialize(4, graphicsConfiguration);
        this.syncRemoteData(remoteDisplay);
    }
}

