/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import visad.BadDirectManipulationException;
import visad.Data;
import visad.DataDisplayLink;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADPointArray;
import visad.collab.CollabUtil;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowTypeJ3D;

public class DirectManipulationRendererJ3D
extends RendererJ3D {
    BranchGroup branch = null;

    public void setLinks(DataDisplayLink[] dataDisplayLinkArray, DisplayImpl displayImpl) throws VisADException {
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length != 1) {
            throw new DisplayException("DirectManipulationRendererJ3D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(dataDisplayLinkArray, displayImpl);
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.realCheckDirect();
    }

    public void addPoint(float[] fArray) throws VisADException {
        int n = fArray.length / 3;
        VisADGeometryArray visADGeometryArray = null;
        if (n == 1) {
            visADGeometryArray = new VisADPointArray();
        } else if (n == 2) {
            visADGeometryArray = new VisADLineArray();
        } else {
            return;
        }
        visADGeometryArray.coordinates = fArray;
        visADGeometryArray.vertexCount = n;
        DisplayImplJ3D displayImplJ3D = (DisplayImplJ3D)this.getDisplay();
        GeometryArray geometryArray = displayImplJ3D.makeGeometry(visADGeometryArray);
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            return;
        }
        DataDisplayLink dataDisplayLink = dataDisplayLinkArray[0];
        float[] fArray2 = dataDisplayLink.getDefaultValues();
        GraphicsModeControl graphicsModeControl = (GraphicsModeControl)displayImplJ3D.getGraphicsModeControl().clone();
        float f = fArray2[displayImplJ3D.getDisplayScalarIndex(Display.PointSize)];
        float f2 = fArray2[displayImplJ3D.getDisplayScalarIndex(Display.LineWidth)];
        graphicsModeControl.setPointSize(f, true);
        graphicsModeControl.setLineWidth(f2, true);
        Appearance appearance = ShadowTypeJ3D.makeAppearance(graphicsModeControl, null, null, geometryArray, false);
        Shape3D shape3D = new Shape3D((Geometry)geometryArray, appearance);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(12);
        branchGroup.addChild((Node)shape3D);
        this.branch.addChild((Node)branchGroup);
    }

    public synchronized BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        this.branch = new BranchGroup();
        this.branch.setCapability(17);
        this.branch.setCapability(12);
        this.branch.setCapability(13);
        this.branch.setCapability(14);
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            return null;
        }
        DataDisplayLink dataDisplayLink = dataDisplayLinkArray[0];
        ShadowTypeJ3D shadowTypeJ3D = (ShadowTypeJ3D)dataDisplayLink.getShadow();
        if (!this.getIsDirectManipulation()) {
            throw new BadDirectManipulationException(this.getWhyNotDirect() + ": DirectManipulationRendererJ3D.doTransform");
        }
        int n = this.getDisplay().getValueArrayLength();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.NaN;
            ++n2;
        }
        try {
            data = dataDisplayLink.getData();
        }
        catch (RemoteException remoteException) {
            if (CollabUtil.isDisconnectException(remoteException)) {
                this.getDisplay().connectionFailed(this, dataDisplayLink);
                this.removeLink(dataDisplayLink);
                return null;
            }
            throw remoteException;
        }
        if (data == null) {
            this.branch = null;
            this.addException(new DisplayException("Data is null: DirectManipulationRendererJ3D.doTransform"));
        } else {
            try {
                shadowTypeJ3D.doTransform(this.branch, data, fArray, dataDisplayLink.getDefaultValues(), this);
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, dataDisplayLink);
                    this.removeLink(dataDisplayLink);
                    return null;
                }
                throw remoteException;
            }
        }
        return this.branch;
    }

    public void setBranch(BranchGroup branchGroup) {
        this.branch = branchGroup;
    }

    void addSwitch(DisplayRendererJ3D displayRendererJ3D, BranchGroup branchGroup) {
        displayRendererJ3D.addDirectManipulationSceneGraphComponent((Group)branchGroup, this);
    }

    public boolean isLegalTextureMap() {
        return false;
    }
}

