/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import visad.Data;
import visad.DataDisplayLink;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADException;
import visad.collab.CollabUtil;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowTypeJ3D;

public class DefaultRendererJ3D
extends RendererJ3D {
    DataDisplayLink link;

    public void setLinks(DataDisplayLink[] dataDisplayLinkArray, DisplayImpl displayImpl) throws VisADException {
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length != 1) {
            throw new DisplayException("DefaultRendererJ3D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(dataDisplayLinkArray, displayImpl);
        this.link = dataDisplayLinkArray[0];
    }

    public BranchGroup doTransform() throws VisADException, RemoteException {
        Data data;
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        ShadowTypeJ3D shadowTypeJ3D = (ShadowTypeJ3D)this.link.getShadow();
        int n = this.getDisplay().getValueArrayLength();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.NaN;
            ++n2;
        }
        try {
            data = this.link.getData();
        }
        catch (RemoteException remoteException) {
            if (CollabUtil.isDisconnectException(remoteException)) {
                this.getDisplay().connectionFailed(this, this.link);
                this.removeLink(this.link);
                return null;
            }
            throw remoteException;
        }
        if (data == null) {
            branchGroup = null;
            this.addException(new DisplayException("Data is null: DefaultRendererJ3D.doTransform"));
        } else {
            boolean bl;
            this.link.start_time = System.currentTimeMillis();
            this.link.time_flag = false;
            shadowTypeJ3D.preProcess();
            try {
                bl = shadowTypeJ3D.doTransform(branchGroup, data, fArray, this.link.getDefaultValues(), this);
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return null;
                }
                throw remoteException;
            }
            if (bl) {
                shadowTypeJ3D.postProcess(branchGroup);
            }
        }
        this.link.clearData();
        return branchGroup;
    }

    void addSwitch(DisplayRendererJ3D displayRendererJ3D, BranchGroup branchGroup) {
        displayRendererJ3D.addSceneGraphComponent((Group)branchGroup);
    }

    public DataDisplayLink getLink() {
        return this.link;
    }
}

