/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.AnimationControl;
import visad.AnimationSetControl;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.RealType;
import visad.Set;
import visad.ToggleControl;
import visad.VisADError;
import visad.VisADException;
import visad.browser.Convert;
import visad.java3d.AVControlJ3D;
import visad.java3d.DisplayImplJ3D;

public class AnimationControlJ3D
extends AVControlJ3D
implements Runnable,
AnimationControl {
    private int current = 0;
    private boolean direction;
    private long step;
    private long[] stepValues = new long[]{500L};
    private transient AnimationSetControl animationSet;
    private ToggleControl animate;
    private RealType real;
    private transient Thread animationThread;

    public void nullControl() {
        this.stop();
        super.nullControl();
    }

    public void stop() {
        this.animationThread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.animationThread == thread) {
            try {
                if (this.animate != null && this.animate.getOn()) {
                    this.takeStep();
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
                throw new VisADError("AnimationControlJ3D.run: " + visADException.toString());
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                throw new VisADError("AnimationControlJ3D.run: " + remoteException.toString());
            }
            try {
                AnimationControlJ3D animationControlJ3D = this;
                synchronized (animationControlJ3D) {
                    if (this.current >= 0 && this.current < this.stepValues.length) {
                        this.wait(this.stepValues[this.current]);
                    } else {
                        this.wait(500L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int n) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(n);
            this.init();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    public void setCurrent(double d) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.getIndex(d);
            this.init();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    public void setDirection(boolean bl) throws VisADException, RemoteException {
        this.direction = bl;
        this.changeControl(false);
    }

    public boolean getDirection() {
        return this.direction;
    }

    public long getStep() {
        if (this.stepValues == null || this.current < 0 || this.stepValues.length <= this.current) {
            return 500L;
        }
        return this.stepValues[this.current];
    }

    public long[] getSteps() {
        return this.stepValues;
    }

    public void setStep(int n) throws VisADException, RemoteException {
        if (n <= 0) {
            throw new DisplayException("AnimationControlJ3D.setStep: step must be > 0");
        }
        this.step = n;
        int n2 = 0;
        while (n2 < this.stepValues.length) {
            this.stepValues[n2] = n;
            ++n2;
        }
        this.changeControl(false);
    }

    public void setSteps(int[] nArray) throws VisADException, RemoteException {
        int n = 0;
        while (n < this.stepValues.length) {
            this.stepValues[n] = n < nArray.length ? nArray[n] : nArray[nArray.length - 1];
            if (this.stepValues[n] <= 0L) {
                throw new DisplayException("AnimationControlJ3D.setSteps: step " + n + " must be > 0");
            }
            ++n;
        }
        this.changeControl(true);
    }

    public void takeStep() throws VisADException, RemoteException {
        this.current = this.direction ? ++this.current : --this.current;
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(this.current);
            this.init();
        }
        this.changeControl(false);
    }

    public void init() throws VisADException {
        if (this.animationSet != null && this.animationSet.getSet() != null) {
            double d = this.animationSet.getValue(this.current);
            Set set = this.animationSet.getSet();
            this.animation_string(this.real, set, d, this.current);
            this.selectSwitches(d, set);
        }
    }

    public Set getSet() {
        if (this.animationSet != null) {
            return this.animationSet.getSet();
        }
        return null;
    }

    public void setSet(Set set) throws VisADException, RemoteException {
        this.setSet(set, false);
        if (set.getLength() != this.stepValues.length) {
            this.stepValues = new long[set.getLength()];
            int n = 0;
            while (n < this.stepValues.length) {
                this.stepValues[n] = this.step;
                ++n;
            }
        }
    }

    public void setSet(Set set, boolean bl) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            if (set.getLength() != this.stepValues.length) {
                this.stepValues = new long[set.getLength()];
                int n = 0;
                while (n < this.stepValues.length) {
                    this.stepValues[n] = this.step;
                    ++n;
                }
            }
            this.animationSet.setSet(set, bl);
        }
    }

    public boolean getOn() {
        if (this.animate != null) {
            return this.animate.getOn();
        }
        return false;
    }

    public void setOn(boolean bl) throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(bl);
        }
    }

    public void toggle() throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(!this.animate.getOn());
        }
    }

    public void subSetTicks() {
        if (this.animationSet != null) {
            this.animationSet.setTicks();
        }
        if (this.animate != null) {
            this.animate.setTicks();
        }
    }

    public boolean subCheckTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        boolean bl = false;
        if (this.animationSet != null) {
            bl |= this.animationSet.checkTicks(dataRenderer, dataDisplayLink);
        }
        if (this.animate != null) {
            bl |= this.animate.checkTicks(dataRenderer, dataDisplayLink);
        }
        return bl;
    }

    public boolean subPeekTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        boolean bl = false;
        if (this.animationSet != null) {
            bl |= this.animationSet.peekTicks(dataRenderer, dataDisplayLink);
        }
        if (this.animate != null) {
            bl |= this.animate.peekTicks(dataRenderer, dataDisplayLink);
        }
        return bl;
    }

    public void subResetTicks() {
        if (this.animationSet != null) {
            this.animationSet.resetTicks();
        }
        if (this.animate != null) {
            this.animate.resetTicks();
        }
    }

    public String getSaveString() {
        long[] lArray;
        int n;
        if (this.stepValues == null) {
            n = 1;
            lArray = new long[]{500L};
        } else {
            n = this.stepValues.length;
            lArray = this.stepValues;
        }
        StringBuffer stringBuffer = new StringBuffer(35 + 12 * n);
        stringBuffer.append(this.animate != null && this.animate.getOn());
        stringBuffer.append(' ');
        stringBuffer.append(this.direction);
        stringBuffer.append(' ');
        stringBuffer.append(this.current);
        stringBuffer.append(' ');
        stringBuffer.append(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            stringBuffer.append((int)lArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 4) {
            throw new VisADException("Invalid save string");
        }
        boolean bl = Convert.getBoolean(stringTokenizer.nextToken());
        boolean bl2 = Convert.getBoolean(stringTokenizer.nextToken());
        int n2 = Convert.getInt(stringTokenizer.nextToken());
        int n3 = Convert.getInt(stringTokenizer.nextToken());
        if (n3 <= 0) {
            throw new VisADException("Number of steps is not positive");
        }
        if (n < 4 + n3) {
            throw new VisADException("Not enough step entries");
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = Convert.getInt(stringTokenizer.nextToken());
            if (nArray[n4] <= 0) {
                throw new VisADException("Step #" + (n4 + 1) + "is not positive");
            }
            ++n4;
        }
        this.setOn(bl);
        this.setDirection(bl2);
        this.setSteps(nArray);
        this.setCurrent(n2);
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof AnimationControlJ3D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        AnimationControlJ3D animationControlJ3D = (AnimationControlJ3D)control;
        boolean bl = false;
        if (this.direction != animationControlJ3D.direction) {
            bl = true;
            this.direction = animationControlJ3D.direction;
        }
        if (this.step != animationControlJ3D.step) {
            bl = true;
            this.step = animationControlJ3D.step;
        }
        if (this.animate != animationControlJ3D.animate) {
            bl = true;
            this.animate = animationControlJ3D.animate;
        }
        if (this.real != animationControlJ3D.real) {
            bl = true;
            this.real = animationControlJ3D.real;
        }
        if (bl) {
            try {
                this.changeControl(false);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AnimationControlJ3D animationControlJ3D = (AnimationControlJ3D)object;
        if (this.direction != animationControlJ3D.direction) {
            return false;
        }
        if (this.step != animationControlJ3D.step) {
            return false;
        }
        if (this.animate != animationControlJ3D.animate) {
            return false;
        }
        return this.real == animationControlJ3D.real;
    }

    public AnimationControlJ3D(DisplayImplJ3D displayImplJ3D, RealType realType) {
        super(displayImplJ3D);
        this.real = realType;
        this.current = 0;
        this.direction = true;
        this.step = 500L;
        this.stepValues = new long[]{this.step};
        this.animationSet = new AnimationSetControl(displayImplJ3D, this);
        try {
            Set set = this.animationSet.getSet();
            if (set != null) {
                this.stepValues = new long[set.getLength()];
            }
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        int n = 0;
        while (n < this.stepValues.length) {
            this.stepValues[n] = this.step;
            ++n;
        }
        displayImplJ3D.addControl(this.animationSet);
        this.animate = new ToggleControl(displayImplJ3D, this);
        displayImplJ3D.addControl(this.animate);
        try {
            this.animate.setOn(false);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (displayImplJ3D != null) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }

    AnimationControlJ3D() {
        this(null, null);
    }
}

