/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Switch;
import visad.AVControl;
import visad.Control;
import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.RealTupleType;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public abstract class AVControlJ3D
extends Control
implements AVControl {
    transient Vector switches = new Vector();

    public AVControlJ3D(DisplayImplJ3D displayImplJ3D) {
        super(displayImplJ3D);
    }

    public void addPair(Switch switch_, Set set, DataRenderer dataRenderer) {
        this.switches.addElement(new SwitchSet(switch_, set, dataRenderer));
    }

    public void clearSwitches(DataRenderer dataRenderer) {
        Enumeration enumeration = ((Vector)this.switches.clone()).elements();
        while (enumeration.hasMoreElements()) {
            SwitchSet switchSet = (SwitchSet)enumeration.nextElement();
            if (!switchSet.renderer.equals(dataRenderer)) continue;
            this.switches.removeElement(switchSet);
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AVControlJ3D aVControlJ3D = (AVControlJ3D)object;
        if (this.switches == null) {
            return aVControlJ3D.switches == null;
        }
        if (aVControlJ3D.switches != null) {
            if (this.switches.size() != aVControlJ3D.switches.size()) {
                return false;
            }
            int n = this.switches.size() - 1;
            while (n > 0) {
                if (!this.switches.elementAt(n).equals(aVControlJ3D.switches.elementAt(n))) {
                    return false;
                }
                --n;
            }
        }
        return true;
    }

    public abstract void init() throws VisADException;

    public void selectSwitches(double d, Set set) throws VisADException {
        if (d != d) {
            return;
        }
        double[][] dArray = new double[1][1];
        dArray[0][0] = d;
        Enumeration enumeration = ((Vector)this.switches.clone()).elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            SwitchSet switchSet = (SwitchSet)enumeration.nextElement();
            Set set2 = switchSet.set;
            double[][] dArray2 = null;
            RealTupleType realTupleType = ((SetType)set2.getType()).getDomain();
            if (set != null) {
                object = ((SetType)set.getType()).getDomain();
                dArray2 = CoordinateSystem.transformCoordinates(realTupleType, set2.getCoordinateSystem(), set2.getSetUnits(), null, (RealTupleType)object, set.getCoordinateSystem(), set.getSetUnits(), null, dArray);
            } else {
                dArray2 = CoordinateSystem.transformCoordinates(realTupleType, set2.getCoordinateSystem(), set2.getSetUnits(), null, realTupleType, realTupleType.getCoordinateSystem(), realTupleType.getDefaultUnits(), null, dArray);
            }
            object = set2.getLength() == 1 ? (Object)new int[1] : (Object)set2.doubleToIndex(dArray2);
            if (object[0] >= 0 && object[0] < switchSet.swit.numChildren()) {
                switchSet.swit.setWhichChild((int)object[0]);
                continue;
            }
            switchSet.swit.setWhichChild(-1);
        }
    }

    private class SwitchSet {
        Switch swit;
        Set set;
        DataRenderer renderer;

        SwitchSet(Switch switch_, Set set, DataRenderer dataRenderer) {
            this.swit = switch_;
            this.set = set;
            this.renderer = dataRenderer;
        }
    }
}

