/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JPanel;
import visad.MouseHelper;
import visad.ProjectionControl;
import visad.VisADAppearance;
import visad.VisADError;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADLineStripArray;
import visad.VisADPointArray;
import visad.VisADQuadArray;
import visad.VisADSceneGraphObject;
import visad.VisADSwitch;
import visad.VisADTriangleArray;
import visad.VisADTriangleStripArray;
import visad.java2d.AnimationControlJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.KeyboardBehaviorJ2D;
import visad.java2d.MouseBehaviorJ2D;
import visad.util.Delay;

public class VisADCanvasJ2D
extends JPanel
implements Runnable {
    private DisplayRendererJ2D displayRenderer;
    private DisplayImplJ2D display;
    private Component component;
    Dimension prefSize = new Dimension(0, 0);
    private VisADGroup direct = null;
    private VisADGroup non_direct = null;
    private Rectangle2D.Float clip_rectangle = null;
    private transient Thread renderThread;
    private BufferedImage[] images;
    private boolean[] valid_images;
    private int width;
    private int height;
    private int length;
    private AffineTransform tgeometry;
    private Image aux_image;
    boolean captureFlag = false;
    BufferedImage captureImage = null;
    MouseHelper helper;
    boolean wakeup = false;
    private boolean autoAspect = false;
    private static /* synthetic */ Class class$Lvisad$java2d$AnimationControlJ2D;

    public float[] getBackgroundColor() {
        Color color = this.getBackground();
        float[] fArray = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        return fArray;
    }

    public void setBackgroundColor(float f, float f2, float f3) {
        this.setBackground(new Color(f, f2, f3));
    }

    void setDirect(VisADGroup visADGroup, VisADGroup visADGroup2) {
        this.direct = visADGroup;
        this.non_direct = visADGroup2;
    }

    void setClip(float f, float f2, float f3, float f4) {
        if (f2 > f && f4 > f3) {
            this.clip_rectangle = new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
        }
    }

    void unsetClip() {
        this.clip_rectangle = null;
    }

    public void addMouseBehavior(MouseBehaviorJ2D mouseBehaviorJ2D) {
        this.helper = mouseBehaviorJ2D.getMouseHelper();
        MouseAdapter mouseAdapter = new MouseAdapter(this){
            private final /* synthetic */ VisADCanvasJ2D this$0;

            public void mouseEntered(MouseEvent mouseEvent) {
                this.this$0.helper.processEvent(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.this$0.helper.processEvent(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                this.this$0.helper.processEvent(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.this$0.helper.processEvent(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                this.this$0.requestFocus();
            }
            {
                this.this$0 = visADCanvasJ2D;
                this.constructor$0(visADCanvasJ2D);
            }

            private final void constructor$0(VisADCanvasJ2D visADCanvasJ2D) {
            }
        };
        this.addMouseListener(mouseAdapter);
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(this){
            private final /* synthetic */ VisADCanvasJ2D this$0;

            public void mouseDragged(MouseEvent mouseEvent) {
                this.this$0.helper.processEvent(mouseEvent);
            }
            {
                this.this$0 = visADCanvasJ2D;
                this.constructor$0(visADCanvasJ2D);
            }

            private final void constructor$0(VisADCanvasJ2D visADCanvasJ2D) {
            }
        };
        this.addMouseMotionListener(mouseMotionAdapter);
    }

    public void addKeyboardBehavior(KeyboardBehaviorJ2D keyboardBehaviorJ2D) {
        KeyAdapter keyAdapter = new KeyAdapter(this, keyboardBehaviorJ2D){
            private final /* synthetic */ VisADCanvasJ2D this$0;
            private final /* synthetic */ KeyboardBehaviorJ2D val$behavior;

            public void keyPressed(KeyEvent keyEvent) {
                this.val$behavior.processKeyEvent(keyEvent);
            }
            {
                this.val$behavior = keyboardBehaviorJ2D;
                this.this$0 = visADCanvasJ2D;
                this.constructor$0(visADCanvasJ2D);
            }

            private final void constructor$0(VisADCanvasJ2D visADCanvasJ2D) {
            }
        };
        this.addKeyListener(keyAdapter);
    }

    public void createImages(int n) {
        BufferedImage[] bufferedImageArray = this.images;
        synchronized (bufferedImageArray) {
            int n2 = this.length = n < 0 ? this.images.length : n;
            if (this.component != null) {
                this.width = this.getSize().width;
                this.height = this.getSize().height;
            }
            if (this.width <= 0) {
                this.width = 1;
            }
            if (this.height <= 0) {
                this.height = 1;
            }
            BufferedImage[] bufferedImageArray2 = new BufferedImage[this.length];
            boolean[] blArray = new boolean[this.length];
            int n3 = 0;
            while (n3 < this.length) {
                bufferedImageArray2[n3] = this.component != null ? (BufferedImage)this.createImage(this.width, this.height) : new BufferedImage(this.width, this.height, 2);
                blArray[n3] = false;
                ++n3;
            }
            if (this.aux_image != null) {
                this.aux_image.flush();
            }
            this.aux_image = this.component != null ? this.createImage(this.width, this.height) : new BufferedImage(this.width, this.height, 2);
            this.valid_images = blArray;
            if (this.images != null) {
                n3 = 0;
                while (n3 < this.images.length) {
                    if (this.images[n3] != null) {
                        this.images[n3].flush();
                    }
                    ++n3;
                }
            }
            this.images = bufferedImageArray2;
        }
        this.renderTrigger();
    }

    public void scratchImages() {
        BufferedImage[] bufferedImageArray = this.images;
        synchronized (bufferedImageArray) {
            int n = 0;
            while (n < this.length) {
                this.valid_images[n] = false;
                ++n;
            }
        }
        this.renderTrigger();
    }

    public void renderTrigger() {
        VisADCanvasJ2D visADCanvasJ2D = this;
        synchronized (visADCanvasJ2D) {
            this.wakeup = true;
            this.notify();
        }
    }

    public void stop() {
        this.renderThread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.renderThread == thread) {
            VisADCanvasJ2D visADCanvasJ2D;
            try {
                visADCanvasJ2D = this;
                synchronized (visADCanvasJ2D) {
                    if (!this.wakeup) {
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            visADCanvasJ2D = this;
            synchronized (visADCanvasJ2D) {
                this.wakeup = false;
            }
            if (this.component != null) {
                Graphics graphics = this.getGraphics();
                if (graphics == null) continue;
                this.paintComponent(graphics);
                graphics.dispose();
                continue;
            }
            this.paintComponent(null);
        }
    }

    public void paintComponent(Graphics graphics) {
        AnimationControlJ2D animationControlJ2D;
        int n;
        int n2;
        int n3;
        boolean bl;
        BufferedImage bufferedImage;
        AffineTransform affineTransform;
        block35: {
            affineTransform = null;
            bufferedImage = null;
            bl = false;
            n3 = 0;
            n2 = 0;
            n = 0;
            animationControlJ2D = null;
            try {
                animationControlJ2D = (AnimationControlJ2D)this.display.getControl(class$Lvisad$java2d$AnimationControlJ2D != null ? class$Lvisad$java2d$AnimationControlJ2D : (class$Lvisad$java2d$AnimationControlJ2D = VisADCanvasJ2D.class$("visad.java2d.AnimationControlJ2D")));
                if (animationControlJ2D != null) {
                    animationControlJ2D.setNoTick(true);
                    n = animationControlJ2D.getCurrent();
                }
            }
            catch (Exception exception) {
                if (animationControlJ2D == null) break block35;
                animationControlJ2D.setNoTick(false);
            }
        }
        BufferedImage[] bufferedImageArray = this.images;
        synchronized (bufferedImageArray) {
            if (n >= 0 && n < this.length) {
                bufferedImage = this.images[n];
                bl = this.valid_images[n];
                n3 = this.width;
                n2 = this.height;
                AffineTransform affineTransform2 = affineTransform = this.tgeometry == null ? null : new AffineTransform(this.tgeometry);
                if (bufferedImage != null && !bl) {
                    this.valid_images[n] = true;
                }
            }
        }
        if (bufferedImage != null) {
            Object object;
            Graphics graphics2;
            Graphics2D graphics2D;
            BufferedImage[] bufferedImageArray2;
            Object object2;
            if (!bl) {
                int n4;
                String[] stringArray;
                object2 = this.displayRenderer.getRoot();
                bufferedImageArray2 = this.displayRenderer.getTrans();
                graphics2D = bufferedImage.createGraphics();
                graphics2 = bufferedImage.createGraphics();
                ((Graphics2D)graphics2).setBackground(this.getBackground());
                ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                graphics2.clearRect(0, 0, this.width, this.height);
                object = this.images;
                synchronized (object) {
                    this.tgeometry = new AffineTransform();
                    this.tgeometry.setToTranslation(0.5 * (double)n3, 0.5 * (double)n2);
                    stringArray = new AffineTransform();
                    n4 = n3 < n2 ? n3 : n2;
                    stringArray.setToScale(0.33 * (double)n4, 0.33 * (double)n4);
                    this.tgeometry.concatenate((AffineTransform)stringArray);
                    this.tgeometry.concatenate((AffineTransform)bufferedImageArray2);
                    affineTransform = new AffineTransform(this.tgeometry);
                    ((Graphics2D)graphics2).setTransform(this.tgeometry);
                }
                try {
                    if (animationControlJ2D != null) {
                        animationControlJ2D.init();
                    }
                    this.render((Graphics2D)graphics2, graphics2D, (VisADSceneGraphObject)object2, 0, null);
                    this.render((Graphics2D)graphics2, graphics2D, (VisADSceneGraphObject)object2, 1, null);
                    stringArray = this.displayRenderer.getAnimationString();
                    if (stringArray[0] != null) {
                        ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics2.setFont(new Font("Times New Roman", 0, 12));
                        ((Graphics2D)graphics2).setTransform(new AffineTransform());
                        n4 = stringArray[0].length();
                        if (n4 < 12) {
                            n4 = 12;
                        }
                        float f = n3 - 7 * n4;
                        float f2 = n2 - 12;
                        ((Graphics2D)graphics2).drawString(stringArray[0], f, f2);
                        ((Graphics2D)graphics2).drawString(stringArray[1], f, f2 + 10.0f);
                    }
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
                graphics2.dispose();
                graphics2D.dispose();
            }
            if (affineTransform == null || !this.displayRenderer.anyCursorStringVector()) {
                if (graphics != null) {
                    graphics.drawImage(bufferedImage, 0, 0, this);
                }
                if (this.captureFlag || this.display.hasSlaves()) {
                    this.captureFlag = false;
                    this.captureImage = this.component != null ? (BufferedImage)this.createImage(this.width, this.height) : new BufferedImage(this.width, this.height, 2);
                    if (this.captureImage != null) {
                        object2 = this.captureImage.getGraphics();
                        ((Graphics)object2).drawImage(bufferedImage, 0, 0, this);
                        ((Graphics)object2).dispose();
                        this.displayRenderer.notifyCapture();
                        if (this.display.hasSlaves()) {
                            this.display.updateSlaves(this.captureImage);
                        }
                    }
                }
            } else {
                object2 = null;
                bufferedImageArray2 = this.images;
                synchronized (bufferedImageArray2) {
                    if (this.aux_image == null) {
                        graphics2D = null;
                        return;
                    }
                    object2 = this.aux_image;
                }
                graphics2 = ((Image)object2).getGraphics();
                graphics2.drawImage(bufferedImage, 0, 0, this);
                this.displayRenderer.drawCursorStringVector(graphics2, affineTransform, n3, n2);
                graphics2.dispose();
                if (graphics != null) {
                    graphics.drawImage((Image)object2, 0, 0, this);
                }
                if (this.captureFlag || this.display.hasSlaves()) {
                    this.captureFlag = false;
                    this.captureImage = this.component != null ? (BufferedImage)this.createImage(this.width, this.height) : new BufferedImage(this.width, this.height, 2);
                    object = this.captureImage.getGraphics();
                    ((Graphics)object).drawImage((Image)object2, 0, 0, this);
                    ((Graphics)object).dispose();
                    this.displayRenderer.notifyCapture();
                    if (this.display.hasSlaves()) {
                        this.display.updateSlaves(this.captureImage);
                    }
                }
            }
            try {
                this.display.notifyListeners(3, 0, 0);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (animationControlJ2D != null) {
            animationControlJ2D.setNoTick(false);
        }
    }

    private void render(Graphics2D graphics2D, Graphics graphics, VisADSceneGraphObject visADSceneGraphObject, int n, Rectangle2D.Float float_) throws VisADException {
        if (visADSceneGraphObject instanceof VisADSwitch) {
            VisADSceneGraphObject visADSceneGraphObject2 = ((VisADSwitch)visADSceneGraphObject).getSelectedChild();
            if (visADSceneGraphObject2 != null) {
                this.render(graphics2D, graphics, visADSceneGraphObject2, n, float_);
            }
        } else if (visADSceneGraphObject instanceof VisADGroup) {
            if (this.clip_rectangle != null && (visADSceneGraphObject.equals(this.direct) || visADSceneGraphObject.equals(this.non_direct))) {
                float_ = this.clip_rectangle;
            }
            Vector vector = ((VisADGroup)visADSceneGraphObject).getChildren();
            int n2 = vector.size() - 1;
            while (n2 >= 0) {
                VisADSceneGraphObject visADSceneGraphObject3 = (VisADSceneGraphObject)vector.elementAt(n2);
                if (visADSceneGraphObject3 != null) {
                    this.render(graphics2D, graphics, visADSceneGraphObject3, n, float_);
                }
                --n2;
            }
        } else {
            graphics2D.setClip(float_);
            VisADAppearance visADAppearance = (VisADAppearance)visADSceneGraphObject;
            VisADGeometryArray visADGeometryArray = visADAppearance.array;
            if (visADGeometryArray == null) {
                return;
            }
            BufferedImage bufferedImage = (BufferedImage)visADAppearance.image;
            AffineTransform affineTransform = graphics2D.getTransform();
            if (bufferedImage != null) {
                if (n != 0) {
                    return;
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                if (!(visADGeometryArray instanceof VisADQuadArray)) {
                    throw new VisADError("VisADCanvasJ2D.render: array must be quad");
                }
                float f = visADGeometryArray.coordinates[0];
                float f2 = visADGeometryArray.coordinates[1];
                float f3 = visADGeometryArray.coordinates[3];
                float f4 = visADGeometryArray.coordinates[4];
                float f5 = visADGeometryArray.coordinates[6];
                float f6 = visADGeometryArray.coordinates[7];
                float f7 = visADGeometryArray.coordinates[9];
                float f8 = visADGeometryArray.coordinates[10];
                int n3 = bufferedImage.getWidth();
                int n4 = bufferedImage.getHeight();
                float f9 = f;
                float f10 = f2;
                float f11 = (f3 - f) / (float)n3;
                float f12 = (f4 - f2) / (float)n3;
                float f13 = (f7 - f) / (float)n4;
                float f14 = (f8 - f2) / (float)n4;
                float f15 = f5 - (f11 * (float)n3 + f13 * (float)n4 + f9);
                float f16 = f6 - (f12 * (float)n3 + f14 * (float)n4 + f10);
                AffineTransform affineTransform2 = new AffineTransform(f11, f12, f13, f14, f9, f10);
                graphics2D.transform(affineTransform2);
                graphics2D.drawImage((Image)bufferedImage, 0, 0, this);
                graphics2D.setTransform(affineTransform);
            } else {
                float f;
                if (visADGeometryArray instanceof VisADPointArray || visADGeometryArray instanceof VisADLineArray || visADGeometryArray instanceof VisADLineStripArray ? n != 1 : n != 0) {
                    return;
                }
                int n5 = visADGeometryArray.vertexCount;
                if (n5 == 0) {
                    return;
                }
                float[] fArray = visADGeometryArray.coordinates;
                byte[] byArray = visADGeometryArray.colors;
                if (byArray == null) {
                    if (visADAppearance.color_flag) {
                        f = Math.max(Math.min(visADAppearance.red, 1.0f), 0.0f);
                        float f17 = Math.max(Math.min(visADAppearance.green, 1.0f), 0.0f);
                        float f18 = Math.max(Math.min(visADAppearance.blue, 1.0f), 0.0f);
                        graphics2D.setColor(new Color(f, f17, f18));
                    } else {
                        graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f));
                    }
                }
                if (visADGeometryArray instanceof VisADPointArray || visADGeometryArray instanceof VisADLineArray || visADGeometryArray instanceof VisADLineStripArray) {
                    f = visADGeometryArray instanceof VisADPointArray ? visADAppearance.pointSize : visADAppearance.lineWidth;
                    double d = f;
                    if (d < 1.05) {
                        d = 1.05;
                    }
                    double[] dArray = new double[]{0.0, 0.0, 0.0, d, d, 0.0};
                    double[] dArray2 = new double[6];
                    double d2 = 0.0;
                    double d3 = 0.0;
                    try {
                        affineTransform.inverseTransform(dArray, 0, dArray2, 0, 3);
                        d2 = (dArray2[2] - dArray2[0]) * (dArray2[2] - dArray2[0]) + (dArray2[3] - dArray2[1]) * (dArray2[3] - dArray2[1]);
                        d3 = (dArray2[4] - dArray2[0]) * (dArray2[4] - dArray2[0]) + (dArray2[5] - dArray2[1]) * (dArray2[5] - dArray2[1]);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        d2 = 1.05;
                        d3 = 1.05;
                    }
                    float f19 = (float)(0.5 * (Math.sqrt(d2) + Math.sqrt(d3)));
                    graphics2D.setStroke(new BasicStroke(f19));
                    if (visADGeometryArray instanceof VisADPointArray) {
                        if (Math.abs(f - 1.0f) < 0.1f) {
                            VisADCanvasJ2D.drawAppearance(graphics, visADAppearance, affineTransform, float_);
                        } else {
                            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                            if (byArray == null) {
                                int n6 = 0;
                                while (n6 < 3 * n5) {
                                    if (fArray[n6] == fArray[n6] && fArray[n6 + 1] == fArray[n6 + 1]) {
                                        graphics2D.fill(new Rectangle2D.Float(fArray[n6], fArray[n6 + 1], f19, f19));
                                    }
                                    n6 += 3;
                                }
                            } else {
                                int n7 = 0;
                                int n8 = byArray.length == fArray.length ? 3 : 4;
                                int n9 = 0;
                                while (n9 < 3 * n5) {
                                    if (fArray[n9] == fArray[n9] && fArray[n9 + 1] == fArray[n9 + 1]) {
                                        graphics2D.setColor(new Color(byArray[n7] < 0 ? byArray[n7] + 256 : byArray[n7], byArray[n7 + 1] < 0 ? byArray[n7 + 1] + 256 : byArray[n7 + 1], byArray[n7 + 2] < 0 ? byArray[n7 + 2] + 256 : byArray[n7 + 2]));
                                        graphics2D.fill(new Rectangle2D.Float(fArray[n9], fArray[n9 + 1], f19, f19));
                                    }
                                    n7 += n8;
                                    n9 += 3;
                                }
                            }
                        }
                    } else if (visADGeometryArray instanceof VisADLineArray) {
                        if (Math.abs(f - 1.0f) < 0.1f) {
                            VisADCanvasJ2D.drawAppearance(graphics, visADAppearance, affineTransform, float_);
                        } else {
                            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            if (byArray == null) {
                                int n10 = 0;
                                while (n10 < 3 * n5) {
                                    graphics2D.draw(new Line2D.Float(fArray[n10], fArray[n10 + 1], fArray[n10 + 3], fArray[n10 + 4]));
                                    n10 += 6;
                                }
                            } else {
                                int n11 = 0;
                                int n12 = byArray.length == fArray.length ? 3 : 4;
                                int n13 = 0;
                                while (n13 < 3 * n5) {
                                    graphics2D.setColor(new Color(((byArray[n11] < 0 ? byArray[n11] + 256 : byArray[n11]) + (byArray[n11 + n12] < 0 ? byArray[n11 + n12] + 256 : byArray[n11 + n12])) / 2, ((byArray[n11 + 1] < 0 ? byArray[n11 + 1] + 256 : byArray[n11 + 1]) + (byArray[n11 + n12 + 1] < 0 ? byArray[n11 + n12 + 1] + 256 : byArray[n11 + n12 + 1])) / 2, ((byArray[n11 + 2] < 0 ? byArray[n11 + 2] + 256 : byArray[n11 + 2]) + (byArray[n11 + n12 + 2] < 0 ? byArray[n11 + n12 + 2] + 256 : byArray[n11 + n12 + 2])) / 2));
                                    n11 += 2 * n12;
                                    graphics2D.draw(new Line2D.Float(fArray[n13], fArray[n13 + 1], fArray[n13 + 3], fArray[n13 + 4]));
                                    n13 += 6;
                                }
                            }
                        }
                    } else {
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        int[] nArray = ((VisADLineStripArray)visADGeometryArray).stripVertexCounts;
                        int n14 = 0;
                        int n15 = 0;
                        int n16 = 0;
                        if (byArray != null) {
                            n16 = byArray.length == fArray.length ? 3 : 4;
                        }
                        int n17 = 0;
                        while (n17 < nArray.length) {
                            int n18;
                            n5 = nArray[n17];
                            float f20 = fArray[n14];
                            float f21 = fArray[n14 + 1];
                            int n19 = 0;
                            int n20 = 0;
                            int n21 = 0;
                            if (byArray != null) {
                                n19 = byArray[n15] < 0 ? byArray[n15] + 256 : byArray[n15];
                                n20 = byArray[n15 + 1] < 0 ? byArray[n15 + 1] + 256 : byArray[n15 + 1];
                                int n22 = n21 = byArray[n15 + 2] < 0 ? byArray[n15 + 2] + 256 : byArray[n15 + 2];
                            }
                            if (byArray == null) {
                                n18 = 3;
                                while (n18 < 3 * n5) {
                                    graphics2D.draw(new Line2D.Float(f20, f21, fArray[n14 + n18], fArray[n14 + n18 + 1]));
                                    f20 = fArray[n14 + n18];
                                    f21 = fArray[n14 + n18 + 1];
                                    n18 += 3;
                                }
                            } else {
                                n18 = n16;
                                int n23 = 3;
                                while (n23 < 3 * n5) {
                                    int n24 = byArray[n15 + n18] < 0 ? byArray[n15 + n18] + 256 : byArray[n15 + n18];
                                    int n25 = byArray[n15 + n18 + 1] < 0 ? byArray[n15 + n18 + 1] + 256 : byArray[n15 + n18 + 1];
                                    int n26 = byArray[n15 + n18 + 2] < 0 ? byArray[n15 + n18 + 2] + 256 : byArray[n15 + n18 + 2];
                                    graphics2D.setColor(new Color((n19 + n24) / 2, (n20 + n25) / 2, (n21 + n26) / 2));
                                    n19 = n24;
                                    n20 = n25;
                                    n21 = n26;
                                    n18 += n16;
                                    graphics2D.draw(new Line2D.Float(f20, f21, fArray[n14 + n23], fArray[n14 + n23 + 1]));
                                    f20 = fArray[n14 + n23];
                                    f21 = fArray[n14 + n23 + 1];
                                    n23 += 3;
                                }
                            }
                            n14 += 3 * n5;
                            n15 += n16 * n5;
                            ++n17;
                        }
                    }
                } else if (visADGeometryArray instanceof VisADTriangleArray) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    if (byArray == null) {
                        int n27 = 0;
                        while (n27 < 3 * n5) {
                            GeneralPath generalPath = new GeneralPath(0);
                            generalPath.moveTo(fArray[n27], fArray[n27 + 1]);
                            generalPath.lineTo(fArray[n27 + 3], fArray[n27 + 4]);
                            generalPath.lineTo(fArray[n27 + 6], fArray[n27 + 7]);
                            generalPath.closePath();
                            graphics2D.fill(generalPath);
                            n27 += 9;
                        }
                    } else {
                        int n28 = 0;
                        int n29 = byArray.length == fArray.length ? 3 : 4;
                        int n30 = 0;
                        while (n30 < 3 * n5) {
                            graphics2D.setColor(new Color(((byArray[n28] < 0 ? byArray[n28] + 256 : byArray[n28]) + (byArray[n28 + n29] < 0 ? byArray[n28 + n29] + 256 : byArray[n28 + n29]) + (byArray[n28 + 2 * n29] < 0 ? byArray[n28 + 2 * n29] + 256 : byArray[n28 + 2 * n29])) / 3, ((byArray[n28 + 1] < 0 ? byArray[n28 + 1] + 256 : byArray[n28 + 1]) + (byArray[n28 + n29 + 1] < 0 ? byArray[n28 + n29 + 1] + 256 : byArray[n28 + n29 + 1]) + (byArray[n28 + 2 * n29 + 1] < 0 ? byArray[n28 + 2 * n29 + 1] + 256 : byArray[n28 + 2 * n29 + 1])) / 3, ((byArray[n28 + 2] < 0 ? byArray[n28 + 2] + 256 : byArray[n28 + 2]) + (byArray[n28 + n29 + 2] < 0 ? byArray[n28 + n29 + 2] + 256 : byArray[n28 + n29 + 2]) + (byArray[n28 + 2 * n29 + 2] < 0 ? byArray[n28 + 2 * n29 + 2] + 256 : byArray[n28 + 2 * n29 + 2])) / 3));
                            n28 += 3 * n29;
                            GeneralPath generalPath = new GeneralPath(0);
                            generalPath.moveTo(fArray[n30], fArray[n30 + 1]);
                            generalPath.lineTo(fArray[n30 + 3], fArray[n30 + 4]);
                            generalPath.lineTo(fArray[n30 + 6], fArray[n30 + 7]);
                            generalPath.closePath();
                            graphics2D.fill(generalPath);
                            n30 += 9;
                        }
                    }
                } else if (visADGeometryArray instanceof VisADQuadArray) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    if (byArray == null) {
                        int n31 = 0;
                        while (n31 < 3 * n5) {
                            GeneralPath generalPath = new GeneralPath(0);
                            generalPath.moveTo(fArray[n31], fArray[n31 + 1]);
                            generalPath.lineTo(fArray[n31 + 3], fArray[n31 + 4]);
                            generalPath.lineTo(fArray[n31 + 6], fArray[n31 + 7]);
                            generalPath.lineTo(fArray[n31 + 9], fArray[n31 + 10]);
                            generalPath.closePath();
                            graphics2D.fill(generalPath);
                            n31 += 12;
                        }
                    } else {
                        int n32 = 0;
                        int n33 = byArray.length == fArray.length ? 3 : 4;
                        int n34 = 0;
                        while (n34 < 3 * n5) {
                            graphics2D.setColor(new Color(((byArray[n32] < 0 ? byArray[n32] + 256 : byArray[n32]) + (byArray[n32 + n33] < 0 ? byArray[n32 + n33] + 256 : byArray[n32 + n33]) + (byArray[n32 + 2 * n33] < 0 ? byArray[n32 + 2 * n33] + 256 : byArray[n32 + 2 * n33]) + (byArray[n32 + 3 * n33] < 0 ? byArray[n32 + 3 * n33] + 256 : byArray[n32 + 3 * n33])) / 4, ((byArray[n32 + 1] < 0 ? byArray[n32 + 1] + 256 : byArray[n32 + 1]) + (byArray[n32 + n33 + 1] < 0 ? byArray[n32 + n33 + 1] + 256 : byArray[n32 + n33 + 1]) + (byArray[n32 + 2 * n33 + 1] < 0 ? byArray[n32 + 2 * n33 + 1] + 256 : byArray[n32 + 2 * n33 + 1]) + (byArray[n32 + 3 * n33 + 1] < 0 ? byArray[n32 + 3 * n33 + 1] + 256 : byArray[n32 + 3 * n33 + 1])) / 4, ((byArray[n32 + 2] < 0 ? byArray[n32 + 2] + 256 : byArray[n32 + 2]) + (byArray[n32 + n33 + 2] < 0 ? byArray[n32 + n33 + 2] + 256 : byArray[n32 + n33 + 2]) + (byArray[n32 + 2 * n33 + 2] < 0 ? byArray[n32 + 2 * n33 + 2] + 256 : byArray[n32 + 2 * n33 + 2]) + (byArray[n32 + 3 * n33 + 2] < 0 ? byArray[n32 + 3 * n33 + 2] + 256 : byArray[n32 + 3 * n33 + 2])) / 4));
                            n32 += 4 * n33;
                            GeneralPath generalPath = new GeneralPath(0);
                            generalPath.moveTo(fArray[n34], fArray[n34 + 1]);
                            generalPath.lineTo(fArray[n34 + 3], fArray[n34 + 4]);
                            generalPath.lineTo(fArray[n34 + 6], fArray[n34 + 7]);
                            generalPath.lineTo(fArray[n34 + 9], fArray[n34 + 10]);
                            generalPath.closePath();
                            graphics2D.fill(generalPath);
                            n34 += 12;
                        }
                    }
                } else if (visADGeometryArray instanceof VisADIndexedTriangleStripArray) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    int[] nArray = ((VisADIndexedTriangleStripArray)visADGeometryArray).indices;
                    int n35 = ((VisADIndexedTriangleStripArray)visADGeometryArray).indexCount;
                    int[] nArray2 = ((VisADIndexedTriangleStripArray)visADGeometryArray).stripVertexCounts;
                    int n36 = 0;
                    int n37 = 0;
                    while (n37 < nArray2.length) {
                        int n38;
                        int n39;
                        n5 = nArray2[n37];
                        int n40 = nArray[n36];
                        int n41 = nArray[n36 + 1];
                        if (byArray == null) {
                            n39 = n36 + 2;
                            while (n39 < n36 + n5) {
                                n38 = nArray[n39];
                                GeneralPath generalPath = new GeneralPath(0);
                                generalPath.moveTo(fArray[3 * n40], fArray[3 * n40 + 1]);
                                generalPath.lineTo(fArray[3 * n41], fArray[3 * n41 + 1]);
                                generalPath.lineTo(fArray[3 * n38], fArray[3 * n38 + 1]);
                                generalPath.closePath();
                                graphics2D.fill(generalPath);
                                n40 = n41;
                                n41 = n38;
                                ++n39;
                            }
                        } else {
                            n39 = byArray.length == fArray.length ? 3 : 4;
                            n38 = n36 + 2;
                            while (n38 < n36 + n5) {
                                int n42 = nArray[n38];
                                graphics2D.setColor(new Color(((byArray[n39 * n40] < 0 ? byArray[n39 * n40] + 256 : byArray[n39 * n40]) + (byArray[n39 * n41] < 0 ? byArray[n39 * n41] + 256 : byArray[n39 * n41]) + (byArray[n39 * n42] < 0 ? byArray[n39 * n42] + 256 : byArray[n39 * n42])) / 3, ((byArray[n39 * n40 + 1] < 0 ? byArray[n39 * n40 + 1] + 256 : byArray[n39 * n40 + 1]) + (byArray[n39 * n41 + 1] < 0 ? byArray[n39 * n41 + 1] + 256 : byArray[n39 * n41 + 1]) + (byArray[n39 * n42 + 1] < 0 ? byArray[n39 * n42 + 1] + 256 : byArray[n39 * n42 + 1])) / 3, ((byArray[n39 * n40 + 2] < 0 ? byArray[n39 * n40 + 2] + 256 : byArray[n39 * n40 + 2]) + (byArray[n39 * n41 + 2] < 0 ? byArray[n39 * n41 + 2] + 256 : byArray[n39 * n41 + 2]) + (byArray[n39 * n42 + 2] < 0 ? byArray[n39 * n42 + 2] + 256 : byArray[n39 * n42 + 2])) / 3));
                                GeneralPath generalPath = new GeneralPath(0);
                                generalPath.moveTo(fArray[3 * n40], fArray[3 * n40 + 1]);
                                generalPath.lineTo(fArray[3 * n41], fArray[3 * n41 + 1]);
                                generalPath.lineTo(fArray[3 * n42], fArray[3 * n42 + 1]);
                                generalPath.closePath();
                                graphics2D.fill(generalPath);
                                n40 = n41;
                                n41 = n42;
                                ++n38;
                            }
                        }
                        n36 += n5;
                        ++n37;
                    }
                } else if (visADGeometryArray instanceof VisADTriangleStripArray) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    int[] nArray = ((VisADTriangleStripArray)visADGeometryArray).stripVertexCounts;
                    int n43 = 0;
                    int n44 = 0;
                    int n45 = 0;
                    if (byArray != null) {
                        n45 = byArray.length == fArray.length ? 3 : 4;
                    }
                    int n46 = 0;
                    while (n46 < nArray.length) {
                        int n47;
                        n5 = nArray[n46];
                        float f22 = fArray[n43];
                        float f23 = fArray[n43 + 1];
                        float f24 = fArray[n43 + 3];
                        float f25 = fArray[n43 + 4];
                        int n48 = 0;
                        int n49 = 0;
                        int n50 = 0;
                        int n51 = 0;
                        int n52 = 0;
                        int n53 = 0;
                        if (byArray != null) {
                            n48 = byArray[n44] < 0 ? byArray[n44] + 256 : byArray[n44];
                            n49 = byArray[n44 + 1] < 0 ? byArray[n44 + 1] + 256 : byArray[n44 + 1];
                            n50 = byArray[n44 + 2] < 0 ? byArray[n44 + 2] + 256 : byArray[n44 + 2];
                            n51 = byArray[n44 + n45] < 0 ? byArray[n44 + n45] + 256 : byArray[n44 + n45];
                            n52 = byArray[n44 + n45 + 1] < 0 ? byArray[n44 + n45 + 1] + 256 : byArray[n44 + n45 + 1];
                            int n54 = n53 = byArray[n44 + n45 + 2] < 0 ? byArray[n44 + n45 + 2] + 256 : byArray[n44 + n45 + 2];
                        }
                        if (byArray == null) {
                            n47 = 6;
                            while (n47 < 3 * n5) {
                                GeneralPath generalPath = new GeneralPath(0);
                                generalPath.moveTo(f22, f23);
                                generalPath.lineTo(f24, f25);
                                generalPath.lineTo(fArray[n43 + n47], fArray[n43 + n47 + 1]);
                                generalPath.closePath();
                                graphics2D.fill(generalPath);
                                f22 = f24;
                                f23 = f25;
                                f24 = fArray[n43 + n47];
                                f25 = fArray[n43 + n47 + 1];
                                n47 += 3;
                            }
                        } else {
                            n47 = 2 * n45;
                            int n55 = 6;
                            while (n55 < 3 * n5) {
                                int n56 = byArray[n44 + n47] < 0 ? byArray[n44 + n47] + 256 : byArray[n44 + n47];
                                int n57 = byArray[n44 + n47 + 1] < 0 ? byArray[n44 + n47 + 1] + 256 : byArray[n44 + n47 + 1];
                                int n58 = byArray[n44 + n47 + 2] < 0 ? byArray[n44 + n47 + 2] + 256 : byArray[n44 + n47 + 2];
                                graphics2D.setColor(new Color((n56 + n51 + n48) / 3, (n57 + n52 + n49) / 3, (n58 + n53 + n50) / 3));
                                n48 = n51;
                                n49 = n52;
                                n50 = n53;
                                n51 = n56;
                                n52 = n57;
                                n53 = n58;
                                n47 += n45;
                                GeneralPath generalPath = new GeneralPath(0);
                                generalPath.moveTo(f22, f23);
                                generalPath.lineTo(f24, f25);
                                generalPath.lineTo(fArray[n43 + n55], fArray[n43 + n55 + 1]);
                                generalPath.closePath();
                                graphics2D.fill(generalPath);
                                f22 = f24;
                                f23 = f25;
                                f24 = fArray[n43 + n55];
                                f25 = fArray[n43 + n55 + 1];
                                n55 += 3;
                            }
                        }
                        n43 += 3 * n5;
                        n44 += n45 * n5;
                        ++n46;
                    }
                } else {
                    throw new VisADError("VisADCanvasJ2D.render: bad array class");
                }
            }
        }
    }

    public static void drawAppearance(Graphics graphics, VisADAppearance visADAppearance, AffineTransform affineTransform, Rectangle2D.Float float_) {
        VisADGeometryArray visADGeometryArray = visADAppearance.array;
        if (visADGeometryArray == null) {
            return;
        }
        byte[] byArray = visADGeometryArray.colors;
        if (byArray == null) {
            if (visADAppearance.color_flag) {
                graphics.setColor(new Color(visADAppearance.red, visADAppearance.green, visADAppearance.blue));
            } else {
                graphics.setColor(new Color(1.0f, 1.0f, 1.0f));
            }
        }
        int n = visADGeometryArray.vertexCount;
        float[] fArray = visADGeometryArray.coordinates;
        float[] fArray2 = new float[2 * n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3 * n) {
            fArray2[n2++] = fArray[n3];
            fArray2[n2++] = fArray[n3 + 1];
            n3 += 3;
        }
        float[] fArray3 = new float[2 * n];
        affineTransform.transform(fArray2, 0, fArray3, 0, n);
        if (float_ == null) {
            graphics.setClip(null);
        } else {
            float f = (float)float_.getX();
            float f2 = (float)float_.getY();
            float f3 = (float)float_.getWidth();
            float f4 = (float)float_.getHeight();
            float[] fArray4 = new float[]{f, f2, f, f2 + f4, f + f3, f2 + f4, f + f3, f2};
            float[] fArray5 = new float[8];
            affineTransform.transform(fArray4, 0, fArray5, 0, 4);
            GeneralPath generalPath = new GeneralPath(0);
            generalPath.moveTo(fArray5[0], fArray5[1]);
            generalPath.lineTo(fArray5[2], fArray5[3]);
            generalPath.lineTo(fArray5[4], fArray5[5]);
            generalPath.lineTo(fArray5[6], fArray5[7]);
            generalPath.closePath();
            graphics.setClip(generalPath);
        }
        if (visADGeometryArray instanceof VisADPointArray) {
            if (byArray == null) {
                int n4 = 0;
                while (n4 < 2 * n) {
                    graphics.drawLine((int)fArray3[n4], (int)fArray3[n4 + 1], (int)fArray3[n4], (int)fArray3[n4 + 1]);
                    n4 += 2;
                }
            } else {
                int n5 = byArray.length == fArray.length ? 3 : 4;
                n2 = 0;
                int n6 = 0;
                while (n6 < 2 * n) {
                    graphics.setColor(new Color(byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2], byArray[n2 + 1] < 0 ? byArray[n2 + 1] + 256 : byArray[n2 + 1], byArray[n2 + 2] < 0 ? byArray[n2 + 2] + 256 : byArray[n2 + 2]));
                    n2 += n5;
                    graphics.drawLine((int)fArray3[n6], (int)fArray3[n6 + 1], (int)fArray3[n6], (int)fArray3[n6 + 1]);
                    n6 += 2;
                }
            }
        } else if (visADGeometryArray instanceof VisADLineArray) {
            if (byArray == null) {
                int n7 = 0;
                while (n7 < 2 * n) {
                    graphics.drawLine((int)fArray3[n7], (int)fArray3[n7 + 1], (int)fArray3[n7 + 2], (int)fArray3[n7 + 3]);
                    n7 += 4;
                }
            } else {
                int n8 = byArray.length == fArray.length ? 3 : 4;
                n2 = 0;
                int n9 = 0;
                while (n9 < 2 * n) {
                    graphics.setColor(new Color(((byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2]) + (byArray[n2 + n8] < 0 ? byArray[n2 + n8] + 256 : byArray[n2 + n8])) / 2, ((byArray[n2 + 1] < 0 ? byArray[n2 + 1] + 256 : byArray[n2 + 1]) + (byArray[n2 + n8 + 1] < 0 ? byArray[n2 + n8 + 1] + 256 : byArray[n2 + n8 + 1])) / 2, ((byArray[n2 + 2] < 0 ? byArray[n2 + 2] + 256 : byArray[n2 + 2]) + (byArray[n2 + n8 + 2] < 0 ? byArray[n2 + n8 + 2] + 256 : byArray[n2 + n8 + 2])) / 2));
                    n2 += 2 * n8;
                    graphics.drawLine((int)fArray3[n9], (int)fArray3[n9 + 1], (int)fArray3[n9 + 2], (int)fArray3[n9 + 3]);
                    n9 += 4;
                }
            }
        } else {
            throw new VisADError("DisplayRendererJ2D.drawAppearance: bad VisADGeometryArray type");
        }
    }

    public AffineTransform getTransform() {
        BufferedImage[] bufferedImageArray = this.images;
        synchronized (bufferedImageArray) {
            AffineTransform affineTransform = this.tgeometry;
            Object var2_3 = null;
            return affineTransform;
        }
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public void setPreferredSize(Dimension dimension) {
        this.prefSize = dimension;
    }

    public boolean getAutoAspect() {
        return this.autoAspect;
    }

    public void setAutoAspect(boolean bl) {
        this.autoAspect = bl;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 < 1 || n4 < 1) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
        if (this.autoAspect) {
            ProjectionControl projectionControl = this.display.getProjectionControl();
            try {
                double d;
                double d2;
                if (n4 > n3) {
                    d2 = 1.0;
                    d = n4 / n3;
                } else {
                    d2 = n3 / n4;
                    d = 1.0;
                }
                projectionControl.setAspectCartesian(new double[]{d2, d});
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public VisADCanvasJ2D(DisplayRendererJ2D displayRendererJ2D, Component component) {
        this.displayRenderer = displayRendererJ2D;
        this.display = (DisplayImplJ2D)displayRendererJ2D.getDisplay();
        this.component = component;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.length = 1;
        this.images = new BufferedImage[]{(BufferedImage)this.createImage(this.width, this.height)};
        this.aux_image = this.createImage(this.width, this.height);
        this.valid_images = new boolean[]{false};
        this.tgeometry = null;
        ComponentAdapter componentAdapter = new ComponentAdapter(this){
            private final /* synthetic */ VisADCanvasJ2D this$0;

            public void componentResized(ComponentEvent componentEvent) {
                this.this$0.createImages(-1);
            }
            {
                this.this$0 = visADCanvasJ2D;
                this.constructor$0(visADCanvasJ2D);
            }

            private final void constructor$0(VisADCanvasJ2D visADCanvasJ2D) {
            }
        };
        this.addComponentListener(componentAdapter);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        new Delay();
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    public VisADCanvasJ2D(DisplayRendererJ2D displayRendererJ2D, int n, int n2) {
        this.displayRenderer = displayRendererJ2D;
        this.display = (DisplayImplJ2D)displayRendererJ2D.getDisplay();
        this.component = null;
        this.width = n;
        this.height = n2;
        this.length = 1;
        this.images = new BufferedImage[]{new BufferedImage(this.width, this.height, 2)};
        this.aux_image = new BufferedImage(this.width, this.height, 2);
        this.valid_images = new boolean[]{false};
        this.tgeometry = null;
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }
}

