/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.Control;
import visad.ValueControl;
import visad.VisADException;
import visad.browser.Convert;
import visad.java2d.AVControlJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.VisADCanvasJ2D;

public class ValueControlJ2D
extends AVControlJ2D
implements ValueControl {
    private double Value = 0.0;
    private VisADCanvasJ2D canvas;

    public void setValue(double d) throws VisADException, RemoteException {
        this.Value = d;
        this.selectSwitches(this.Value, null);
        this.canvas.scratchImages();
        this.changeControl(true);
    }

    public void init() throws VisADException {
        this.selectSwitches(this.Value, null);
    }

    public double getValue() {
        return this.Value;
    }

    public String getSaveString() {
        return "" + this.Value;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        this.setValue(Convert.getDouble(string.trim()));
    }

    public void syncControl(Control control) throws VisADException {
        double d;
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof ValueControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        ValueControl valueControl = (ValueControl)((Object)control);
        boolean bl = false;
        double d2 = this.getValue();
        if (Math.abs(d2 - (d = valueControl.getValue())) > 0.001) {
            try {
                this.setValue(d);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not set value: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        double d;
        if (!super.equals(object)) {
            return false;
        }
        ValueControlJ2D valueControlJ2D = (ValueControlJ2D)object;
        double d2 = this.getValue();
        return !(Math.abs(d2 - (d = valueControlJ2D.getValue())) > 0.001);
    }

    public ValueControlJ2D(DisplayImplJ2D displayImplJ2D) {
        super(displayImplJ2D);
        if (displayImplJ2D != null) {
            this.canvas = ((DisplayRendererJ2D)displayImplJ2D.getDisplayRenderer()).getCanvas();
        }
    }
}

