/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.BadMappingException;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayInterruptException;
import visad.FunctionType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.ShadowType;
import visad.TextType;
import visad.TupleType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.VisADGroup;
import visad.VisADSwitch;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.ShadowFunctionTypeJ2D;
import visad.java2d.ShadowRealTupleTypeJ2D;
import visad.java2d.ShadowRealTypeJ2D;
import visad.java2d.ShadowSetTypeJ2D;
import visad.java2d.ShadowTextTypeJ2D;
import visad.java2d.ShadowTupleTypeJ2D;
import visad.java2d.VisADCanvasJ2D;

public abstract class RendererJ2D
extends DataRenderer {
    VisADGroup swParent;
    VisADSwitch swit;

    public void setLinks(DataDisplayLink[] dataDisplayLinkArray, DisplayImpl displayImpl) throws VisADException {
        if (this.getDisplay() != null || this.getLinks() != null) {
            throw new DisplayException("RendererJ2D.setLinks: already set");
        }
        if (!(displayImpl instanceof DisplayImplJ2D)) {
            throw new DisplayException("RendererJ2D.setLinks: must be DisplayImplJ2D");
        }
        this.setDisplay(displayImpl);
        this.setDisplayRenderer(displayImpl.getDisplayRenderer());
        this.setLinks(dataDisplayLinkArray);
        this.swParent = new VisADGroup();
        this.swit = new VisADSwitch();
        VisADGroup visADGroup = new VisADGroup();
        this.swit.addChild(this.swParent);
        this.swit.addChild(visADGroup);
        this.swit.setWhichChild(0);
        this.addSwitch((DisplayRendererJ2D)this.getDisplayRenderer(), this.swit);
    }

    public void toggle(boolean bl) {
        if (this.swit != null) {
            this.swit.setWhichChild(bl ? 0 : 1);
            VisADCanvasJ2D visADCanvasJ2D = ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas();
            visADCanvasJ2D.scratchImages();
        }
        super.toggle(bl);
    }

    public ShadowType makeShadowFunctionType(FunctionType functionType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowFunctionTypeJ2D(functionType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealTupleType(RealTupleType realTupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowRealTupleTypeJ2D(realTupleType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowRealType(RealType realType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowRealTypeJ2D(realType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowSetType(SetType setType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowSetTypeJ2D(setType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowTextType(TextType textType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowTextTypeJ2D(textType, dataDisplayLink, shadowType);
    }

    public ShadowType makeShadowTupleType(TupleType tupleType, DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return new ShadowTupleTypeJ2D(tupleType, dataDisplayLink, shadowType);
    }

    abstract void addSwitch(DisplayRendererJ2D var1, VisADGroup var2) throws VisADException;

    public boolean doAction() throws VisADException, RemoteException {
        boolean bl = this.get_all_feasible();
        boolean bl2 = this.get_any_changed();
        boolean bl3 = this.get_any_transform_control();
        boolean bl4 = false;
        if (bl && (bl2 || bl3)) {
            VisADGroup visADGroup;
            this.clearAVControls();
            try {
                visADGroup = this.doTransform();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                try {
                    if (this.swParent.numChildren() > 0) {
                        this.swParent.removeChild(0);
                    }
                    visADGroup = null;
                    Runtime.getRuntime().gc();
                    Runtime.getRuntime().runFinalization();
                    visADGroup = this.doTransform();
                }
                catch (BadMappingException badMappingException) {
                    this.addException(badMappingException);
                    visADGroup = null;
                }
                catch (UnimplementedException unimplementedException) {
                    this.addException(unimplementedException);
                    visADGroup = null;
                }
                catch (RemoteException remoteException) {
                    this.addException(remoteException);
                    visADGroup = null;
                }
                catch (DisplayInterruptException displayInterruptException) {
                    visADGroup = null;
                }
            }
            catch (BadMappingException badMappingException) {
                this.addException(badMappingException);
                visADGroup = null;
            }
            catch (UnimplementedException unimplementedException) {
                this.addException(unimplementedException);
                visADGroup = null;
            }
            catch (RemoteException remoteException) {
                this.addException(remoteException);
                visADGroup = null;
            }
            catch (DisplayInterruptException displayInterruptException) {
                visADGroup = null;
            }
            if (visADGroup != null) {
                this.swParent.setChild(visADGroup, 0);
                bl4 = true;
            } else {
                if (this.swParent.numChildren() > 0) {
                    this.swParent.removeChild(0);
                    bl4 = true;
                }
                bl = false;
                this.set_all_feasible(bl);
            }
        } else {
            DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
            int n = 0;
            while (n < dataDisplayLinkArray.length) {
                dataDisplayLinkArray[n].clearData();
                ++n;
            }
        }
        if (bl4) {
            ((DisplayImplJ2D)this.getDisplay()).setScratch();
        }
        return bl && (bl2 || bl3);
    }

    public void clearBranch() {
        if (this.swParent.numChildren() > 0) {
            this.swParent.removeChild(0);
            VisADCanvasJ2D visADCanvasJ2D = ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas();
            visADCanvasJ2D.scratchImages();
        }
    }

    public void clearScene() {
        this.swParent.detach();
        ((DisplayRendererJ2D)this.getDisplayRenderer()).clearScene(this);
        VisADCanvasJ2D visADCanvasJ2D = ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas();
        visADCanvasJ2D.scratchImages();
    }

    public abstract VisADGroup doTransform() throws VisADException, RemoteException;
}

