/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import visad.DisplayRenderer;
import visad.KeyboardBehavior;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.VisADException;
import visad.java2d.DisplayRendererJ2D;

public class KeyboardBehaviorJ2D
implements KeyboardBehavior {
    public static final int ROTATE_Z_POS = 7;
    public static final int ROTATE_Z_NEG = 8;
    private ProjectionControl proj;
    private DisplayRenderer displayRenderer;
    private MouseBehavior mouseBehavior;
    private double rotateAmount = 5.0;
    private double scaleAmount = 0.05;
    private double transAmount = 0.1;
    private final int MAX_FUNCTIONS;
    private int[] functionKeys = new int[9];
    private int[] functionMods = new int[9];

    public void mapKeyToFunction(int n, int n2, int n3) {
        if (n < 0 || n >= 9) {
            return;
        }
        this.functionKeys[n] = n2;
        this.functionMods[n] = n3;
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        int n3 = 0;
        while (n3 < 9) {
            if (this.functionKeys[n3] == n2 && n == this.functionMods[n3]) {
                this.execFunction(n3);
                break;
            }
            ++n3;
        }
    }

    public void execFunction(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        double d4 = 0.0;
        double[] dArray = null;
        double[] dArray2 = this.proj.getMatrix();
        switch (n) {
            case 0: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, d, d2 -= this.transAmount, 0.0);
                break;
            }
            case 1: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, d, d2 += this.transAmount, 0.0);
                break;
            }
            case 2: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, d -= this.transAmount, d2, 0.0);
                break;
            }
            case 3: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, d += this.transAmount, d2, 0.0);
                break;
            }
            case 6: {
                dArray2 = this.proj.getSavedProjectionMatrix();
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 4: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, d3 += this.scaleAmount, 0.0, 0.0, 0.0);
                break;
            }
            case 5: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, 0.0, d3 -= this.scaleAmount, 0.0, 0.0, 0.0);
                break;
            }
            case 8: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, d4 -= this.rotateAmount, 1.0, 0.0, 0.0, 0.0);
                break;
            }
            case 7: {
                dArray = this.mouseBehavior.make_matrix(0.0, 0.0, d4 += this.rotateAmount, 1.0, 0.0, 0.0, 0.0);
                break;
            }
        }
        if (dArray != null) {
            dArray = this.mouseBehavior.multiply_matrix(dArray, dArray2);
            try {
                this.proj.setMatrix(dArray);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public KeyboardBehaviorJ2D(DisplayRendererJ2D displayRendererJ2D) {
        this.MAX_FUNCTIONS = 9;
        this.displayRenderer = displayRendererJ2D;
        this.proj = this.displayRenderer.getDisplay().getProjectionControl();
        this.mouseBehavior = this.displayRenderer.getMouseBehavior();
        this.mapKeyToFunction(0, 38, 0);
        this.mapKeyToFunction(1, 40, 0);
        this.mapKeyToFunction(2, 37, 0);
        this.mapKeyToFunction(3, 39, 0);
        this.mapKeyToFunction(4, 38, 1);
        this.mapKeyToFunction(5, 40, 1);
        this.mapKeyToFunction(6, 82, 2);
        this.mapKeyToFunction(7, 37, 1);
        this.mapKeyToFunction(8, 39, 1);
    }
}

