/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.Control;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.GraphicsModeControl;
import visad.VisADException;
import visad.util.Util;

public class GraphicsModeControlJ2D
extends GraphicsModeControl {
    private float lineWidth = 1.0f;
    private float pointSize = 1.0f;
    private boolean pointMode = false;
    private boolean textureEnable = true;
    private boolean scaleEnable = false;
    private int transparencyMode = 0;
    private int projectionPolicy = 0;
    private int polygonMode = 0;
    private boolean missingTransparent = true;
    private int curvedSize = 10;

    public boolean getMode2D() {
        return this.getDisplayRenderer().getMode2D();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f) throws VisADException, RemoteException {
        if (f < 1.0f) {
            throw new DisplayException("GraphicsModeControlJ2D.setLineWidth: width < 1.0");
        }
        this.lineWidth = f;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setLineWidth(float f, boolean bl) {
        if (f >= 1.0f) {
            this.lineWidth = f;
        }
    }

    public float getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(float f) throws VisADException, RemoteException {
        if (f < 1.0f) {
            throw new DisplayException("GraphicsModeControlJ2D.setPointSize: size < 1.0");
        }
        this.pointSize = f;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setPointSize(float f, boolean bl) {
        if (f >= 1.0f) {
            this.pointSize = f;
        }
    }

    public boolean getPointMode() {
        return this.pointMode;
    }

    public void setPointMode(boolean bl) throws VisADException, RemoteException {
        this.pointMode = bl;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public void setTextureEnable(boolean bl) throws VisADException, RemoteException {
        this.textureEnable = bl;
        this.changeControl(true);
        this.getDisplay().reDisplayAll();
    }

    public boolean getTextureEnable() {
        return this.textureEnable;
    }

    public void setScaleEnable(boolean bl) throws VisADException, RemoteException {
        this.scaleEnable = bl;
        this.getDisplayRenderer().setScaleOn(bl);
        this.changeControl(true);
    }

    public boolean getScaleEnable() {
        return this.scaleEnable;
    }

    public int getTransparencyMode() {
        return this.transparencyMode;
    }

    public void setTransparencyMode(int n) throws VisADException, RemoteException {
        if (n != 0) {
            throw new DisplayException("GraphicsModeControlJ2D.setTransparencyMode: bad mode");
        }
        this.transparencyMode = n;
    }

    public void setProjectionPolicy(int n) throws VisADException, RemoteException {
        if (n != 0) {
            throw new DisplayException("GraphicsModeControlJ2D.setProjectionPolicy: bad policy");
        }
        this.projectionPolicy = n;
    }

    public int getProjectionPolicy() {
        return this.projectionPolicy;
    }

    public void setPolygonMode(int n) throws VisADException, RemoteException {
        if (n != 0) {
            throw new DisplayException("GraphicsModeControlJ2D.setPolygonMode: bad mode");
        }
        this.polygonMode = n;
    }

    public int getPolygonMode() {
        return this.polygonMode;
    }

    public boolean getMissingTransparent() {
        return this.missingTransparent;
    }

    public void setMissingTransparent(boolean bl) throws VisADException, RemoteException {
        if (bl) {
            throw new DisplayException("GraphicsModeControlJ2D.setMissingTransparent: must be false");
        }
        this.missingTransparent = bl;
    }

    public int getCurvedSize() {
        return this.curvedSize;
    }

    public void setCurvedSize(int n) {
        this.curvedSize = n;
    }

    public Object clone() {
        GraphicsModeControlJ2D graphicsModeControlJ2D = new GraphicsModeControlJ2D(this.getDisplay());
        graphicsModeControlJ2D.lineWidth = this.lineWidth;
        graphicsModeControlJ2D.pointSize = this.pointSize;
        graphicsModeControlJ2D.pointMode = this.pointMode;
        graphicsModeControlJ2D.textureEnable = this.textureEnable;
        graphicsModeControlJ2D.scaleEnable = this.scaleEnable;
        graphicsModeControlJ2D.transparencyMode = this.transparencyMode;
        graphicsModeControlJ2D.projectionPolicy = this.projectionPolicy;
        graphicsModeControlJ2D.missingTransparent = this.missingTransparent;
        graphicsModeControlJ2D.polygonMode = this.polygonMode;
        graphicsModeControlJ2D.curvedSize = this.curvedSize;
        return graphicsModeControlJ2D;
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof GraphicsModeControlJ2D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        GraphicsModeControlJ2D graphicsModeControlJ2D = (GraphicsModeControlJ2D)control;
        boolean bl = false;
        boolean bl2 = false;
        if (!Util.isApproximatelyEqual(this.lineWidth, graphicsModeControlJ2D.lineWidth)) {
            bl = true;
            bl2 = true;
            this.lineWidth = graphicsModeControlJ2D.lineWidth;
        }
        if (!Util.isApproximatelyEqual(this.pointSize, graphicsModeControlJ2D.pointSize)) {
            bl = true;
            bl2 = true;
            this.pointSize = graphicsModeControlJ2D.pointSize;
        }
        if (this.pointMode != graphicsModeControlJ2D.pointMode) {
            bl = true;
            bl2 = true;
            this.pointMode = graphicsModeControlJ2D.pointMode;
        }
        if (this.textureEnable != graphicsModeControlJ2D.textureEnable) {
            bl = true;
            bl2 = true;
            this.textureEnable = graphicsModeControlJ2D.textureEnable;
        }
        if (this.scaleEnable != graphicsModeControlJ2D.scaleEnable) {
            bl = true;
            this.scaleEnable = graphicsModeControlJ2D.scaleEnable;
            this.getDisplayRenderer().setScaleOn(this.scaleEnable);
        }
        if (this.transparencyMode != graphicsModeControlJ2D.transparencyMode) {
            bl = true;
            this.transparencyMode = graphicsModeControlJ2D.transparencyMode;
        }
        if (this.projectionPolicy != graphicsModeControlJ2D.projectionPolicy) {
            bl = true;
            this.projectionPolicy = graphicsModeControlJ2D.projectionPolicy;
        }
        if (this.polygonMode != graphicsModeControlJ2D.polygonMode) {
            bl = true;
            this.polygonMode = graphicsModeControlJ2D.polygonMode;
        }
        if (this.missingTransparent != graphicsModeControlJ2D.missingTransparent) {
            bl = true;
            this.missingTransparent = graphicsModeControlJ2D.missingTransparent;
        }
        if (this.curvedSize != graphicsModeControlJ2D.curvedSize) {
            bl = true;
            this.curvedSize = graphicsModeControlJ2D.curvedSize;
        }
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
        if (bl2) {
            this.getDisplay().reDisplayAll();
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        GraphicsModeControlJ2D graphicsModeControlJ2D = (GraphicsModeControlJ2D)object;
        boolean bl = false;
        if (!Util.isApproximatelyEqual(this.lineWidth, graphicsModeControlJ2D.lineWidth)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.pointSize, graphicsModeControlJ2D.pointSize)) {
            return false;
        }
        if (this.pointMode != graphicsModeControlJ2D.pointMode) {
            return false;
        }
        if (this.textureEnable != graphicsModeControlJ2D.textureEnable) {
            return false;
        }
        if (this.scaleEnable != graphicsModeControlJ2D.scaleEnable) {
            return false;
        }
        if (this.transparencyMode != graphicsModeControlJ2D.transparencyMode) {
            return false;
        }
        if (this.projectionPolicy != graphicsModeControlJ2D.projectionPolicy) {
            return false;
        }
        if (this.polygonMode != graphicsModeControlJ2D.polygonMode) {
            return false;
        }
        if (this.missingTransparent != graphicsModeControlJ2D.missingTransparent) {
            return false;
        }
        return this.curvedSize == graphicsModeControlJ2D.curvedSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("GraphicsModeControlJ3D[");
        stringBuffer.append("lw ");
        stringBuffer.append(this.lineWidth);
        stringBuffer.append(",ps ");
        stringBuffer.append(this.pointSize);
        stringBuffer.append(this.pointMode ? "pm" : "!pm");
        stringBuffer.append(this.textureEnable ? "te" : "!te");
        stringBuffer.append(this.scaleEnable ? "se" : "!se");
        stringBuffer.append(this.missingTransparent ? "mt" : "!mt");
        stringBuffer.append(",tm ");
        stringBuffer.append(this.transparencyMode);
        stringBuffer.append(",pp ");
        stringBuffer.append(this.projectionPolicy);
        stringBuffer.append(",pm ");
        stringBuffer.append(this.polygonMode);
        stringBuffer.append(",cs ");
        stringBuffer.append(this.curvedSize);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public GraphicsModeControlJ2D(DisplayImpl displayImpl) {
        super(displayImpl);
    }
}

