/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AxisScale;
import visad.ColorAlphaControl;
import visad.ColorControl;
import visad.ContourControl;
import visad.Control;
import visad.ControlEvent;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.Flow1Control;
import visad.Flow2Control;
import visad.MouseBehavior;
import visad.RangeControl;
import visad.RealType;
import visad.RendererControl;
import visad.RendererSourceListener;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.TextControl;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGroup;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.VisADSwitch;
import visad.VisADTriangleArray;
import visad.java2d.AnimationControlJ2D;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.KeyboardBehaviorJ2D;
import visad.java2d.MouseBehaviorJ2D;
import visad.java2d.ProjectionControlJ2D;
import visad.java2d.RendererJ2D;
import visad.java2d.ValueControlJ2D;
import visad.java2d.VisADCanvasJ2D;
import visad.util.Util;

public abstract class DisplayRendererJ2D
extends DisplayRenderer
implements RendererSourceListener {
    private VisADCanvasJ2D canvas;
    private VisADGroup root = null;
    private AffineTransform trans = null;
    private VisADGroup direct = null;
    private VisADGroup non_direct = null;
    private MouseBehaviorJ2D mouse = null;
    private VisADAppearance box = null;
    private VisADAppearance cursor = null;
    private AffineTransform cursor_trans = null;
    private VisADSwitch cursor_switch = null;
    private VisADGroup cursor_on = null;
    private VisADGroup cursor_off = null;
    private boolean cursorOn = false;
    private boolean directOn = false;
    private boolean scaleOn = false;
    private VisADSwitch box_switch = null;
    private VisADGroup box_on = null;
    private VisADGroup box_off = null;
    private boolean boxOn = false;
    private VisADSwitch scale_switch = null;
    private VisADGroup scale_on = null;
    private VisADGroup scale_off = null;
    private Vector directs = new Vector();
    private float cursorX;
    private float cursorY;
    private float cursorZ;
    private float line_x;
    private float line_y;
    private float line_z;
    private float point_x;
    private float point_y;
    private float point_z;
    private static /* synthetic */ Class class$Lvisad$java2d$AnimationControlJ2D;
    private static /* synthetic */ Class class$Lvisad$Flow1Control;
    private static /* synthetic */ Class class$Lvisad$Flow2Control;

    public void setDisplay(DisplayImpl displayImpl) throws VisADException {
        super.setDisplay(displayImpl);
        displayImpl.addRendererSourceListener(this);
        this.boxOn = this.getRendererControl().getBoxOn();
    }

    public VisADGroup getRoot() {
        return this.root;
    }

    public void setClip(float f, float f2, float f3, float f4) {
        this.canvas.setClip(f, f2, f3, f4);
    }

    public void unsetClip() {
        this.canvas.unsetClip();
    }

    public void initControl(RendererControl rendererControl) {
        if (this.box != null) {
            try {
                rendererControl.setBoxColor(this.box.red, this.box.green, this.box.blue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.cursor != null) {
            try {
                rendererControl.setBoxColor(this.cursor.red, this.cursor.green, this.cursor.blue);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.canvas != null) {
            float[] fArray = this.canvas.getBackgroundColor();
            try {
                rendererControl.setBackgroundColor(fArray[0], fArray[1], fArray[2]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            rendererControl.setBoxOn(this.boxOn);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private final boolean updateColors(VisADAppearance visADAppearance, float[] fArray) {
        if (visADAppearance == null) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < 3) {
            float f;
            switch (n) {
                case 0: {
                    f = visADAppearance.red;
                    break;
                }
                case 1: {
                    f = visADAppearance.green;
                    break;
                }
                default: {
                    f = visADAppearance.blue;
                    break;
                }
            }
            if (!Util.isApproximatelyEqual(f, fArray[n])) {
                switch (n) {
                    case 0: {
                        visADAppearance.red = fArray[n];
                        break;
                    }
                    case 1: {
                        visADAppearance.green = fArray[n];
                        break;
                    }
                    default: {
                        visADAppearance.blue = fArray[n];
                        break;
                    }
                }
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void controlChanged(ControlEvent controlEvent) throws VisADException, RemoteException {
        boolean bl;
        float[] fArray;
        float[] fArray2;
        RendererControl rendererControl = (RendererControl)controlEvent.getControl();
        float[] fArray3 = rendererControl.getBoxColor();
        if (this.updateColors(this.box, fArray3)) {
            this.getCanvas().scratchImages();
        }
        if (this.updateColors(this.cursor, fArray3 = rendererControl.getCursorColor())) {
            this.render_trigger();
        }
        if (!(Util.isApproximatelyEqual((fArray2 = this.canvas.getBackgroundColor())[0], (fArray = rendererControl.getBackgroundColor())[0]) && Util.isApproximatelyEqual(fArray2[1], fArray[1]) && Util.isApproximatelyEqual(fArray2[2], fArray[2]))) {
            this.canvas.setBackgroundColor(fArray[0], fArray[1], fArray[2]);
            this.canvas.scratchImages();
        }
        if ((bl = rendererControl.getBoxOn()) != this.boxOn) {
            this.boxOn = bl;
            this.box_switch.setWhichChild(this.boxOn ? 1 : 0);
            this.canvas.scratchImages();
        }
    }

    public AffineTransform getTrans() {
        return this.trans;
    }

    public VisADCanvasJ2D getCanvas() {
        return this.canvas;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        while (bufferedImage == null) {
            try {
                DisplayRendererJ2D displayRendererJ2D = this;
                synchronized (displayRendererJ2D) {
                    this.canvas.captureFlag = true;
                    this.canvas.renderTrigger();
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bufferedImage = this.canvas.captureImage;
            this.canvas.captureImage = null;
        }
        return bufferedImage;
    }

    void notifyCapture() {
        DisplayRendererJ2D displayRendererJ2D = this;
        synchronized (displayRendererJ2D) {
            this.notify();
        }
    }

    public VisADGroup getCursorOnBranch() {
        return this.cursor_on;
    }

    public VisADGroup getBoxOnBranch() {
        return this.box_on;
    }

    public void setCursorOn(boolean bl) {
        this.cursorOn = bl;
        if (bl) {
            this.cursor_switch.setWhichChild(1);
            this.setCursorStringVector();
        } else {
            this.cursor_switch.setWhichChild(0);
            this.setCursorStringVector(null);
        }
        this.render_trigger();
    }

    public void setDirectOn(boolean bl) {
        this.directOn = bl;
        if (!bl) {
            this.setCursorStringVector(null);
            this.render_trigger();
        }
    }

    public VisADGroup getDirect() {
        return this.direct;
    }

    public VisADGroup getNonDirect() {
        return this.non_direct;
    }

    public abstract VisADGroup createSceneGraph(VisADCanvasJ2D var1) throws DisplayException;

    public VisADGroup createBasicSceneGraph(VisADCanvasJ2D visADCanvasJ2D, MouseBehaviorJ2D mouseBehaviorJ2D) throws DisplayException {
        VisADAppearance visADAppearance = new VisADAppearance();
        VisADAppearance visADAppearance2 = new VisADAppearance();
        return this.createBasicSceneGraph(visADCanvasJ2D, mouseBehaviorJ2D, visADAppearance, visADAppearance2);
    }

    public VisADGroup createBasicSceneGraph(VisADCanvasJ2D visADCanvasJ2D, MouseBehaviorJ2D mouseBehaviorJ2D, VisADAppearance visADAppearance, VisADAppearance visADAppearance2) throws DisplayException {
        if (this.root != null) {
            return this.root;
        }
        this.mouse = mouseBehaviorJ2D;
        this.canvas = visADCanvasJ2D;
        this.box = visADAppearance;
        this.cursor = visADAppearance2;
        this.canvas.addMouseBehavior(this.mouse);
        this.root = new VisADGroup();
        this.direct = new VisADGroup();
        this.root.addChild(this.direct);
        this.directOn = false;
        this.non_direct = new VisADGroup();
        this.root.addChild(this.non_direct);
        this.canvas.setDirect(this.direct, this.non_direct);
        this.cursor_trans = new AffineTransform();
        this.cursor_switch = new VisADSwitch();
        this.cursor_on = new VisADGroup();
        this.cursor_off = new VisADGroup();
        this.cursor_switch.addChild(this.cursor_off);
        this.cursor_switch.addChild(this.cursor_on);
        this.cursor_switch.setWhichChild(0);
        this.cursorOn = false;
        this.box_switch = new VisADSwitch();
        this.box_on = new VisADGroup();
        this.box_off = new VisADGroup();
        this.box_switch.addChild(this.box_off);
        this.box_switch.addChild(this.box_on);
        this.box_switch.setWhichChild(1);
        this.root.addChild(this.box_switch);
        try {
            this.setBoxOn(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scale_switch = new VisADSwitch();
        this.root.addChild(this.scale_switch);
        this.scale_on = new VisADGroup();
        this.scale_off = new VisADGroup();
        this.scale_switch.addChild(this.scale_off);
        this.scale_switch.addChild(this.scale_on);
        this.scale_switch.setWhichChild(0);
        this.scaleOn = false;
        float[] fArray = this.getRendererControl().getBackgroundColor();
        this.canvas.setBackgroundColor(fArray[0], fArray[1], fArray[2]);
        return this.root;
    }

    public MouseBehavior getMouseBehavior() {
        return this.mouse;
    }

    public void addSceneGraphComponent(VisADGroup visADGroup) throws DisplayException {
        this.non_direct.addChild(visADGroup);
    }

    public void addDirectManipulationSceneGraphComponent(VisADGroup visADGroup, DirectManipulationRendererJ2D directManipulationRendererJ2D) throws DisplayException {
        this.direct.addChild(visADGroup);
        this.directs.addElement(directManipulationRendererJ2D);
    }

    public void clearScene(DataRenderer dataRenderer) {
        this.directs.removeElement(dataRenderer);
    }

    public double[] getCursor() {
        double[] dArray = new double[]{this.cursorX, this.cursorY, this.cursorZ};
        return dArray;
    }

    public void depth_cursor(VisADRay visADRay) {
        this.line_x = (float)visADRay.vector[0];
        this.line_y = (float)visADRay.vector[1];
        this.line_z = (float)visADRay.vector[2];
        this.point_x = this.cursorX;
        this.point_y = this.cursorY;
        this.point_z = this.cursorZ;
    }

    public void drag_depth(float f) {
        this.cursorX = this.point_x + f * this.line_x;
        this.cursorY = this.point_y + f * this.line_y;
        this.cursorZ = this.point_z + f * this.line_z;
        this.setCursorLoc();
    }

    public void drag_cursor(VisADRay visADRay, boolean bl) {
        float f = (float)visADRay.position[0];
        float f2 = (float)visADRay.position[1];
        float f3 = (float)visADRay.position[2];
        float f4 = (float)visADRay.vector[0];
        float f5 = (float)visADRay.vector[1];
        float f6 = (float)visADRay.vector[2];
        if (bl) {
            this.line_x = f4;
            this.line_y = f5;
            this.line_z = f6;
        }
        float f7 = (this.cursorX - f) * this.line_x + (this.cursorY - f2) * this.line_y + (this.cursorZ - f3) * this.line_z;
        float f8 = f4 * this.line_x + f5 * this.line_y + f6 * this.line_z;
        if ((double)f8 == 0.0) {
            return;
        }
        this.cursorX = f + (f7 /= f8) * f4;
        this.cursorY = f2 + f7 * f5;
        this.cursorZ = f3 + f7 * f6;
        this.setCursorLoc();
    }

    private void setCursorLoc() {
        this.cursor_trans.setToTranslation(this.cursorX, this.cursorY);
        if (this.cursorOn) {
            this.setCursorStringVector();
        } else {
            this.render_trigger();
        }
    }

    public void render_trigger() {
        this.canvas.renderTrigger();
    }

    public boolean anyCursorStringVector() {
        Object object;
        Object object2;
        if (this.cursorOn) {
            return true;
        }
        Enumeration enumeration = ((Vector)this.directs.clone()).elements();
        while (enumeration.hasMoreElements()) {
            object2 = (DirectManipulationRendererJ2D)enumeration.nextElement();
            object = ((DirectManipulationRendererJ2D)object2).getExtraBranch();
            if (object == null) continue;
            return true;
        }
        if ((this.cursorOn || this.directOn) && !this.getCursorStringVector().isEmpty()) {
            return true;
        }
        object2 = this.getDisplay().getRendererVector();
        enumeration = ((Vector)object2).elements();
        while (enumeration.hasMoreElements()) {
            object = (DataRenderer)enumeration.nextElement();
            if (((DataRenderer)object).getExceptionVector().isEmpty()) continue;
            return true;
        }
        return this.getWaitFlag();
    }

    public void drawCursorStringVector(Graphics graphics, AffineTransform affineTransform, int n, int n2) {
        Object object;
        Object object2;
        Object object3;
        Enumeration enumeration;
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        if (this.cursorOn) {
            affineTransform2.concatenate(this.cursor_trans);
            enumeration = (VisADAppearance)this.cursor_on.getChild(0);
            if (enumeration != null) {
                VisADCanvasJ2D.drawAppearance(graphics, (VisADAppearance)((Object)enumeration), affineTransform2, null);
            }
            affineTransform2 = new AffineTransform(affineTransform);
        }
        enumeration = ((Vector)this.directs.clone()).elements();
        while (enumeration.hasMoreElements()) {
            object3 = (DirectManipulationRendererJ2D)enumeration.nextElement();
            VisADGroup visADGroup = object3.getExtraBranch();
            if (visADGroup == null) continue;
            Vector vector = visADGroup.getChildren();
            object2 = vector.elements();
            while (object2.hasMoreElements()) {
                object = (VisADAppearance)object2.nextElement();
                VisADCanvasJ2D.drawAppearance(graphics, (VisADAppearance)object, affineTransform2, null);
            }
        }
        try {
            object3 = this.getCursorColor();
        }
        catch (Exception exception) {
            System.err.println("Yikes!  Couldn't get cursor color");
            object3 = new float[]{1.0f, 1.0f, 1.0f};
        }
        graphics.setColor(new Color((float)object3[0], (float)object3[1], (float)object3[2]));
        graphics.setFont(new Font("Times New Roman", 0, 10));
        int n3 = 1;
        int n4 = 10;
        if (this.cursorOn || this.directOn) {
            object2 = this.getCursorStringVector().elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                graphics.drawString((String)object, n3, n4);
                n4 += 12;
            }
        }
        n3 = 1;
        n4 = n2 - 2;
        object2 = this.getDisplay().getRendererVector();
        enumeration = ((Vector)object2).elements();
        while (enumeration.hasMoreElements()) {
            object = (DataRenderer)enumeration.nextElement();
            Vector vector = ((DataRenderer)object).getExceptionVector();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Exception exception = (Exception)enumeration2.nextElement();
                String string = exception.getMessage();
                graphics.drawString(string, n3, n4);
                n4 -= 12;
            }
        }
        if (this.getWaitFlag()) {
            graphics.drawString("please wait . . .", n3, n4);
            n4 -= 12;
        }
    }

    public DataRenderer findDirect(VisADRay visADRay, int n) {
        DirectManipulationRendererJ2D directManipulationRendererJ2D = null;
        float f = Float.MAX_VALUE;
        Enumeration enumeration = ((Vector)this.directs.clone()).elements();
        while (enumeration.hasMoreElements()) {
            DirectManipulationRendererJ2D directManipulationRendererJ2D2 = (DirectManipulationRendererJ2D)enumeration.nextElement();
            if (!directManipulationRendererJ2D2.getEnabled()) continue;
            directManipulationRendererJ2D2.setLastMouseModifiers(n);
            float f2 = directManipulationRendererJ2D2.checkClose(visADRay.position, visADRay.vector);
            if (!(f2 < f)) continue;
            f = f2;
            directManipulationRendererJ2D = directManipulationRendererJ2D2;
        }
        if (f < this.getPickThreshhold()) {
            return directManipulationRendererJ2D;
        }
        return null;
    }

    public boolean anyDirects() {
        return !this.directs.isEmpty();
    }

    public void setScaleOn(boolean bl) {
        boolean bl2 = this.scaleOn;
        this.scaleOn = bl;
        if (bl) {
            this.scale_switch.setWhichChild(1);
        } else {
            this.scale_switch.setWhichChild(0);
        }
        if (this.scaleOn != bl2) {
            this.canvas.scratchImages();
        }
    }

    public void setScale(AxisScale axisScale) throws VisADException {
        this.setScale(axisScale.getAxis(), axisScale.getAxisOrdinal(), axisScale.getScaleArray(), axisScale.getLabelArray(), axisScale.getColor().getColorComponents(null));
    }

    public void setScale(int n, int n2, VisADLineArray visADLineArray, float[] fArray) throws VisADException {
        this.setScale(n, n2, visADLineArray, null, fArray);
    }

    public void setScale(int n, int n2, VisADLineArray visADLineArray, VisADTriangleArray visADTriangleArray, float[] fArray) throws VisADException {
        VisADAppearance visADAppearance = new VisADAppearance();
        visADAppearance.red = fArray[0];
        visADAppearance.green = fArray[1];
        visADAppearance.blue = fArray[2];
        visADAppearance.color_flag = true;
        visADAppearance.array = visADLineArray;
        VisADGroup visADGroup = new VisADGroup();
        visADGroup.addChild(visADAppearance);
        if (visADTriangleArray != null) {
            VisADAppearance visADAppearance2 = new VisADAppearance();
            visADAppearance2.red = fArray[0];
            visADAppearance2.green = fArray[1];
            visADAppearance2.blue = fArray[2];
            visADAppearance2.color_flag = true;
            visADAppearance2.array = visADTriangleArray;
            visADGroup.addChild(visADAppearance2);
        }
        int n3 = this.getMode2D() ? 2 : 3;
        VisADGroup visADGroup2 = this.scale_on;
        synchronized (visADGroup2) {
            int n4 = this.scale_on.numChildren();
            int n5 = n3 * n2 + n;
            if (n5 >= n4) {
                int n6 = n4;
                while (n6 <= n5) {
                    VisADGroup visADGroup3 = new VisADGroup();
                    this.scale_on.addChild(visADGroup3);
                    ++n6;
                }
            }
            this.scale_on.setChild(visADGroup, n5);
        }
        this.canvas.scratchImages();
    }

    public void clearScales() {
        if (this.scale_on != null) {
            VisADGroup visADGroup = this.scale_on;
            synchronized (visADGroup) {
                int n = this.scale_on.numChildren();
                int n2 = n - 1;
                while (n2 >= 0) {
                    this.scale_on.removeChild(n2);
                    --n2;
                }
            }
        }
    }

    public void clearScale(AxisScale axisScale) {
        int n = axisScale.getAxis();
        int n2 = axisScale.getAxisOrdinal();
        int n3 = this.getMode2D() ? 2 : 3;
        try {
            VisADGroup visADGroup = this.scale_on;
            synchronized (visADGroup) {
                int n4 = this.scale_on.numChildren();
                int n5 = n3 * n2 + n;
                if (n5 >= n4) {
                    int n6 = n4;
                    while (n6 <= n5) {
                        VisADGroup visADGroup2 = new VisADGroup();
                        this.scale_on.addChild(visADGroup2);
                        ++n6;
                    }
                }
                VisADGroup visADGroup3 = new VisADGroup();
                this.scale_on.setChild(visADGroup3, n5);
                this.canvas.scratchImages();
            }
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }

    public void setTransform2D(AffineTransform affineTransform) {
        this.trans = new AffineTransform(affineTransform);
    }

    public Control makeControl(ScalarMap scalarMap) {
        DisplayRealType displayRealType = scalarMap.getDisplayScalar();
        DisplayImplJ2D displayImplJ2D = (DisplayImplJ2D)this.getDisplay();
        if (displayRealType == null) {
            return null;
        }
        if (displayRealType.equals(Display.XAxis) || displayRealType.equals(Display.YAxis) || displayRealType.equals(Display.ZAxis) || displayRealType.equals(Display.Latitude) || displayRealType.equals(Display.Longitude) || displayRealType.equals(Display.Radius)) {
            return (ProjectionControlJ2D)displayImplJ2D.getProjectionControl();
        }
        if (displayRealType.equals(Display.RGB) || displayRealType.equals(Display.HSV) || displayRealType.equals(Display.CMY)) {
            return new ColorControl(displayImplJ2D);
        }
        if (displayRealType.equals(Display.RGBA)) {
            return new ColorAlphaControl(displayImplJ2D);
        }
        if (displayRealType.equals(Display.Animation)) {
            Control control = displayImplJ2D.getControl(class$Lvisad$java2d$AnimationControlJ2D != null ? class$Lvisad$java2d$AnimationControlJ2D : (class$Lvisad$java2d$AnimationControlJ2D = DisplayRendererJ2D.class$("visad.java2d.AnimationControlJ2D")));
            if (control != null) {
                return control;
            }
            return new AnimationControlJ2D(displayImplJ2D, (RealType)scalarMap.getScalar());
        }
        if (displayRealType.equals(Display.SelectValue)) {
            return new ValueControlJ2D(displayImplJ2D);
        }
        if (displayRealType.equals(Display.SelectRange)) {
            return new RangeControl(displayImplJ2D);
        }
        if (displayRealType.equals(Display.IsoContour)) {
            return new ContourControl(displayImplJ2D);
        }
        if (displayRealType.equals(Display.Flow1X) || displayRealType.equals(Display.Flow1Y) || displayRealType.equals(Display.Flow1Z) || displayRealType.equals(Display.Flow1Elevation) || displayRealType.equals(Display.Flow1Azimuth) || displayRealType.equals(Display.Flow1Radial)) {
            Control control = displayImplJ2D.getControl(class$Lvisad$Flow1Control != null ? class$Lvisad$Flow1Control : (class$Lvisad$Flow1Control = DisplayRendererJ2D.class$("visad.Flow1Control")));
            if (control != null) {
                return control;
            }
            return new Flow1Control(displayImplJ2D);
        }
        if (displayRealType.equals(Display.Flow2X) || displayRealType.equals(Display.Flow2Y) || displayRealType.equals(Display.Flow2Z) || displayRealType.equals(Display.Flow2Elevation) || displayRealType.equals(Display.Flow2Azimuth) || displayRealType.equals(Display.Flow2Radial)) {
            Control control = displayImplJ2D.getControl(class$Lvisad$Flow2Control != null ? class$Lvisad$Flow2Control : (class$Lvisad$Flow2Control = DisplayRendererJ2D.class$("visad.Flow2Control")));
            if (control != null) {
                return control;
            }
            return new Flow2Control(displayImplJ2D);
        }
        if (displayRealType.equals(Display.Shape)) {
            return new ShapeControl(displayImplJ2D);
        }
        if (displayRealType.equals(Display.Text)) {
            return new TextControl(displayImplJ2D);
        }
        return null;
    }

    public DataRenderer makeDefaultRenderer() {
        return new DefaultRendererJ2D();
    }

    public boolean legalDataRenderer(DataRenderer dataRenderer) {
        return dataRenderer instanceof RendererJ2D;
    }

    public void rendererDeleted(DataRenderer dataRenderer) {
        this.clearScene(dataRenderer);
    }

    public void addKeyboardBehavior(KeyboardBehaviorJ2D keyboardBehaviorJ2D) {
        this.getCanvas().addKeyboardBehavior(keyboardBehaviorJ2D);
    }

    public void setWaitFlag(boolean bl) {
        boolean bl2 = this.getWaitFlag();
        super.setWaitFlag(bl);
        if (bl != bl2 && this.canvas != null) {
            this.canvas.renderTrigger();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

