/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.GraphicsModeControl;
import visad.ProjectionControl;
import visad.RemoteDisplay;
import visad.VisADException;
import visad.VisADGroup;
import visad.java2d.DefaultDisplayRendererJ2D;
import visad.java2d.DisplayPanelJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.GraphicsModeControlJ2D;
import visad.java2d.ProjectionControlJ2D;
import visad.java2d.VisADCanvasJ2D;

public class DisplayImplJ2D
extends DisplayImpl {
    public static final int UNKNOWN = 0;
    public static final int JPANEL = 1;
    public static final int OFFSCREEN = 2;
    private ProjectionControlJ2D projection = null;
    private GraphicsModeControlJ2D mode = null;
    private int apiValue = 0;
    private boolean scratch;

    private void initialize(int n, int n2, int n3) throws VisADException {
        this.mode = new GraphicsModeControlJ2D(this);
        this.addControl(this.mode);
        this.projection = new ProjectionControlJ2D(this);
        this.addControl(this.projection);
        if (n == 1) {
            DisplayPanelJ2D displayPanelJ2D = new DisplayPanelJ2D(this);
            this.setComponent(displayPanelJ2D);
            this.apiValue = 1;
        } else if (n == 2) {
            Object var4_5 = null;
            DisplayRendererJ2D displayRendererJ2D = (DisplayRendererJ2D)this.getDisplayRenderer();
            VisADCanvasJ2D visADCanvasJ2D = new VisADCanvasJ2D(displayRendererJ2D, n2, n3);
            VisADGroup visADGroup = displayRendererJ2D.createSceneGraph(visADCanvasJ2D);
            this.apiValue = 2;
        } else {
            throw new DisplayException("DisplayImplJ2D: bad graphics API");
        }
    }

    protected DisplayRenderer getDefaultDisplayRenderer() {
        return new DefaultDisplayRendererJ2D();
    }

    public ProjectionControl getProjectionControl() {
        return this.projection;
    }

    public GraphicsModeControl getGraphicsModeControl() {
        return this.mode;
    }

    public int getAPI() throws VisADException {
        return this.apiValue;
    }

    public void setScratch() {
        this.scratch = true;
    }

    public void clearMaps() throws VisADException, RemoteException {
        super.clearMaps();
        DisplayRendererJ2D displayRendererJ2D = (DisplayRendererJ2D)this.getDisplayRenderer();
        VisADCanvasJ2D visADCanvasJ2D = displayRendererJ2D.getCanvas();
        if (visADCanvasJ2D != null) {
            visADCanvasJ2D.scratchImages();
        }
    }

    public void doAction() throws VisADException, RemoteException {
        this.scratch = false;
        super.doAction();
        if (this.scratch) {
            VisADCanvasJ2D visADCanvasJ2D = ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas();
            visADCanvasJ2D.scratchImages();
        }
    }

    public boolean getAutoAspect() {
        DisplayRendererJ2D displayRendererJ2D = (DisplayRendererJ2D)this.getDisplayRenderer();
        VisADCanvasJ2D visADCanvasJ2D = displayRendererJ2D.getCanvas();
        return visADCanvasJ2D.getAutoAspect();
    }

    public void setAutoAspect(boolean bl) {
        DisplayRendererJ2D displayRendererJ2D = (DisplayRendererJ2D)this.getDisplayRenderer();
        VisADCanvasJ2D visADCanvasJ2D = displayRendererJ2D.getCanvas();
        visADCanvasJ2D.setAutoAspect(bl);
    }

    public void destroy() throws VisADException, RemoteException {
        ((DisplayRendererJ2D)this.getDisplayRenderer()).getCanvas().stop();
        super.destroy();
    }

    public DisplayImplJ2D(RemoteDisplay remoteDisplay) throws VisADException, RemoteException {
        this(remoteDisplay, null);
    }

    public DisplayImplJ2D(RemoteDisplay remoteDisplay, DisplayRendererJ2D displayRendererJ2D) throws VisADException, RemoteException {
        super(remoteDisplay, (DisplayRenderer)displayRendererJ2D);
        this.initialize(remoteDisplay.getDisplayAPI(), 300, 300);
        this.syncRemoteData(remoteDisplay);
    }

    public DisplayImplJ2D(String string) throws VisADException, RemoteException {
        this(string, null, 1);
    }

    public DisplayImplJ2D(String string, DisplayRendererJ2D displayRendererJ2D) throws VisADException, RemoteException {
        this(string, displayRendererJ2D, 1);
    }

    public DisplayImplJ2D(String string, int n) throws VisADException, RemoteException {
        this(string, null, n);
    }

    public DisplayImplJ2D(String string, DisplayRendererJ2D displayRendererJ2D, int n) throws VisADException, RemoteException {
        this(string, displayRendererJ2D, n, 300, 300);
    }

    public DisplayImplJ2D(String string, int n, int n2) throws VisADException, RemoteException {
        this(string, null, 2, n, n2);
    }

    public DisplayImplJ2D(String string, DisplayRendererJ2D displayRendererJ2D, int n, int n2) throws VisADException, RemoteException {
        this(string, displayRendererJ2D, 2, n, n2);
    }

    public DisplayImplJ2D(String string, DisplayRendererJ2D displayRendererJ2D, int n, int n2, int n3) throws VisADException, RemoteException {
        super(string, (DisplayRenderer)displayRendererJ2D);
        this.initialize(n, n2, n3);
    }
}

