/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.BadDirectManipulationException;
import visad.Data;
import visad.DataDisplayLink;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADAppearance;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADGroup;
import visad.VisADLineArray;
import visad.VisADPointArray;
import visad.collab.CollabUtil;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.RendererJ2D;
import visad.java2d.ShadowTypeJ2D;

public class DirectManipulationRendererJ2D
extends RendererJ2D {
    VisADGroup branch = null;
    VisADGroup extra_branch = null;

    public void setLinks(DataDisplayLink[] dataDisplayLinkArray, DisplayImpl displayImpl) throws VisADException {
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length != 1) {
            throw new DisplayException("DirectManipulationRendererJ2D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(dataDisplayLinkArray, displayImpl);
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.realCheckDirect();
    }

    public void addPoint(float[] fArray) throws VisADException {
        int n = fArray.length / 3;
        VisADGeometryArray visADGeometryArray = null;
        if (n == 1) {
            visADGeometryArray = new VisADPointArray();
        } else if (n == 2) {
            visADGeometryArray = new VisADLineArray();
        } else {
            return;
        }
        visADGeometryArray.coordinates = fArray;
        visADGeometryArray.vertexCount = n;
        VisADAppearance visADAppearance = new VisADAppearance();
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            return;
        }
        DataDisplayLink dataDisplayLink = dataDisplayLinkArray[0];
        float[] fArray2 = dataDisplayLink.getDefaultValues();
        DisplayImpl displayImpl = this.getDisplay();
        visADAppearance.pointSize = fArray2[displayImpl.getDisplayScalarIndex(Display.PointSize)];
        visADAppearance.lineWidth = fArray2[displayImpl.getDisplayScalarIndex(Display.LineWidth)];
        visADAppearance.red = 1.0f;
        visADAppearance.green = 1.0f;
        visADAppearance.blue = 1.0f;
        visADAppearance.array = visADGeometryArray;
        this.extra_branch.addChild(visADAppearance);
    }

    public VisADGroup getExtraBranch() {
        return this.extra_branch;
    }

    public synchronized VisADGroup doTransform() throws VisADException, RemoteException {
        Data data;
        this.branch = new VisADGroup();
        this.extra_branch = new VisADGroup();
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            return null;
        }
        DataDisplayLink dataDisplayLink = dataDisplayLinkArray[0];
        ShadowTypeJ2D shadowTypeJ2D = (ShadowTypeJ2D)dataDisplayLink.getShadow();
        if (!this.getIsDirectManipulation()) {
            throw new BadDirectManipulationException(this.getWhyNotDirect() + ": DirectManipulationRendererJ2D.doTransform");
        }
        int n = this.getDisplay().getValueArrayLength();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.NaN;
            ++n2;
        }
        try {
            data = dataDisplayLink.getData();
        }
        catch (RemoteException remoteException) {
            if (CollabUtil.isDisconnectException(remoteException)) {
                this.getDisplay().connectionFailed(this, dataDisplayLink);
                this.removeLink(dataDisplayLink);
                return null;
            }
            throw remoteException;
        }
        if (data == null) {
            this.branch = null;
            this.extra_branch = null;
            this.addException(new DisplayException("Data is null: DirectManipulationRendererJ2D.doTransform"));
        } else {
            try {
                shadowTypeJ2D.doTransform(this.branch, data, fArray, dataDisplayLink.getDefaultValues(), this);
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, dataDisplayLink);
                    this.removeLink(dataDisplayLink);
                    return null;
                }
                throw remoteException;
            }
        }
        return this.branch;
    }

    void addSwitch(DisplayRendererJ2D displayRendererJ2D, VisADGroup visADGroup) throws VisADException {
        displayRendererJ2D.addDirectManipulationSceneGraphComponent(visADGroup, this);
    }

    public boolean isLegalTextureMap() {
        return false;
    }
}

