/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import visad.Data;
import visad.DataDisplayLink;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADException;
import visad.VisADGroup;
import visad.collab.CollabUtil;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.RendererJ2D;
import visad.java2d.ShadowTypeJ2D;

public class DefaultRendererJ2D
extends RendererJ2D {
    DataDisplayLink link;

    public void setLinks(DataDisplayLink[] dataDisplayLinkArray, DisplayImpl displayImpl) throws VisADException {
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length != 1) {
            throw new DisplayException("DefaultRendererJ2D.setLinks: must be exactly one DataDisplayLink");
        }
        super.setLinks(dataDisplayLinkArray, displayImpl);
    }

    public VisADGroup doTransform() throws VisADException, RemoteException {
        Data data;
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            this.link = null;
            return null;
        }
        this.link = dataDisplayLinkArray[0];
        ShadowTypeJ2D shadowTypeJ2D = (ShadowTypeJ2D)this.link.getShadow();
        VisADGroup visADGroup = new VisADGroup();
        int n = this.getDisplay().getValueArrayLength();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = Float.NaN;
            ++n2;
        }
        try {
            data = this.link.getData();
        }
        catch (RemoteException remoteException) {
            if (CollabUtil.isDisconnectException(remoteException)) {
                this.getDisplay().connectionFailed(this, this.link);
                this.removeLink(this.link);
                return null;
            }
            throw remoteException;
        }
        if (data == null) {
            visADGroup = null;
            this.addException(new DisplayException("Data is null: DefaultRendererJ2D.doTransform"));
        } else {
            boolean bl;
            this.link.start_time = System.currentTimeMillis();
            this.link.time_flag = false;
            shadowTypeJ2D.preProcess();
            try {
                bl = shadowTypeJ2D.doTransform(visADGroup, data, fArray, this.link.getDefaultValues(), this);
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return null;
                }
                throw remoteException;
            }
            if (bl) {
                shadowTypeJ2D.postProcess(visADGroup);
            }
        }
        this.link.clearData();
        return visADGroup;
    }

    void addSwitch(DisplayRendererJ2D displayRendererJ2D, VisADGroup visADGroup) throws VisADException {
        displayRendererJ2D.addSceneGraphComponent(visADGroup);
    }

    public DataDisplayLink getLink() {
        return this.link;
    }
}

