/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.AnimationControl;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayException;
import visad.RealType;
import visad.Set;
import visad.ToggleControl;
import visad.VisADError;
import visad.VisADException;
import visad.browser.Convert;
import visad.java2d.AVControlJ2D;
import visad.java2d.AnimationSetControlJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.java2d.VisADCanvasJ2D;
import visad.util.Delay;

public class AnimationControlJ2D
extends AVControlJ2D
implements Runnable,
AnimationControl {
    private int current = 0;
    private boolean direction;
    private long step;
    private long[] stepValues = new long[]{500L};
    private transient AnimationSetControlJ2D animationSet;
    private ToggleControl animate;
    private RealType real;
    private boolean no_tick = false;
    private transient VisADCanvasJ2D canvas;
    private transient Thread animationThread;

    public void nullControl() {
        this.stop();
        super.nullControl();
    }

    public void stop() {
        this.animationThread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.animationThread == thread) {
            try {
                if (this.animate != null && this.animate.getOn() && !this.no_tick) {
                    this.takeStep();
                }
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
                throw new VisADError("AnimationControlJ2D.run: " + visADException.toString());
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                throw new VisADError("AnimationControlJ2D.run: " + remoteException.toString());
            }
            try {
                AnimationControlJ2D animationControlJ2D = this;
                synchronized (animationControlJ2D) {
                    if (this.current >= 0 && this.current < this.stepValues.length) {
                        this.wait(this.stepValues[this.current]);
                    } else {
                        this.wait(500L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void setNoTick(boolean bl) {
        this.no_tick = bl;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int n) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(n);
            this.canvas.renderTrigger();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    public void setCurrent(double d) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            this.current = this.animationSet.getIndex(d);
            this.canvas.renderTrigger();
        } else {
            this.current = 0;
        }
        this.changeControl(false);
    }

    public void setDirection(boolean bl) throws VisADException, RemoteException {
        this.direction = bl;
        this.changeControl(false);
    }

    public boolean getDirection() {
        return this.direction;
    }

    public long getStep() {
        if (this.stepValues == null || this.current < 0 || this.stepValues.length <= this.current) {
            return 500L;
        }
        return this.stepValues[this.current];
    }

    public long[] getSteps() {
        return this.stepValues;
    }

    public void setStep(int n) throws VisADException, RemoteException {
        if (n <= 0) {
            throw new DisplayException("AnimationControlJ2D.setStep: step must be > 0");
        }
        this.step = n;
        int n2 = 0;
        while (n2 < this.stepValues.length) {
            this.stepValues[n2] = this.step;
            ++n2;
        }
        this.changeControl(false);
    }

    public void setSteps(int[] nArray) throws VisADException, RemoteException {
        int n = 0;
        while (n < this.stepValues.length) {
            this.stepValues[n] = n < nArray.length ? nArray[n] : nArray[nArray.length - 1];
            if (this.stepValues[n] <= 0L) {
                throw new DisplayException("AnimationControlJ2D.setSteps: step " + n + " must be > 0");
            }
            ++n;
        }
        this.changeControl(false);
    }

    public void takeStep() throws VisADException, RemoteException {
        this.current = this.direction ? ++this.current : --this.current;
        if (this.animationSet != null) {
            this.current = this.animationSet.clipCurrent(this.current);
            this.canvas.renderTrigger();
        }
        this.changeControl(false);
    }

    public void init() throws VisADException {
        if (this.animationSet != null && this.animationSet.getSet() != null) {
            double d = this.animationSet.getValue(this.current);
            Set set = this.animationSet.getSet();
            this.animation_string(this.real, set, d, this.current);
            this.selectSwitches(d, set);
        }
    }

    public Set getSet() {
        if (this.animationSet != null) {
            return this.animationSet.getSet();
        }
        return null;
    }

    public void setSet(Set set) throws VisADException, RemoteException {
        this.setSet(set, false);
        if (set.getLength() != this.stepValues.length) {
            this.stepValues = new long[set.getLength()];
            int n = 0;
            while (n < this.stepValues.length) {
                this.stepValues[n] = this.step;
                ++n;
            }
        }
    }

    public void setSet(Set set, boolean bl) throws VisADException, RemoteException {
        if (this.animationSet != null) {
            if (set.getLength() != this.stepValues.length) {
                this.stepValues = new long[set.getLength()];
                int n = 0;
                while (n < this.stepValues.length) {
                    this.stepValues[n] = this.step;
                    ++n;
                }
            }
            this.animationSet.setSet(set, bl);
        }
    }

    public boolean getOn() {
        if (this.animate != null) {
            return this.animate.getOn();
        }
        return false;
    }

    public void setOn(boolean bl) throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(bl);
        }
    }

    public void toggle() throws VisADException, RemoteException {
        if (this.animate != null) {
            this.animate.setOn(!this.animate.getOn());
        }
    }

    public void subSetTicks() {
        if (this.animationSet != null) {
            this.animationSet.setTicks();
        }
        if (this.animate != null) {
            this.animate.setTicks();
        }
    }

    public boolean subCheckTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        boolean bl = false;
        if (this.animationSet != null) {
            bl |= this.animationSet.checkTicks(dataRenderer, dataDisplayLink);
        }
        if (this.animate != null) {
            bl |= this.animate.checkTicks(dataRenderer, dataDisplayLink);
        }
        return bl;
    }

    public boolean subPeekTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        boolean bl = false;
        if (this.animationSet != null) {
            bl |= this.animationSet.peekTicks(dataRenderer, dataDisplayLink);
        }
        if (this.animate != null) {
            bl |= this.animate.peekTicks(dataRenderer, dataDisplayLink);
        }
        return bl;
    }

    public void subResetTicks() {
        if (this.animationSet != null) {
            this.animationSet.resetTicks();
        }
        if (this.animate != null) {
            this.animate.resetTicks();
        }
    }

    public String getSaveString() {
        long[] lArray;
        int n;
        if (this.stepValues == null) {
            n = 1;
            lArray = new long[]{500L};
        } else {
            n = this.stepValues.length;
            lArray = this.stepValues;
        }
        StringBuffer stringBuffer = new StringBuffer(35 + 12 * n);
        stringBuffer.append(this.animate != null && this.animate.getOn());
        stringBuffer.append(' ');
        stringBuffer.append(this.direction);
        stringBuffer.append(' ');
        stringBuffer.append(this.current);
        stringBuffer.append(' ');
        stringBuffer.append(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            stringBuffer.append((int)lArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 4) {
            throw new VisADException("Invalid save string");
        }
        boolean bl = Convert.getBoolean(stringTokenizer.nextToken());
        boolean bl2 = Convert.getBoolean(stringTokenizer.nextToken());
        int n2 = Convert.getInt(stringTokenizer.nextToken());
        int n3 = Convert.getInt(stringTokenizer.nextToken());
        if (n3 <= 0) {
            throw new VisADException("Number of steps is not positive");
        }
        if (n < 4 + n3) {
            throw new VisADException("Not enough step entries");
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = Convert.getInt(stringTokenizer.nextToken());
            if (nArray[n4] <= 0) {
                throw new VisADException("Step #" + (n4 + 1) + "is not positive");
            }
            ++n4;
        }
        this.setOn(bl);
        this.setDirection(bl2);
        this.setSteps(nArray);
        this.setCurrent(n2);
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof AnimationControlJ2D)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        AnimationControlJ2D animationControlJ2D = (AnimationControlJ2D)control;
        boolean bl = false;
        if (this.direction != animationControlJ2D.direction) {
            bl = true;
            this.direction = animationControlJ2D.direction;
        }
        if (this.animate != animationControlJ2D.animate) {
            bl = true;
            this.animate = animationControlJ2D.animate;
        }
        if (this.real != animationControlJ2D.real) {
            bl = true;
            this.real = animationControlJ2D.real;
        }
        if (this.no_tick != animationControlJ2D.no_tick) {
            bl = true;
            this.no_tick = animationControlJ2D.no_tick;
        }
        if (bl) {
            try {
                this.changeControl(false);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AnimationControlJ2D animationControlJ2D = (AnimationControlJ2D)object;
        if (this.direction != animationControlJ2D.direction) {
            return false;
        }
        if (this.animate != animationControlJ2D.animate) {
            return false;
        }
        if (this.real != animationControlJ2D.real) {
            return false;
        }
        return this.no_tick == animationControlJ2D.no_tick;
    }

    public AnimationControlJ2D(DisplayImplJ2D displayImplJ2D, RealType realType) {
        super(displayImplJ2D);
        this.real = realType;
        this.current = 0;
        this.direction = true;
        this.step = 500L;
        this.stepValues = new long[]{this.step};
        if (displayImplJ2D != null) {
            this.canvas = ((DisplayRendererJ2D)displayImplJ2D.getDisplayRenderer()).getCanvas();
            this.animationSet = new AnimationSetControlJ2D(displayImplJ2D, this);
            displayImplJ2D.addControl(this.animationSet);
            this.animate = new ToggleControl(displayImplJ2D, this);
            displayImplJ2D.addControl(this.animate);
            try {
                this.animate.setOn(false);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            new Delay();
            try {
                Set set = this.animationSet.getSet();
                if (set != null) {
                    this.stepValues = new long[set.getLength()];
                }
            }
            catch (VisADException visADException) {
                // empty catch block
            }
            int n = 0;
            while (n < this.stepValues.length) {
                this.stepValues[n] = this.step;
                ++n;
            }
            this.animationThread = new Thread(this);
            this.animationThread.start();
        }
    }
}

