/*
 * Decompiled with CFR 0.152.
 */
package visad.java2d;

import java.util.Enumeration;
import java.util.Vector;
import visad.AVControl;
import visad.Control;
import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.RealTupleType;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.VisADSwitch;
import visad.java2d.DisplayImplJ2D;

public abstract class AVControlJ2D
extends Control
implements AVControl {
    transient Vector switches = new Vector();

    public AVControlJ2D(DisplayImplJ2D displayImplJ2D) {
        super(displayImplJ2D);
    }

    void addPair(VisADSwitch visADSwitch, Set set, DataRenderer dataRenderer) {
        this.switches.addElement(new SwitchSet(visADSwitch, set, dataRenderer));
    }

    public void clearSwitches(DataRenderer dataRenderer) {
        Enumeration enumeration = ((Vector)this.switches.clone()).elements();
        while (enumeration.hasMoreElements()) {
            SwitchSet switchSet = (SwitchSet)enumeration.nextElement();
            if (!switchSet.renderer.equals(dataRenderer)) continue;
            this.switches.removeElement(switchSet);
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AVControlJ2D aVControlJ2D = (AVControlJ2D)object;
        if (this.switches == null) {
            return aVControlJ2D.switches == null;
        }
        if (aVControlJ2D.switches != null) {
            if (this.switches.size() != aVControlJ2D.switches.size()) {
                return false;
            }
            int n = this.switches.size() - 1;
            while (n > 0) {
                if (!this.switches.elementAt(n).equals(aVControlJ2D.switches.elementAt(n))) {
                    return false;
                }
                --n;
            }
        }
        return true;
    }

    abstract void init() throws VisADException;

    public void selectSwitches(double d, Set set) throws VisADException {
        if (d != d) {
            return;
        }
        double[][] dArray = new double[1][1];
        dArray[0][0] = d;
        Enumeration enumeration = ((Vector)this.switches.clone()).elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            SwitchSet switchSet = (SwitchSet)enumeration.nextElement();
            Set set2 = switchSet.set;
            double[][] dArray2 = null;
            RealTupleType realTupleType = ((SetType)set2.getType()).getDomain();
            if (set != null) {
                object = ((SetType)set.getType()).getDomain();
                dArray2 = CoordinateSystem.transformCoordinates(realTupleType, set2.getCoordinateSystem(), set2.getSetUnits(), null, (RealTupleType)object, set.getCoordinateSystem(), set.getSetUnits(), null, dArray);
            } else {
                dArray2 = CoordinateSystem.transformCoordinates(realTupleType, set2.getCoordinateSystem(), set2.getSetUnits(), null, realTupleType, realTupleType.getCoordinateSystem(), realTupleType.getDefaultUnits(), null, dArray);
            }
            object = set2.getLength() == 1 ? (Object)new int[1] : (Object)set2.doubleToIndex(dArray2);
            switchSet.swit.setWhichChild((int)object[0]);
        }
    }

    private class SwitchSet {
        VisADSwitch swit;
        Set set;
        DataRenderer renderer;

        SwitchSet(VisADSwitch visADSwitch, Set set, DataRenderer dataRenderer) {
            this.swit = visADSwitch;
            this.set = set;
            this.renderer = dataRenderer;
        }
    }
}

