/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import visad.install.ProgressMonitor;

public class Util {
    public static final boolean copyDirectory(File file, File file2) {
        return Util.copyDirectory(null, file, file2, null);
    }

    public static final boolean copyDirectory(File file, File file2, String string) {
        return Util.copyDirectory(null, file, file2, string);
    }

    public static final boolean copyDirectory(ProgressMonitor progressMonitor, File file, File file2) {
        return Util.copyDirectory(progressMonitor, file, file2, null);
    }

    public static final boolean copyDirectory(ProgressMonitor progressMonitor, File file, File file2, String string) {
        if (!file.isDirectory() || file2.exists() && !file2.isDirectory()) {
            return false;
        }
        if (Util.getPath(file).equals(Util.getPath(file2))) {
            return false;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        boolean bl = true;
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            File file3 = new File(file, stringArray[n]);
            File file4 = new File(file2, stringArray[n]);
            bl = file3.isDirectory() ? (bl |= Util.copyDirectory(progressMonitor, file3, file4, string)) : (bl |= Util.copyFile(progressMonitor, file3, file4, string));
            ++n;
        }
        if (!file.canWrite()) {
            file2.setReadOnly();
        }
        file2.setLastModified(file.lastModified());
        return bl;
    }

    public static final boolean copyFile(File file, File file2) {
        return Util.copyFile(null, file, file2, null);
    }

    public static final boolean copyFile(File file, File file2, String string) {
        return Util.copyFile(null, file, file2, string);
    }

    public static final boolean copyFile(ProgressMonitor progressMonitor, File file, File file2) {
        return Util.copyFile(progressMonitor, file, file2, null);
    }

    public static final boolean copyFile(ProgressMonitor progressMonitor, File file, File file2, String string) {
        FileInputStream fileInputStream;
        if (file.isDirectory()) {
            return false;
        }
        if (Util.getPath(file).equals(Util.getPath(file2))) {
            return false;
        }
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't open source file " + file);
            return false;
        }
        Util.copyStreamToFile(progressMonitor, fileInputStream, file2, string);
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {}
        if (!file.canWrite()) {
            file2.setReadOnly();
        }
        file2.setLastModified(file.lastModified());
        return true;
    }

    public static final boolean copyJar(File file, File file2) {
        return Util.copyJar(null, file, file2, null);
    }

    public static final boolean copyJar(File file, File file2, String string) {
        return Util.copyJar(null, file, file2, string);
    }

    public static final boolean copyJar(ProgressMonitor progressMonitor, File file, File file2) {
        return Util.copyJar(progressMonitor, file, file2, null);
    }

    public static final boolean copyJar(ProgressMonitor progressMonitor, File file, File file2, String string) {
        JarFile jarFile;
        if (file2.exists() && !file2.isDirectory()) {
            return false;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            return false;
        }
        boolean bl = true;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            if ("META-INF/MANIFEST.MF".startsWith(string2)) continue;
            File file3 = new File(file2, string2);
            file3.mkdirs();
            if (!jarEntry.isDirectory()) {
                InputStream inputStream;
                try {
                    inputStream = jarFile.getInputStream(jarEntry);
                }
                catch (IOException iOException) {
                    System.err.println("Couldn't copy entry " + string2);
                    continue;
                }
                Util.copyStreamToFile(progressMonitor, inputStream, file3, string);
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            file3.setLastModified(jarEntry.getTime());
        }
        return bl;
    }

    private static final boolean copyStreamToFile(ProgressMonitor progressMonitor, InputStream inputStream, File file, String string) {
        Object object;
        if (file.exists()) {
            if (string == null) {
                if (progressMonitor != null) {
                    progressMonitor.setDetail("Deleting existing " + file);
                }
                file.delete();
            } else {
                if (progressMonitor != null) {
                    progressMonitor.setDetail("Backing up existing " + file);
                }
                if (((File)(object = new File(String.valueOf(file.getPath()) + string))).exists()) {
                    ((File)object).delete();
                }
                file.renameTo((File)object);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setDetail("Installing " + file);
        }
        try {
            object = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.err.println("Couldn't open output file " + file);
            return false;
        }
        byte[] byArray = new byte[1024];
        try {
            try {
                int n;
                long l = 0L;
                while ((n = inputStream.read(byArray)) >= 0) {
                    ((FileOutputStream)object).write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                boolean bl = false;
                Object var8_10 = null;
                try {
                    ((FileOutputStream)object).close();
                }
                catch (Exception exception) {}
                return bl;
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            try {
                ((FileOutputStream)object).close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {}
        return true;
    }

    public static final String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }
}

