/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import visad.install.Download;
import visad.install.Path;
import visad.util.CmdlineGenericConsumer;
import visad.util.CmdlineParser;

public class UpdateJar
extends CmdlineGenericConsumer {
    private static final String CLASSPATH_PROPERTY = "java.class.path";
    private static final String VISAD_JAR_URL = "http://www.ssec.wisc.edu/~dglo/visad.jar";
    private File installJar;
    private URL jarURL;
    private boolean verbose;

    public UpdateJar(String[] stringArray) {
        CmdlineParser cmdlineParser = new CmdlineParser(this);
        if (!cmdlineParser.processArgs(stringArray)) {
            System.exit(1);
            return;
        }
        Download.getFile(this.jarURL, this.installJar, this.verbose);
    }

    public int checkKeyword(String string, int n, String[] stringArray) {
        String string2;
        URL uRL;
        try {
            uRL = new URL(stringArray[n]);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        if (uRL != null) {
            if (this.jarURL != null) {
                System.err.println(String.valueOf(string) + ": Too many URLs specified!");
                return -1;
            }
            this.jarURL = uRL;
            return 1;
        }
        if (this.installJar != null) {
            System.err.println(String.valueOf(string) + ": Too many jar install directories specified!");
            return -1;
        }
        int n2 = stringArray[n].length();
        int n3 = 4;
        File file = this.installJar = new File(stringArray[n]);
        String string3 = null;
        if (n2 > 4 && (string2 = stringArray[n].substring(n2 - 4, n2)).toLowerCase().equals(".jar")) {
            string3 = this.installJar.getName();
            file = new File(this.installJar.getParent());
        }
        if (!file.exists()) {
            System.err.println(String.valueOf(string) + ": Directory \"" + file + "\" does not exist!");
            this.installJar = null;
            return -1;
        }
        if (!file.isDirectory()) {
            System.err.println(String.valueOf(string) + ": \"" + file + "\" is not a directory!");
            this.installJar = null;
            return -1;
        }
        if (!file.canWrite()) {
            System.err.println(String.valueOf(string) + ": Cannot write to directory \"" + file + "\"!");
            this.installJar = null;
            return -1;
        }
        if (this.installJar != file && this.installJar.exists() && !this.installJar.canWrite()) {
            System.err.println(String.valueOf(string) + ": Cannot write to jar file \"" + this.installJar + "\"!");
            this.installJar = null;
            return -1;
        }
        return 1;
    }

    public int checkOption(String string, char c, String string2) {
        if (c == 'v') {
            this.verbose = true;
            return 1;
        }
        return 0;
    }

    public boolean finalizeArgs(String string) {
        if (this.jarURL == null) {
            try {
                this.jarURL = new URL(VISAD_JAR_URL);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(String.valueOf(string) + ": Couldn't build URL from \"" + VISAD_JAR_URL + "\"");
                return false;
            }
        }
        if (this.installJar == null) {
            File file = new File(this.jarURL.getFile());
            this.installJar = this.findJar(file.getName());
        }
        if (this.installJar == null) {
            System.err.println(String.valueOf(string) + ": Couldn't determine" + " where jar file should be installed");
            return false;
        }
        return true;
    }

    private File findJar(String string) {
        Path path;
        try {
            path = new Path(System.getProperty(CLASSPATH_PROPERTY));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(String.valueOf(this.getClass().getName()) + ": Couldn't get Java class path");
            return null;
        }
        ArrayList arrayList = path.findMatch(string);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        return (File)arrayList.get(0);
    }

    public void initializeArgs() {
        this.installJar = null;
        this.jarURL = null;
    }

    public String keywordUsage() {
        return " [url] [jarLocation]";
    }

    public static final void main(String[] stringArray) {
        new UpdateJar(stringArray);
        System.exit(0);
    }

    public String optionUsage() {
        return " [-v(erbose)]";
    }
}

