/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private static final int BORDER_WIDTH = 5;
    private static final int WIDTH_PAD = 2;
    private static final int HEIGHT_PAD = 2;
    private ImageIcon image;
    private String[] names;
    private String[] values;
    private Font textFont;
    private int nameLen;
    private int lineHeight;
    private int textX;
    private int textY;
    private int textWidth;
    private int textHeight;

    public SplashScreen(String string) {
        this(new ImageIcon(string), null, null);
    }

    public SplashScreen(String string, String[] stringArray, String[] stringArray2) {
        this(new ImageIcon(string), stringArray, stringArray2);
    }

    public SplashScreen(ImageIcon imageIcon) {
        this(imageIcon, null, null);
    }

    public SplashScreen(ImageIcon imageIcon, String[] stringArray, String[] stringArray2) {
        this.image = imageIcon;
        this.names = stringArray;
        this.values = stringArray2;
        this.textFont = new Font("sansserif", 0, 12);
        this.setContentPane(this.createSplash());
        this.pack();
        this.center();
    }

    public SplashScreen(String[] stringArray, String[] stringArray2) {
        this((ImageIcon)null, stringArray, stringArray2);
    }

    private void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getContentPane().getPreferredSize();
        int n = (dimension.width - dimension2.width) / 2;
        int n2 = (dimension.height - dimension2.height) / 2;
        ((Component)this).setBounds(n, n2, dimension2.width, dimension2.height);
    }

    private JPanel createSplash() {
        JPanel jPanel = new JPanel();
        Dimension dimension = this.image == null ? new Dimension(400, 200) : new Dimension(this.image.getIconWidth() + 10, this.image.getIconHeight() + 10);
        jPanel.setMinimumSize(dimension);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        return jPanel;
    }

    private void drawTextArea(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(this.textX, this.textY, this.textWidth, this.textHeight);
        graphics.setColor(Color.black);
        int n = this.textY + (this.lineHeight - 2);
        int n2 = 0;
        while (n2 < this.values.length) {
            if (this.values[n2] != null) {
                graphics.drawString(this.names[n2], this.textX + 2, n);
                graphics.drawString(this.values[n2], this.textX + 2 + this.nameLen + 2, n);
                n += this.lineHeight;
            }
            ++n2;
        }
    }

    private void dumpFonts() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        int n = 0;
        while (n < fontArray.length) {
            System.out.println("#" + n + ": " + fontArray[n]);
            ++n;
        }
    }

    private boolean initializeTextArea(Graphics graphics) {
        int n;
        if (this.names == null || this.values == null) {
            return false;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = 0;
        this.nameLen = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.values.length) {
            if (this.values[n4] != null) {
                n = fontMetrics.stringWidth(this.names[n4]);
                if (n > this.nameLen) {
                    this.nameLen = n;
                }
                if ((n = fontMetrics.stringWidth(this.values[n4])) > n2) {
                    n2 = n;
                }
                ++n3;
            }
            ++n4;
        }
        if (n2 == 0) {
            return false;
        }
        n = this.nameLen + 2 + n2;
        this.lineHeight = fontMetrics.getHeight() + 2;
        this.textWidth = 2 + n + 2;
        this.textHeight = 2 + n3 * this.lineHeight;
        this.textX = 20;
        this.textY = this.getHeight() - (20 + this.textHeight);
        return true;
    }

    public static final void main(String[] stringArray) {
        Font font = null;
        if (stringArray.length > 0) {
            int n = 12;
            if (stringArray.length > 1) {
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Bad font size \"" + stringArray[1] + "\"");
                    System.exit(1);
                }
            }
            font = new Font(stringArray[0], 0, n);
        }
        ImageIcon imageIcon = new ImageIcon("visad-splash.jpg");
        String[] stringArray2 = new String[]{"Name:", "Machine:"};
        String[] stringArray3 = new String[]{"dglo", "hyde.ssec.wisc.edu"};
        SplashScreen splashScreen = new SplashScreen(imageIcon);
        if (font != null) {
            splashScreen.setTextFont(font);
        }
        ((Component)splashScreen).setVisible(true);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException interruptedException) {}
        ((Component)splashScreen).setVisible(false);
        splashScreen = new SplashScreen(stringArray2, stringArray3);
        if (font != null) {
            splashScreen.setTextFont(font);
        }
        ((Component)splashScreen).setVisible(true);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException interruptedException) {}
        ((Component)splashScreen).setVisible(false);
        splashScreen = new SplashScreen(imageIcon, stringArray2, stringArray3);
        if (font != null) {
            splashScreen.setTextFont(font);
        }
        ((Component)splashScreen).setVisible(true);
        try {
            Thread.sleep(7000L);
        }
        catch (InterruptedException interruptedException) {}
        ((Component)splashScreen).setVisible(false);
        System.exit(0);
    }

    public void paint(Graphics graphics) {
        graphics.setFont(this.textFont);
        boolean bl = this.initializeTextArea(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.image != null) {
            graphics.drawImage(this.image.getImage(), 5, 5, ((Component)this).getBackground(), this);
        } else {
            graphics.setColor(Color.magenta);
            graphics.fillRect(0, 0, n, n2);
        }
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n, 5);
        graphics.fillRect(0, 0, 5, n2);
        graphics.fillRect(n - 5, 5, 5, n2 - 5);
        graphics.fillRect(5, n2 - 5, n - 5, 5);
        if (bl) {
            this.drawTextArea(graphics);
        }
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }
}

