/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProgressMonitor
extends JFrame {
    private Font labelFont;
    private JLabel phaseLabel;
    private DetailLabel detailLabel;
    private JCheckBox detailBox;

    public ProgressMonitor() {
        this(true);
    }

    public ProgressMonitor(Font font) {
        this(font, true);
    }

    public ProgressMonitor(Font font, boolean bl) {
        super("Installation Progress Monitor");
        String string = "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW";
        String string2 = "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW";
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.stringWidth("WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
        int n2 = fontMetrics.getHeight();
        Dimension dimension = new Dimension(n, n2);
        this.phaseLabel = new JLabel("Phase");
        this.phaseLabel.setFont(font);
        this.phaseLabel.setMinimumSize(dimension);
        this.phaseLabel.setPreferredSize(dimension);
        this.phaseLabel.setMaximumSize(dimension);
        this.detailLabel = new DetailLabel("", bl);
        this.detailLabel.setFont(font);
        this.detailLabel.setMinimumSize(dimension);
        this.detailLabel.setPreferredSize(dimension);
        this.detailLabel.setMaximumSize(dimension);
        this.detailBox = new JCheckBox("Show details", bl);
        this.detailBox.setFont(font);
        this.detailBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ProgressMonitor.this.detailLabel.toggleShown();
                if (ProgressMonitor.this.detailLabel.isShown()) {
                    ProgressMonitor.this.pack();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.phaseLabel);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.detailLabel);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(this.detailBox);
        jPanel.add(Box.createHorizontalStrut(10));
        this.setContentPane(jPanel);
        this.pack();
    }

    public ProgressMonitor(boolean bl) {
        this(new Font("sansserif", 0, 12), bl);
    }

    public final boolean isDetailShown() {
        return this.detailLabel.isShown();
    }

    public final void setDetail(String string) {
        this.detailLabel.setText(string);
    }

    public final void setPhase(String string) {
        this.phaseLabel.setText(string);
        this.detailLabel.setText("");
    }

    class DetailLabel
    extends JLabel {
        private String text;
        private boolean show;

        DetailLabel(String string, boolean bl) {
            super(string);
            this.text = string;
            this.show = bl;
        }

        final boolean isShown() {
            return this.show;
        }

        public final void setText(String string) {
            this.text = string;
            if (this.show) {
                super.setText(string);
            }
        }

        final void toggleShown() {
            this.show ^= true;
            if (this.show) {
                super.setText(this.text);
            } else {
                super.setText("");
                this.invalidate();
            }
        }
    }
}

