/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Path {
    private ArrayList path;

    public Path(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null path string");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty path string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            throw new IllegalArgumentException("Empty path string");
        }
        this.path = new ArrayList();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            this.path.add(stringTokenizer.nextToken());
        }
    }

    public ArrayList find(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = this.path.size();
        ArrayList<File> arrayList = null;
        int n2 = 0;
        while (n2 < n) {
            File file = new File((String)this.path.get(n2), string);
            if (file.isFile()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<File>();
                }
                arrayList.add(file);
            }
            ++n2;
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList;
    }

    public ArrayList findMatch(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = this.path.size();
        ArrayList<File> arrayList = null;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String string2 = (String)this.path.get(n2);
            if (string2.endsWith(String.valueOf(File.separator) + string) && (file = new File(string2)).exists()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<File>();
                }
                arrayList.add(file);
            }
            ++n2;
        }
        return arrayList;
    }

    public static final void main(String[] stringArray) throws IllegalArgumentException {
        if (stringArray.length < 2) {
            System.err.println("Usage: java Path pathString file [file ...]");
            System.exit(1);
            return;
        }
        Path path = new Path(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            ArrayList arrayList = path.findMatch(stringArray[n]);
            if (arrayList == null && (arrayList = path.find(stringArray[n])) == null) {
                System.err.println("Couldn't find \"" + stringArray[n] + "\"");
            } else {
                System.out.println(String.valueOf(stringArray[n]) + ":");
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    System.out.println("  " + arrayList.get(n2));
                    ++n2;
                }
            }
            ++n;
        }
        System.exit(0);
    }

    public String toString() {
        if (this.path == null || this.path.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer((String)this.path.get(0));
        int n = 1;
        while (n < this.path.size()) {
            stringBuffer.append(File.pathSeparator);
            stringBuffer.append(this.path.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }
}

