/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import visad.install.ChooserList;
import visad.install.ClusterInstaller;
import visad.install.Download;
import visad.install.JavaFile;
import visad.install.Path;
import visad.install.ProgressMonitor;
import visad.install.SplashScreen;
import visad.install.Util;
import visad.util.CmdlineGenericConsumer;
import visad.util.CmdlineParser;

public class Main
extends CmdlineGenericConsumer {
    private static final String CLASSPATH_PROPERTY = "java.class.path";
    private static final String ARCH_PROPERTY = "visad.install.arch";
    private static final String HOME_PROPERTY = "visad.install.home";
    private static final String PATH_PROPERTY = "visad.install.path";
    private static final String SPLASH_NAME = "visad-splash.jpg";
    private static final String JAR_NAME = "visad.jar";
    private static final String VISAD_JAR_URL = "ftp://ftp.ssec.wisc.edu/pub/visad-2.0/visad.jar";
    private boolean debug;
    private URL jarURL;
    private ChooserList chooser;
    private Path classpath;
    private Path path;
    private ArrayList jarList;
    private ArrayList javaList;
    private File installerJar;
    private JavaFile installerJava;
    private File installerJavaDir;
    private File installerJavaJar;
    private String archStr;
    private String cPushStr;
    private boolean useSuppliedJava;
    private boolean downloadLatestJar;
    private File javaInstallDir;
    private File jarInstallDir;
    private ClusterInstaller clusterInstaller;

    public Main(String[] stringArray) {
        CmdlineParser cmdlineParser = new CmdlineParser(this);
        if (!cmdlineParser.processArgs(stringArray)) {
            System.exit(1);
            return;
        }
        String string = System.getProperty(HOME_PROPERTY);
        File file = string == null ? null : new File(string);
        if (file == null || !file.exists()) {
            file = new File(".");
        }
        SplashScreen splashScreen = null;
        File file2 = new File(file, SPLASH_NAME);
        if (file2.exists()) {
            splashScreen = new SplashScreen(Main.getPath(file2));
            ((Component)splashScreen).setVisible(true);
        }
        boolean bl = this.initialize(file);
        if (splashScreen != null) {
            ((Component)splashScreen).setVisible(false);
        }
        if (!bl) {
            System.exit(1);
            return;
        }
        if (this.debug) {
            this.dumpInitialState(file);
        }
        this.downloadLatestJar = false;
        this.useSuppliedJava = false;
        this.jarInstallDir = null;
        this.javaInstallDir = null;
        this.clusterInstaller = null;
        this.queryUser();
        if (this.debug) {
            this.dumpInstallState();
        }
        this.install();
    }

    private static final void checkJavaVersions(ArrayList arrayList, int n, int n2) {
        int n3 = 0;
        while (n3 < arrayList.size()) {
            JavaFile javaFile = new JavaFile((File)arrayList.get(n3));
            if (javaFile.matchMinimum(n, n2)) {
                arrayList.set(n3++, javaFile);
                continue;
            }
            arrayList.remove(n3);
        }
    }

    public int checkOption(String string, char c, String string2) {
        if (c == 'x') {
            this.debug = true;
            return 1;
        }
        return 0;
    }

    private static final File chooseDirectory(ChooserList chooserList, ArrayList arrayList, String string) {
        File file;
        int n;
        Object object;
        int n2 = arrayList == null ? 0 : arrayList.size();
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            object = (File)arrayList.get(n3);
            if (!((File)object).isDirectory()) {
                bl = false;
                break;
            }
            ++n3;
        }
        if (!bl) {
            object = new File[n2];
            n = 0;
            while (n < n2) {
                file = (File)arrayList.get(n);
                object[n] = file.isDirectory() ? file : new File(file.getParent());
                ++n;
            }
        } else {
            object = n2 > 0 ? arrayList.toArray(new File[arrayList.size()]) : null;
        }
        chooserList.setList((File[])object);
        chooserList.setFileSelectionMode(1);
        chooserList.setDialogTitle(string);
        chooserList.setApproveButtonToolTipText("Select directory");
        chooserList.setApproveButtonText("Select...");
        n = chooserList.showDialog(null, "Select directory");
        if (n == 1) {
            return null;
        }
        file = chooserList.getSelectedFile();
        if (!file.exists()) {
            return file;
        }
        if (file.isDirectory()) {
            return file;
        }
        return new File(file.getParent());
    }

    private static final File chooseFile(ChooserList chooserList, ArrayList arrayList, String string) {
        if (arrayList == null) {
            chooserList.setList(null);
        } else {
            chooserList.setList(arrayList.toArray(new File[arrayList.size()]));
        }
        chooserList.setFileSelectionMode(0);
        chooserList.setDialogTitle(string);
        chooserList.setApproveButtonToolTipText("Choose file");
        int n = chooserList.showDialog(null, "Choose file");
        if (n == 1) {
            return null;
        }
        return chooserList.getSelectedFile();
    }

    private final void clusterPush(ProgressMonitor progressMonitor, String string, String string2) {
        Process process;
        try {
            process = this.clusterInstaller.push(string, string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {}
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        boolean bl = true;
        while (bl) {
            String string3;
            block14: {
                if (bufferedReader != null) {
                    try {
                        string3 = bufferedReader.readLine();
                        if (string3 == null) {
                            bufferedReader = null;
                            bl = bufferedReader2 != null;
                            break block14;
                        }
                        if (progressMonitor == null) break block14;
                        progressMonitor.setDetail(string3);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        break;
                    }
                }
            }
            if (bufferedReader2 == null) continue;
            try {
                if (!bufferedReader2.ready() && bufferedReader != null) continue;
                string3 = bufferedReader2.readLine();
                if (string3 == null) {
                    bufferedReader2 = null;
                    bl = bufferedReader != null;
                    continue;
                }
                if (progressMonitor == null) continue;
                progressMonitor.setDetail(string3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                break;
            }
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private final void dumpInitialState(File file) {
        int n;
        if (file != null && file.exists()) {
            System.out.println("Distribution directory: " + file);
        } else {
            System.out.println("Distribution directory: UNKNOWN!");
        }
        if (this.installerJavaDir != null) {
            System.out.println("Supplied java directory: " + this.installerJavaDir);
        }
        if (this.installerJavaJar != null) {
            System.out.println("Supplied java jar file: " + this.installerJavaJar);
        }
        if (this.installerJava != null) {
            System.out.println("Supplied java: " + this.installerJava);
        }
        if (this.installerJar != null) {
            System.out.println("Supplied visad.jar: " + this.installerJar);
        }
        if (this.jarList == null || this.jarList.size() == 0) {
            System.err.println("No visad.jar found in " + this.classpath);
        } else {
            System.err.println("== jar file list ==");
            n = 0;
            while (n < this.jarList.size()) {
                System.out.println("#" + n + ": " + Main.getPath((File)this.jarList.get(n)));
                ++n;
            }
        }
        if (this.javaList == null || this.javaList.size() == 0) {
            System.err.println("No java executable found in path " + this.path);
        } else {
            System.err.println("== java executable list ==");
            n = 0;
            while (n < this.javaList.size()) {
                System.out.println("#" + n + ": " + Main.getPath((File)this.javaList.get(n)));
                ++n;
            }
        }
        if (this.cPushStr == null) {
            System.err.println("No cluster executable found in path " + this.path);
        } else {
            System.err.println("== cluster executable ==");
            System.out.println(this.cPushStr);
        }
    }

    private final void dumpInstallState() {
        if (this.useSuppliedJava) {
            System.err.println("Install java in " + this.javaInstallDir);
        }
        if (this.downloadLatestJar) {
            System.err.println("Download latest visad.jar");
        }
        System.err.println("Install visad.jar in " + this.jarInstallDir);
        if (this.clusterInstaller != null) {
            System.err.println("Push installed files out to cluster");
        }
    }

    private static final File extractInstallerFile(File file, ArrayList arrayList) {
        String string = Main.getPath(file);
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            if (!Main.getPath(file2).startsWith(string)) continue;
            iterator.remove();
            return file2;
        }
        return null;
    }

    private String getJarTopDir(File file) {
        JarFile jarFile;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            return null;
        }
        String string = null;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            if ("META-INF/MANIFEST.MF".startsWith(string2)) continue;
            int n = string2.indexOf(File.separatorChar);
            String string3 = n < 0 ? string2 : string2.substring(0, n);
            if (string == null) {
                string = string3;
                continue;
            }
            if (string.equals(string3)) continue;
            string = null;
            break;
        }
        return string;
    }

    private static final String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getPath();
        }
    }

    private final boolean initialize(File file) {
        Serializable serializable;
        this.chooser = new ChooserList();
        this.path = null;
        this.classpath = null;
        this.jarURL = null;
        this.javaList = null;
        this.jarList = null;
        try {
            this.classpath = new Path(System.getProperty(CLASSPATH_PROPERTY));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(String.valueOf(this.getClass().getName()) + ": Couldn't get Java class path");
            return false;
        }
        String string = System.getProperty(PATH_PROPERTY);
        if (string == null) {
            this.path = null;
        } else {
            try {
                this.path = new Path(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.path = null;
            }
        }
        try {
            this.jarURL = new URL(VISAD_JAR_URL);
        }
        catch (MalformedURLException malformedURLException) {
            this.jarURL = null;
        }
        this.installerJar = null;
        this.jarList = this.classpath.findMatch(JAR_NAME);
        if (this.jarList != null) {
            Main.loseDuplicates(this.jarList);
            this.installerJar = Main.extractInstallerFile(file, this.jarList);
        }
        if (this.installerJar == null && this.jarURL == null) {
            System.err.println("Couldn't find either distributed jar file or jar file URL!");
            System.exit(1);
        }
        this.installerJava = null;
        this.installerJavaDir = null;
        if (this.path == null) {
            this.javaList = null;
        } else {
            this.javaList = this.path.find("java");
            if (this.javaList != null) {
                Main.loseDuplicates(this.javaList);
                Main.checkJavaVersions(this.javaList, 1, 2);
                this.installerJava = (JavaFile)Main.extractInstallerFile(file, this.javaList);
                if (this.installerJava != null && this.installerJava.getName().equals("java")) {
                    serializable = new File(Main.getPath(this.installerJava));
                    this.installerJavaDir = new File(((File)serializable).getParent());
                    if (this.installerJavaDir.getName().equals("bin")) {
                        this.installerJavaDir = new File(this.installerJavaDir.getParent());
                    }
                }
            }
        }
        this.archStr = System.getProperty(ARCH_PROPERTY);
        if (this.archStr != null && this.archStr.length() == 0) {
            this.archStr = null;
        }
        this.installerJavaJar = null;
        if (this.installerJavaDir == null && this.archStr != null && ((File)(serializable = new File(file, "jdk-" + this.archStr + ".jar"))).exists()) {
            this.installerJavaJar = serializable;
        }
        this.cPushStr = null;
        if (this.path != null && (serializable = this.path.find("cpush")) != null) {
            Main.loseDuplicates((ArrayList)serializable);
            if (serializable != null && ((ArrayList)serializable).size() > 0) {
                this.cPushStr = Main.getPath((File)((ArrayList)serializable).get(0));
            }
        }
        return true;
    }

    public void initializeArgs() {
        this.debug = false;
    }

    private final void install() {
        ProgressMonitor progressMonitor = new ProgressMonitor();
        progressMonitor.setPhase("Starting install");
        ((Component)progressMonitor).setVisible(true);
        if (this.downloadLatestJar) {
            progressMonitor.setPhase("Downloading jar file");
            Download.getFile(this.jarURL, this.jarInstallDir, false);
        } else {
            progressMonitor.setPhase("Copying jar file");
            Util.copyFile(progressMonitor, this.installerJar, this.jarInstallDir, ".old");
        }
        if (this.clusterInstaller != null) {
            progressMonitor.setPhase("Pushing jar file to cluster");
            this.clusterPush(null, Main.getPath(new File(this.jarInstallDir, JAR_NAME)), Main.getPath(this.jarInstallDir));
        }
        if (this.useSuppliedJava) {
            progressMonitor.setPhase("Copying JVM");
            if (this.installerJavaDir != null) {
                if (this.javaInstallDir.exists()) {
                    this.javaInstallDir = new File(this.javaInstallDir, this.installerJavaDir.getName());
                }
                Util.copyDirectory(progressMonitor, this.installerJavaDir, this.javaInstallDir);
            } else {
                String string = this.getJarTopDir(this.installerJavaJar);
                if (string == null && this.archStr != null) {
                    string = "jdk-" + this.archStr;
                }
                if (string != null) {
                    this.javaInstallDir = new File(this.javaInstallDir, string);
                }
                Util.copyJar(progressMonitor, this.installerJavaJar, this.javaInstallDir);
            }
            progressMonitor.setPhase("Setting JVM executable bits");
            this.makeJVMBinariesExecutable();
            if (this.clusterInstaller != null) {
                progressMonitor.setPhase("Pushing JVM to cluster");
                this.clusterPush(progressMonitor, this.javaInstallDir.toString(), this.javaInstallDir.getParent().toString());
            }
        }
        progressMonitor.setPhase("Install finished!");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static final void loseDuplicates(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            int n2 = n + 1;
            while (n2 < arrayList.size()) {
                Object e2 = arrayList.get(n2);
                if (!e.equals(e2)) {
                    ++n2;
                    continue;
                }
                arrayList.remove(n2);
            }
            ++n;
        }
    }

    public static final void main(String[] stringArray) {
        new Main(stringArray);
        System.exit(0);
    }

    private final void makeJVMBinariesExecutable() {
        Process process;
        if (this.path == null) {
            return;
        }
        ArrayList arrayList = this.path.find("chmod");
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        File file = (File)arrayList.get(0);
        File file2 = new File(this.javaInstallDir, "bin");
        if (!file2.exists()) {
            return;
        }
        String[] stringArray = file2.list();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = new String[2 + stringArray.length];
        stringArray2[0] = file.toString();
        stringArray2[1] = "555";
        StringBuffer stringBuffer = new StringBuffer(file2.toString());
        stringBuffer.append('/');
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringBuffer.setLength(n);
            stringBuffer.append(stringArray[n2]);
            stringArray2[n2 + 2] = stringBuffer.toString();
            ++n2;
        }
        try {
            process = Runtime.getRuntime().exec(stringArray2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public String optionUsage() {
        return String.valueOf(super.optionUsage()) + " [-x(debug)]";
    }

    private final void queryUser() {
        boolean bl = false;
        boolean bl2 = true;
        int n = 2;
        int n2 = 3;
        int n3 = 4;
        int n4 = 5;
        int n5 = 0;
        while (n5 < 5) {
            switch (n5) {
                case 2: {
                    if (this.queryUserUseSuppliedJava()) {
                        ++n5;
                        break;
                    }
                    --n5;
                    break;
                }
                case 3: {
                    n5 += this.queryUserInstallJava();
                    break;
                }
                case 0: {
                    n5 += this.queryUserInstallJar();
                    break;
                }
                case 1: {
                    if (this.queryUserDownloadJar()) {
                        ++n5;
                        break;
                    }
                    --n5;
                    break;
                }
                case 4: {
                    if (this.queryUserClusterPush()) {
                        ++n5;
                        break;
                    }
                    --n5;
                    break;
                }
            }
            if (n5 >= 0) continue;
            if (this.queryUserCancelInstall()) {
                System.exit(0);
                return;
            }
            n5 = 0;
        }
    }

    private final boolean queryUserCancelInstall() {
        String string = "Do you want to cancel this install?";
        int n = JOptionPane.showConfirmDialog(null, string, "Cancel install?", 0);
        return n == 0;
    }

    private final boolean queryUserClusterPush() {
        int n = 1;
        if (this.cPushStr != null) {
            String string = "Would you like to push everything out to the cluster?";
            String string2 = "Push files to cluster?";
            n = JOptionPane.showConfirmDialog(null, string, string2, 1);
        }
        this.clusterInstaller = n != 0 ? null : new ClusterInstaller(this.cPushStr);
        return n != 2;
    }

    private final boolean queryUserDownloadJar() {
        int n = 0;
        if (this.installerJar != null) {
            String string = "Would you like to download the latest visad.jar?";
            String string2 = "Download latest visad.jar?";
            n = JOptionPane.showConfirmDialog(null, string, string2, 1);
        }
        this.downloadLatestJar = n == 0;
        return n != 2;
    }

    private final int queryUserInstallJar() {
        this.jarInstallDir = Main.chooseDirectory(this.chooser, this.jarList, "Select the directory where the VisAD jar file should be installed");
        if (this.jarInstallDir == null) {
            return -1;
        }
        if (!this.jarInstallDir.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot write to that directory!", "Bad directory?", 0);
            return 0;
        }
        return 1;
    }

    private final int queryUserInstallJava() {
        this.javaInstallDir = null;
        if (this.useSuppliedJava) {
            this.javaInstallDir = Main.chooseDirectory(this.chooser, null, "Select the directory in which the JDK should be installed");
            if (this.javaInstallDir == null) {
                return -1;
            }
            if (!this.javaInstallDir.canWrite()) {
                JOptionPane.showMessageDialog(null, "Cannot write to that directory!", "Bad directory?", 0);
                return 0;
            }
        }
        return 1;
    }

    private final boolean queryUserUseSuppliedJava() {
        int n = 1;
        if (this.installerJavaDir != null || this.installerJavaJar != null) {
            String string = this.installerJavaDir != null ? "Would you like to install the supplied  Java Development Kit " + this.installerJava.getMajor() + "." + this.installerJava.getMinor() + " (" + this.installerJava.getVersionString() + ")?" : "Would you like to install the supplied  Java Development Kit?";
            String string2 = "Install supplied JDK?";
            n = JOptionPane.showConfirmDialog(null, string, string2, 1);
        }
        this.useSuppliedJava = n == 0;
        return n != 2;
    }
}

