/*
 * Decompiled with CFR 0.152.
 */
package visad.install;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class JavaFile
extends File {
    private static final String[] regexpStr = new String[]{"^java version \"(\\d+)\\.(\\d+).*\"", "^java version \"HP-UX Java [A-Z]\\.\\d+\\.(\\d)(\\d+).*\""};
    private static RE[] regexp = null;
    private static Runtime runtime = null;
    private String fullString;
    private int major;
    private int minor;

    public JavaFile(File file) {
        this(file.getParent(), file.getName());
    }

    public JavaFile(File file, String string) {
        super(file, string);
        this.findVersion();
    }

    public JavaFile(String string) {
        this(new File(string));
    }

    public JavaFile(String string, String string2) {
        this(new File(string), string2);
    }

    private final void findVersion() {
        Process process;
        if (regexp == null) {
            this.initRegExp();
        }
        if (runtime == null) {
            runtime = Runtime.getRuntime();
        }
        try {
            process = runtime.exec(String.valueOf(String.valueOf(this)) + " -version");
        }
        catch (IOException iOException) {
            System.err.println("While running '" + this + " -version':");
            iOException.printStackTrace();
            process = null;
        }
        boolean bl = false;
        if (process != null) {
            InputStream inputStream = process.getErrorStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            block4: while (!bl) {
                String string;
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    break;
                }
                if (string == null) break;
                int n = 0;
                while (n < regexp.length) {
                    REMatch rEMatch = regexp[n].getMatch(string);
                    if (rEMatch != null) {
                        this.fullString = string.substring(rEMatch.getStartIndex(), rEMatch.getEndIndex());
                        this.major = JavaFile.parseInt(string.substring(rEMatch.getSubStartIndex(1), rEMatch.getSubEndIndex(1)));
                        this.minor = JavaFile.parseInt(string.substring(rEMatch.getSubStartIndex(2), rEMatch.getSubEndIndex(2)));
                        bl = true;
                        continue block4;
                    }
                    ++n;
                }
            }
        }
        if (!bl) {
            this.fullString = null;
            this.minor = -1;
            this.major = -1;
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getVersionString() {
        return this.fullString;
    }

    private final synchronized void initRegExp() {
        String[] stringArray = regexpStr;
        synchronized (stringArray) {
            regexp = new RE[regexpStr.length];
            int n = 0;
            int n2 = 0;
            while (n2 < regexpStr.length) {
                try {
                    JavaFile.regexp[n2] = new RE(regexpStr[n2]);
                }
                catch (REException rEException) {
                    System.err.println("For regexp \"" + regexpStr[n2] + "\":");
                    rEException.printStackTrace();
                    ++n;
                    JavaFile.regexp[n2] = null;
                }
                ++n2;
            }
            if (n > 0) {
                RE[] rEArray = new RE[regexp.length - n];
                int n3 = 0;
                int n4 = 0;
                while (n3 < regexp.length) {
                    if (regexp[n3] != null) {
                        rEArray[n4++] = regexp[n3];
                    }
                    ++n3;
                }
                regexp = rEArray;
            }
        }
    }

    public final boolean matchMinimum(int n, int n2) {
        return this.major > n || this.major == n && this.minor >= n2;
    }

    private static final int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

