/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.Data;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.NamedLocation;

public class NamedLocationTuple
extends Tuple
implements NamedLocation {
    public static TextType IDENTIFIER_TYPE;
    private EarthLocation location;
    private Text id;

    public Real getLatitude() {
        return this.location.getLatitude();
    }

    public Real getLongitude() {
        return this.location.getLongitude();
    }

    public Real getAltitude() {
        return this.location.getAltitude();
    }

    public LatLonPoint getLatLonPoint() {
        return this.location.getLatLonPoint();
    }

    public EarthLocation getEarthLocation() {
        return this.location;
    }

    public Text getIdentifier() {
        return this.id;
    }

    public NamedLocationTuple(Text text, EarthLocation earthLocation) throws VisADException, RemoteException {
        super(new TupleType(new MathType[]{IDENTIFIER_TYPE, RealTupleType.LatitudeLongitudeAltitude}), new Data[]{text, new EarthLocationTuple(earthLocation.getLatitude(), earthLocation.getLongitude(), earthLocation.getAltitude())});
        this.id = text;
        this.location = earthLocation;
    }

    public NamedLocationTuple(String string, double d, double d2, double d3) throws VisADException, RemoteException {
        this(new Text(IDENTIFIER_TYPE, string), (EarthLocation)new EarthLocationTuple(d, d2, d3));
    }

    public NamedLocationTuple(String string, EarthLocation earthLocation) throws VisADException, RemoteException {
        this(new Text(IDENTIFIER_TYPE, string), earthLocation);
    }

    static {
        try {
            IDENTIFIER_TYPE = new TextType("Identifier");
        }
        catch (Exception exception) {
            System.err.println("NamedLocationTuple: Can't instatiate type");
        }
    }
}

