/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Stack;
import java.util.Vector;
import visad.ActionImpl;
import visad.CellImpl;
import visad.Data;
import visad.Real;
import visad.RealType;
import visad.RemoteCellImpl;
import visad.RemoteDataReference;
import visad.Text;
import visad.Thing;
import visad.ThingReference;
import visad.ThingReferenceImpl;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaUtil;
import visad.formula.FormulaVar;
import visad.formula.Postfix;

public class FormulaVar
extends ActionImpl {
    public static boolean DEBUG = false;
    public static RealType CONSTANT = RealType.getRealType("visad/formula/constant");
    private FormulaManager fm;
    String name;
    private String formula;
    private Postfix postfix;
    private ThingReference tref;
    private Vector errors = new Vector();
    private Object Lock = new Object();
    private boolean computing = false;
    private Vector depend = new Vector();
    private Vector required = new Vector();
    ThingReference textRef = null;
    CellImpl textCell = new 1(this);
    RemoteCellImpl rtCell = null;

    boolean othersDepend() {
        return !this.required.isEmpty();
    }

    boolean isDependentOn(FormulaVar formulaVar) {
        if (formulaVar == this || this.depend.contains(formulaVar)) {
            return true;
        }
        int n = 0;
        while (n < this.depend.size()) {
            FormulaVar formulaVar2 = (FormulaVar)this.depend.elementAt(n);
            if (formulaVar2.isDependentOn(formulaVar)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void setDependentOn(FormulaVar formulaVar) {
        block5: {
            if (!this.depend.contains(formulaVar)) {
                this.depend.add(formulaVar);
                try {
                    this.addReference(formulaVar.getReference());
                    formulaVar.required.add(this);
                }
                catch (VisADException visADException) {
                    if (DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!DEBUG) break block5;
                    remoteException.printStackTrace();
                }
            }
        }
    }

    private void clearDependencies() {
        block5: {
            int n = this.depend.size();
            int n2 = 0;
            while (n2 < n) {
                FormulaVar formulaVar = (FormulaVar)this.depend.elementAt(n2);
                formulaVar.required.remove(this);
                ++n2;
            }
            this.depend.removeAllElements();
            try {
                this.removeAllReferences();
            }
            catch (VisADException visADException) {
                if (DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!DEBUG) break block5;
                remoteException.printStackTrace();
            }
        }
    }

    private void rebuildDependencies() throws FormulaException {
        this.disableAction();
        Object object = this.Lock;
        synchronized (object) {
            this.clearDependencies();
            if (this.formula != null && this.postfix == null) {
                try {
                    Object[] objectArray = new Object[]{this.formula, this.fm};
                    String string = this.formula;
                    try {
                        string = (String)FormulaUtil.invokeMethod(this.fm.ppMethod, objectArray);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if (DEBUG) {
                            illegalAccessException.printStackTrace();
                        }
                        this.evalError("Preparsing access exception", illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (DEBUG) {
                            illegalArgumentException.printStackTrace();
                        }
                        this.evalError("Preparsing argument exception", illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable = invocationTargetException.getTargetException();
                        if (DEBUG) {
                            throwable.printStackTrace();
                        }
                        this.evalError("Preparsing exception", throwable);
                    }
                    this.postfix = new Postfix(string, this.fm);
                    int n = this.postfix.tokens == null ? 0 : this.postfix.tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = this.postfix.tokens[n2];
                        if (this.postfix.codes[n2] == 4) {
                            Double d = null;
                            try {
                                d = Double.valueOf(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (d == null) {
                                FormulaVar formulaVar = null;
                                try {
                                    formulaVar = this.fm.getVarByNameOrCreate(string2);
                                }
                                catch (FormulaException formulaException) {
                                    this.evalError("\"" + string2 + "\" is an illegal variable name");
                                }
                                catch (VisADException visADException) {
                                    this.evalError("Internal VisAD error", visADException);
                                }
                                if (formulaVar != null) {
                                    if (formulaVar.isDependentOn(this)) {
                                        this.clearDependencies();
                                        throw new FormulaException("This formula creates an infinite loop");
                                    }
                                    this.setDependentOn(formulaVar);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                catch (FormulaException formulaException) {
                    this.evalError("Syntax error in formula", formulaException);
                    try {
                        this.tref.setThing(null);
                    }
                    catch (VisADException visADException) {
                        this.evalError("Internal VisAD error", visADException);
                    }
                    catch (RemoteException remoteException) {
                        this.evalError("Internal remote error", remoteException);
                    }
                }
            }
        }
        this.enableAction();
        if (this.depend.isEmpty()) {
            this.doAction();
        }
    }

    void setFormula(String string) throws FormulaException {
        block5: {
            this.formula = string;
            if (this.textRef != null) {
                Text text = new Text(this.formula);
                try {
                    this.textRef.setThing(text);
                }
                catch (VisADException visADException) {
                    if (DEBUG) {
                        visADException.printStackTrace();
                    }
                }
                catch (RemoteException remoteException) {
                    if (!DEBUG) break block5;
                    remoteException.printStackTrace();
                }
            }
        }
        this.postfix = null;
        this.computing = true;
        this.rebuildDependencies();
    }

    void waitForFormula() {
        Object object = this.Lock;
        synchronized (object) {
            if (this.computing) {
                try {
                    this.Lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void setTextRef(ThingReference thingReference) throws VisADException, RemoteException {
        if (this.textRef == thingReference) {
            return;
        }
        if (this.textRef != null) {
            if (this.textRef instanceof RemoteDataReference) {
                this.rtCell.removeReference(this.textRef);
                this.rtCell = null;
            } else {
                this.textCell.removeReference(this.textRef);
            }
        }
        this.textRef = thingReference;
        if (this.textRef != null) {
            if (this.textRef instanceof RemoteDataReference) {
                this.rtCell = new RemoteCellImpl(this.textCell);
                this.rtCell.addReference(this.textRef);
            } else {
                this.textCell.addReference(this.textRef);
            }
        }
    }

    void setThing(Thing thing) throws VisADException, RemoteException {
        Object object = this.Lock;
        synchronized (object) {
            this.formula = null;
            this.postfix = null;
            this.clearDependencies();
            if (thing == null || thing != this.tref.getThing()) {
                this.tref.setThing(thing);
            }
        }
    }

    void setReference(ThingReference thingReference) {
        if (this.tref == thingReference) {
            return;
        }
        Object object = this.Lock;
        synchronized (object) {
            int n = this.required.size();
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    FormulaVar formulaVar = (FormulaVar)this.required.elementAt(n2);
                    try {
                        formulaVar.removeReference(this.tref);
                        formulaVar.addReference(thingReference);
                    }
                    catch (VisADException visADException) {
                        if (DEBUG) {
                            visADException.printStackTrace();
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (!DEBUG) break block9;
                        remoteException.printStackTrace();
                    }
                }
                ++n2;
            }
            this.tref = thingReference;
        }
    }

    Thing getThing() {
        try {
            return this.tref.getThing();
        }
        catch (VisADException visADException) {
            return null;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    ThingReference getReference() {
        return this.tref;
    }

    String getFormula() {
        return this.formula;
    }

    String[] getErrors() {
        Vector vector = this.errors;
        synchronized (vector) {
            int n = this.errors.size();
            if (n == 0) {
                String[] stringArray = null;
                Object var2_5 = null;
                return stringArray;
            }
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)this.errors.elementAt(n2);
                ++n2;
            }
            String[] stringArray2 = stringArray;
            Object var2_6 = null;
            return stringArray2;
        }
    }

    void clearErrors() {
        Vector vector = this.errors;
        synchronized (vector) {
            this.errors.clear();
        }
    }

    private void evalError(String string) {
        Vector vector = this.errors;
        synchronized (vector) {
            this.errors.add(string);
        }
    }

    private void evalError(String string, Throwable throwable) {
        String string2 = throwable == null ? null : throwable.getMessage();
        this.evalError(string + (string2 == null ? "" : ": " + string2));
    }

    public void doAction() {
        Object object = this.Lock;
        synchronized (object) {
            try {
                if (this.postfix != null) {
                    this.tref.setThing(this.compute(this.postfix));
                }
            }
            catch (VisADException visADException) {
                this.evalError("Could not store final value in variable");
            }
            catch (RemoteException remoteException) {
                this.evalError("Could not store final value in variable (remote)");
            }
            this.computing = false;
            this.Lock.notifyAll();
        }
    }

    private Thing popStack(Stack stack) {
        if (stack.empty()) {
            this.evalError("Syntax error in formula (stack empty)");
            return null;
        }
        return (Thing)stack.pop();
    }

    private Thing compute(Postfix postfix) {
        if (postfix.tokens == null) {
            return null;
        }
        int n = postfix.tokens.length;
        Stack<Object> stack = new Stack<Object>();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            String string = postfix.tokens[n2];
            String string2 = "\"" + string + "\"";
            int n3 = postfix.codes[n2];
            if (n3 == 0) {
                object = new Object[2];
                object[1] = this.popStack(stack);
                object[0] = this.popStack(stack);
                Thing thing = null;
                if (object[0] != null && object[1] != null) {
                    int n4 = 0;
                    while (n4 < this.fm.bMethods.length) {
                        if (thing == null && this.fm.bOps[n4].equals(string)) {
                            try {
                                thing = (Thing)FormulaUtil.invokeMethod(this.fm.bMethods[n4], (Object[])object);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                if (DEBUG) {
                                    illegalAccessException.printStackTrace();
                                }
                                this.evalError("Cannot access binary method for operator " + string2, illegalAccessException);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (DEBUG) {
                                    illegalArgumentException.printStackTrace();
                                }
                                this.evalError("Invalid argument to binary method for operator " + string2, illegalArgumentException);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Throwable throwable = invocationTargetException.getTargetException();
                                if (DEBUG) {
                                    throwable.printStackTrace();
                                }
                                this.evalError("Binary method for operator " + string2 + " threw an exception", throwable);
                            }
                        }
                        ++n4;
                    }
                }
                if (thing == null) {
                    this.evalError("Could not evaluate binary operator " + string2);
                    stack.push(null);
                } else {
                    stack.push(thing);
                }
            } else if (n3 == 1) {
                object = new Object[]{this.popStack(stack)};
                Thing thing = null;
                if (object[0] != null) {
                    int n5 = 0;
                    while (n5 < this.fm.uMethods.length) {
                        if (thing == null && this.fm.uOps[n5].equals(string)) {
                            try {
                                thing = (Thing)FormulaUtil.invokeMethod(this.fm.uMethods[n5], (Object[])object);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                if (DEBUG) {
                                    illegalAccessException.printStackTrace();
                                }
                                this.evalError("Cannot access unary method for operator " + string2, illegalAccessException);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (DEBUG) {
                                    illegalArgumentException.printStackTrace();
                                }
                                this.evalError("Invalid argument to unary method for operator " + string2, illegalArgumentException);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Throwable throwable = invocationTargetException.getTargetException();
                                if (DEBUG) {
                                    throwable.printStackTrace();
                                }
                                this.evalError("Unary method for operator " + string2 + " threw an exception", throwable);
                            }
                        }
                        ++n5;
                    }
                }
                if (thing == null) {
                    this.evalError("Could not evaluate unary operator " + string2);
                    stack.push(null);
                } else {
                    stack.push(thing);
                }
            } else if (n3 == 2) {
                Throwable throwable;
                int n6;
                boolean bl;
                Object object2;
                int n7;
                object = null;
                if (this.fm.isFunction(string)) {
                    block91: {
                        n7 = -1;
                        try {
                            object2 = (Object[])this.popStack(stack);
                            n7 = (int)object2.getValue();
                        }
                        catch (ClassCastException classCastException) {
                            if (!DEBUG) break block91;
                            classCastException.printStackTrace();
                        }
                    }
                    if (n7 < 0) {
                        this.evalError("Syntax error in formula (invalid function arg length)");
                        n7 = 1;
                    }
                    object2 = n7 > 0 ? new Object[n7] : null;
                    bl = false;
                    n6 = n7 - 1;
                    while (n6 >= 0) {
                        object2[n6] = this.popStack(stack);
                        if (object2[n6] == null) {
                            bl = true;
                        }
                        --n6;
                    }
                    if (!bl) {
                        n6 = 0;
                        while (n6 < this.fm.funcs.length) {
                            if (object == null && this.fm.funcs[n6].equalsIgnoreCase(string)) {
                                try {
                                    object = (Thing)FormulaUtil.invokeMethod(this.fm.fMethods[n6], object2);
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    if (DEBUG) {
                                        illegalAccessException.printStackTrace();
                                    }
                                    this.evalError("Cannot access method for function " + string2, illegalAccessException);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    if (DEBUG) {
                                        illegalArgumentException.printStackTrace();
                                    }
                                    this.evalError("Invalid argument to method for function " + string2, illegalArgumentException);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    throwable = invocationTargetException.getTargetException();
                                    if (DEBUG) {
                                        throwable.printStackTrace();
                                    }
                                    this.evalError("Method for function " + string2 + " threw an exception", throwable);
                                }
                            }
                            ++n6;
                        }
                    }
                    if (object == null) {
                        this.evalError("Could not evaluate function " + string2);
                        stack.push(null);
                    } else {
                        stack.push(object);
                    }
                } else {
                    block92: {
                        n7 = 0;
                        try {
                            n7 = Integer.parseInt(string) + 1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (!DEBUG) break block92;
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (n7 <= 0) {
                        this.evalError("Syntax error in formula (invalid implicit arg length)");
                        n7 = 1;
                    }
                    object2 = new Object[n7];
                    bl = false;
                    n6 = n7 - 1;
                    while (n6 >= 0) {
                        object2[n6] = this.popStack(stack);
                        if (object2[n6] == null) {
                            bl = true;
                        }
                        --n6;
                    }
                    if (!bl) {
                        n6 = 0;
                        while (n6 < this.fm.iMethods.length) {
                            if (object == null) {
                                try {
                                    object = (Thing)FormulaUtil.invokeMethod(this.fm.iMethods[n6], object2);
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    if (DEBUG) {
                                        illegalAccessException.printStackTrace();
                                    }
                                    this.evalError("Cannot access method for implicit function", illegalAccessException);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    if (DEBUG) {
                                        illegalArgumentException.printStackTrace();
                                    }
                                    this.evalError("Invalid argument to method for implicit function", illegalArgumentException);
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    throwable = invocationTargetException.getTargetException();
                                    if (DEBUG) {
                                        throwable.printStackTrace();
                                    }
                                    this.evalError("Method for implicit function threw an exception", throwable);
                                }
                            }
                            ++n6;
                        }
                    }
                    if (object == null) {
                        this.evalError("Could not evaluate implicit function");
                        stack.push(null);
                    } else {
                        stack.push(object);
                    }
                }
            } else {
                object = null;
                try {
                    object = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (object == null) {
                    FormulaVar formulaVar = null;
                    try {
                        formulaVar = this.fm.getVarByNameOrCreate(string);
                    }
                    catch (FormulaException formulaException) {
                        this.evalError(string2 + " is an illegal variable name");
                        stack.push(null);
                    }
                    catch (VisADException visADException) {
                        this.evalError("Internal error", visADException);
                        stack.push(null);
                    }
                    if (formulaVar != null) {
                        Thing thing;
                        block93: {
                            ThingReference thingReference = formulaVar.getReference();
                            thing = null;
                            if (thingReference != null) {
                                try {
                                    thing = thingReference.getThing();
                                }
                                catch (VisADException visADException) {
                                    if (DEBUG) {
                                        visADException.printStackTrace();
                                    }
                                }
                                catch (RemoteException remoteException) {
                                    if (!DEBUG) break block93;
                                    remoteException.printStackTrace();
                                }
                            }
                        }
                        if (thing == null) {
                            this.evalError("Variable " + string2 + " has no value");
                            stack.push(null);
                        } else {
                            stack.push(thing);
                        }
                    }
                } else if (n3 == 4) {
                    stack.push(new Real(CONSTANT, ((Double)object).doubleValue()));
                } else {
                    stack.push(new Real((Double)object));
                }
            }
            ++n2;
        }
        Thing thing = this.popStack(stack);
        if (!stack.empty()) {
            this.evalError("Syntax error in formula (leftover objects on stack)");
        }
        if (thing instanceof Data) {
            try {
                thing = ((Data)thing).local();
                if (thing instanceof Real && ((Real)thing).getType() == CONSTANT) {
                    thing = new Real(((Real)thing).getValue());
                }
            }
            catch (VisADException visADException) {
                this.evalError("The answer could not be converted to local data");
                thing = null;
            }
            catch (RemoteException remoteException) {
                this.evalError("The answer could not be converted to local data (remote)");
                thing = null;
            }
        }
        return thing;
    }

    static /* synthetic */ String access$0(FormulaVar formulaVar) {
        return formulaVar.formula;
    }

    FormulaVar(String string, FormulaManager formulaManager) throws VisADException {
        this(string, formulaManager, null);
    }

    FormulaVar(String string, FormulaManager formulaManager, ThingReference thingReference) throws VisADException {
        super(string);
        this.fm = formulaManager;
        this.name = string;
        this.tref = thingReference == null ? new ThingReferenceImpl(this.name) : thingReference;
        int n = 0;
        while (n < this.fm.bOps.length) {
            if (this.name.indexOf(this.fm.bOps[n]) >= 0) {
                throw new FormulaException("variable names cannot contain operators");
            }
            ++n;
        }
        n = 0;
        while (n < this.fm.uOps.length) {
            if (this.name.indexOf(this.fm.uOps[n]) >= 0) {
                throw new FormulaException("variable names cannot contain operators");
            }
            ++n;
        }
    }
}

