/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.Data;
import visad.Field;
import visad.FieldImpl;
import visad.Function;
import visad.Real;
import visad.RealType;
import visad.TupleIface;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaManager;
import visad.formula.FormulaVar;
import visad.formula.VMethod;
import visad.formula.VRealType;

public class FormulaUtil {
    private static int linkNum = 0;

    public static FormulaManager createStandardManager() {
        FormulaManager formulaManager;
        String[] stringArray = new String[]{".", "^", "*", "/", "%", "+", "-"};
        int[] nArray = new int[]{200, 400, 600, 600, 600, 800, 800};
        String[] stringArray2 = new String[]{"visad.formula.FormulaUtil.dot(visad.TupleIface, visad.Real)", "visad.Data.pow(visad.Data)", "visad.Data.multiply(visad.Data)", "visad.Data.divide(visad.Data)", "visad.Data.remainder(visad.Data)", "visad.Data.add(visad.Data)", "visad.Data.subtract(visad.Data)"};
        String[] stringArray3 = new String[]{"-"};
        int[] nArray2 = new int[]{500};
        String[] stringArray4 = new String[]{"visad.Data.negate()"};
        String[] stringArray5 = new String[]{"abs", "acos", "acosDegrees", "asin", "asinDegrees", "atan", "atan2", "atanDegrees", "atan2Degrees", "ceil", "combine", "cos", "cosDegrees", "derive", "domainMultiply", "domainFactor", "exp", "extract", "floor", "getSample", "linkx", "log", "max", "min", "negate", "rint", "round", "sin", "sinDegrees", "sqrt", "tan", "tanDegrees"};
        String[] stringArray6 = new String[]{"visad.Data.abs()", "visad.Data.acos()", "visad.Data.acosDegrees()", "visad.Data.asin()", "visad.Data.asinDegrees()", "visad.Data.atan()", "visad.Data.atan2(visad.Data)", "visad.Data.atanDegrees()", "visad.Data.atan2Degrees(visad.Data)", "visad.Data.ceil()", "visad.FieldImpl.combine(visad.Field[])", "visad.Data.cos()", "visad.Data.cosDegrees()", "visad.formula.FormulaUtil.derive(visad.Function, visad.formula.VRealType)", "visad.FieldImpl.domainMultiply()", "visad.formula.FormulaUtil.factor(visad.FieldImpl, visad.formula.VRealType)", "visad.Data.exp()", "visad.formula.FormulaUtil.extract(visad.Field, visad.Real)", "visad.Data.floor()", "visad.formula.FormulaUtil.brackets(visad.Field, visad.Real)", "visad.formula.FormulaUtil.link(visad.formula.VMethod, java.lang.Object[])", "visad.Data.log()", "visad.Data.max(visad.Data)", "visad.Data.min(visad.Data)", "visad.Data.negate()", "visad.Data.rint()", "visad.Data.round()", "visad.Data.sin()", "visad.Data.sinDegrees()", "visad.Data.sqrt()", "visad.Data.tan()", "visad.Data.tanDegrees()"};
        int n = 200;
        String[] stringArray7 = new String[]{"visad.formula.FormulaUtil.implicit(visad.Function, visad.Real)", "visad.Function.evaluate(visad.RealTuple)"};
        String string = "visad.formula.FormulaUtil.preParse(java.lang.String, visad.formula.FormulaManager)";
        try {
            formulaManager = new FormulaManager(stringArray, nArray, stringArray2, stringArray3, nArray2, stringArray4, stringArray5, stringArray6, n, stringArray7, string);
        }
        catch (FormulaException formulaException) {
            if (FormulaVar.DEBUG) {
                formulaException.printStackTrace();
            }
            return null;
        }
        return formulaManager;
    }

    public static Data dot(TupleIface tupleIface, Real real) {
        Data data;
        block4: {
            data = null;
            try {
                data = tupleIface.getComponent((int)real.getValue());
            }
            catch (VisADException visADException) {
                if (FormulaVar.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!FormulaVar.DEBUG) break block4;
                remoteException.printStackTrace();
            }
        }
        return data;
    }

    public static Data derive(Function function, VRealType vRealType) {
        Function function2;
        block4: {
            function2 = null;
            try {
                function2 = function.derivative(vRealType.getRealType(), 202);
            }
            catch (VisADException visADException) {
                if (FormulaVar.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!FormulaVar.DEBUG) break block4;
                remoteException.printStackTrace();
            }
        }
        return function2;
    }

    public static Field factor(FieldImpl fieldImpl, VRealType vRealType) {
        Field field;
        block4: {
            field = null;
            try {
                field = fieldImpl.domainFactor(vRealType.getRealType());
            }
            catch (VisADException visADException) {
                if (FormulaVar.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!FormulaVar.DEBUG) break block4;
                remoteException.printStackTrace();
            }
        }
        return field;
    }

    public static Data extract(Field field, Real real) {
        Field field2;
        block4: {
            field2 = null;
            try {
                field2 = field.extract((int)real.getValue());
            }
            catch (VisADException visADException) {
                if (FormulaVar.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!FormulaVar.DEBUG) break block4;
                remoteException.printStackTrace();
            }
        }
        return field2;
    }

    public static Data link(VMethod vMethod, Object[] objectArray) throws VisADException {
        Data data = null;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] instanceof VRealType) {
                    objectArray[n] = ((VRealType)objectArray[n]).getRealType();
                }
                ++n;
            }
        }
        try {
            data = (Data)FormulaUtil.invokeMethod(vMethod.getMethod(), objectArray);
        }
        catch (ClassCastException classCastException) {
            if (FormulaVar.DEBUG) {
                classCastException.printStackTrace();
            }
            throw new VisADException("Link error: invalid linked method");
        }
        catch (IllegalAccessException illegalAccessException) {
            if (FormulaVar.DEBUG) {
                illegalAccessException.printStackTrace();
            }
            throw new VisADException("Link error: cannot access linked method");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (FormulaVar.DEBUG) {
                illegalArgumentException.printStackTrace();
            }
            throw new VisADException("Link error: bad method argument");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (FormulaVar.DEBUG) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            throw new VisADException("Link error: linked method threw an exception");
        }
        if (data == null) {
            throw new VisADException("Link error: linked method returned null data");
        }
        return data;
    }

    public static Data implicit(Function function, Real real) {
        Data data;
        block4: {
            data = null;
            try {
                data = function.evaluate(real);
            }
            catch (VisADException visADException) {
                if (FormulaVar.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!FormulaVar.DEBUG) break block4;
                remoteException.printStackTrace();
            }
        }
        return data;
    }

    public static Data brackets(Field field, Real real) {
        Data data;
        block4: {
            data = null;
            try {
                RealType realType = (RealType)real.getType();
                data = field.getSample((int)real.getValue());
            }
            catch (VisADException visADException) {
                if (FormulaVar.DEBUG) {
                    visADException.printStackTrace();
                }
            }
            catch (RemoteException remoteException) {
                if (!FormulaVar.DEBUG) break block4;
                remoteException.printStackTrace();
            }
        }
        return data;
    }

    public static String preParse(String string, FormulaManager formulaManager) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = string3 + stringTokenizer.nextToken();
        }
        if (string3.equals("")) {
            return string3;
        }
        while (!(string3 = FormulaUtil.preParseOnce(string2 = string3, formulaManager)).equals(string2)) {
        }
        return string3;
    }

    private static String preParseOnce(String string, FormulaManager formulaManager) {
        String string2 = string.toLowerCase();
        int n = string2.length();
        boolean bl = false;
        String string3 = "";
        int n2 = 0;
        while (n2 < n) {
            char c;
            int n3;
            int n4;
            int n5;
            int n6;
            if (!bl && n2 < n - 1 && string2.substring(n2, n2 + 2).equals("d(")) {
                n6 = n2 += 2;
                n5 = 1;
                while (n5 > 0) {
                    if (n2 >= n) {
                        return string;
                    }
                    n4 = string2.charAt(n2);
                    if (n4 == 40) {
                        ++n5;
                    }
                    if (n4 == 41) {
                        --n5;
                    }
                    ++n2;
                }
                n5 = n2 - 1;
                if (n2 > n - 3 || !string2.substring(n2, n2 + 3).equals("/d(")) {
                    return string;
                }
                n4 = n2 += 3;
                n3 = 1;
                while (n3 > 0) {
                    if (n2 >= n) {
                        return string;
                    }
                    c = string2.charAt(n2);
                    if (c == '(') {
                        ++n3;
                    }
                    if (c == ')') {
                        --n3;
                    }
                    ++n2;
                }
                n3 = n2 - 1;
                string3 = string3 + "derive(" + string.substring(n6, n5) + "," + string.substring(n4, n3) + ")";
                --n2;
            } else if (!bl && n2 < n - 4 && string2.substring(n2, n2 + 5).equals("link(")) {
                Object object;
                Object object2;
                Method[] methodArray;
                String string4;
                n6 = n2 += 5;
                try {
                    while (string2.charAt(n2) != '(') {
                        ++n2;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return string;
                }
                n5 = ++n2 - 1;
                n4 = n2;
                n3 = 2;
                while (n3 > 1) {
                    if (n2 >= n) {
                        return string;
                    }
                    c = string2.charAt(n2);
                    if (c == '(') {
                        ++n3;
                    }
                    if (c == ')') {
                        --n3;
                    }
                    ++n2;
                }
                n3 = n2 - 1;
                if (n2 >= n || string2.charAt(n2) != ')') {
                    return string;
                }
                String string5 = string4 = string.substring(n6, n5) + "(";
                String string6 = string.substring(n4, n3);
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ",", false);
                boolean bl2 = true;
                Vector<String> vector = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    methodArray = stringTokenizer.nextToken();
                    if (bl2) {
                        bl2 = false;
                    } else {
                        string5 = string5 + ",";
                    }
                    object2 = RealType.getRealTypeByName((String)methodArray);
                    object = object2 == null ? "visad.Data" : "visad.RealType";
                    vector.add((String)object);
                    string5 = string5 + (String)object;
                }
                methodArray = FormulaUtil.stringsToMethods(new String[]{string5 = string5 + ")"});
                if (methodArray[0] == null) {
                    int n7;
                    int n8 = vector.size();
                    object = new Vector();
                    int n9 = 0;
                    while (n9 < n8) {
                        String string7 = (String)vector.elementAt(n9);
                        n7 = n9;
                        while (n7 < n8) {
                            String string8;
                            if (!(string8 = (String)vector.elementAt(n7++)).equals(string7)) break;
                            string5 = string4;
                            bl2 = true;
                            int n10 = 0;
                            while (n10 < n8) {
                                if (bl2) {
                                    bl2 = false;
                                } else {
                                    string5 = string5 + ",";
                                }
                                String string9 = (String)vector.elementAt(n10);
                                string5 = string5 + string9;
                                if (n9 == n10) {
                                    string5 = string5 + "[]";
                                    n10 = n7 - 1;
                                }
                                ++n10;
                            }
                            string5 = string5 + ")";
                            ((Vector)object).add(string5);
                        }
                        ++n9;
                    }
                    String[] stringArray = new String[((Vector)object).size()];
                    ((Vector)object).toArray(stringArray);
                    methodArray = FormulaUtil.stringsToMethods(stringArray);
                    int n11 = -1;
                    n7 = 0;
                    while (n7 < methodArray.length && n11 < 0) {
                        if (methodArray[n7] != null) {
                            n11 = n7;
                        }
                        ++n7;
                    }
                    if (n11 >= 0) {
                        methodArray[0] = methodArray[n11];
                    } else {
                        return string;
                    }
                }
                object2 = "link" + ++linkNum;
                try {
                    formulaManager.setThing((String)object2, new VMethod(methodArray[0]));
                }
                catch (FormulaException formulaException) {
                    return string;
                }
                catch (VisADException visADException) {
                    return string;
                }
                catch (RemoteException remoteException) {
                    return string;
                }
                string3 = string3 + "linkx(" + (String)object2 + "," + string.substring(n4, n3) + ")";
            } else if (!bl) {
                n6 = n2;
                n5 = string2.charAt(n6++);
                while (n6 < n && (n5 >= 97 && n5 <= 122 || n5 >= 48 && n5 <= 57)) {
                    n5 = string2.charAt(n6++);
                }
                if (n6 == n) {
                    return string3 + string.substring(n2, n);
                }
                if (n5 == 91) {
                    n4 = n6;
                    n3 = 1;
                    while (n3 > 0) {
                        if (n4 >= n) {
                            return string;
                        }
                        n5 = string2.charAt(n4);
                        if (n5 == 91) {
                            ++n3;
                        }
                        if (n5 == 93) {
                            --n3;
                        }
                        ++n4;
                    }
                    string3 = string3 + "getSample(" + string.substring(n2, n6 - 1) + "," + string.substring(n6, n4 - 1) + ")";
                    n2 = n4 - 1;
                } else {
                    string3 = string3 + string.charAt(n2);
                }
            } else {
                string3 = string3 + string.charAt(n2);
            }
            n6 = n2 < n ? (int)string2.charAt(n2) : 0;
            bl = n6 >= 97 && n6 <= 122;
            ++n2;
        }
        return string3;
    }

    public static Method[] stringsToMethods(String[] stringArray) {
        int n = stringArray.length;
        Method[] methodArray = new Method[n];
        int n2 = 0;
        while (n2 < n) {
            block16: {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n2], " ", false);
                String string = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string = string + stringTokenizer.nextToken();
                }
                stringTokenizer = new StringTokenizer(string, "(", false);
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                stringTokenizer = new StringTokenizer(string2, ".", false);
                String string4 = stringTokenizer.nextToken();
                int n3 = stringTokenizer.countTokens();
                int n4 = 0;
                while (n4 < n3 - 1) {
                    string4 = string4 + "." + stringTokenizer.nextToken();
                    ++n4;
                }
                String string5 = stringTokenizer.nextToken();
                stringTokenizer = new StringTokenizer(string3, ",)", false);
                n3 = stringTokenizer.countTokens();
                String[] stringArray2 = n3 == 0 ? null : new String[n3];
                int n5 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray2[n5++] = stringTokenizer.nextToken();
                }
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (FormulaVar.DEBUG) {
                        System.out.println("ERROR: Class " + string4 + " does not exist!");
                    }
                    methodArray[n2] = null;
                    break block16;
                }
                Class[] classArray = stringArray2 == null ? null : new Class[stringArray2.length];
                int n6 = 0;
                while (n6 < n3) {
                    if (stringArray2[n6].endsWith("[]")) {
                        stringArray2[n6] = "[L" + stringArray2[n6].substring(0, stringArray2[n6].length() - 2);
                        while (stringArray2[n6].endsWith("[]")) {
                            stringArray2[n6] = "[" + stringArray2[n6].substring(0, stringArray2[n6].length() - 2);
                        }
                        stringArray2[n6] = stringArray2[n6] + ";";
                    }
                    try {
                        classArray[n6] = Class.forName(stringArray2[n6]);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (FormulaVar.DEBUG) {
                            System.out.println("ERROR: Class " + stringArray2[n6] + " (" + n6 + ") does not exist!");
                        }
                        methodArray[n2] = null;
                    }
                    ++n6;
                }
                Method method = null;
                try {
                    method = clazz.getMethod(string5, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (FormulaVar.DEBUG) {
                        System.out.println("ERROR: Method " + string5 + " does not exist!");
                    }
                    methodArray[n2] = null;
                    break block16;
                }
                methodArray[n2] = method;
            }
            ++n2;
        }
        return methodArray;
    }

    public static Object invokeMethod(Method method, Object[] objectArray) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] objectArray2;
        Object object;
        Class<?>[] classArray = method.getParameterTypes();
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = -1;
        int n3 = -1;
        if (classArray != null) {
            n2 = classArray.length;
            int n4 = 0;
            while (n4 < n2) {
                if (classArray[n4].isArray()) {
                    n3 = n4;
                }
                ++n4;
            }
        }
        if (Modifier.isStatic(method.getModifiers())) {
            object = null;
            if (n > 0) {
                if (n3 < 0) {
                    objectArray2 = new Object[n];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n);
                } else {
                    objectArray2 = new Object[n2];
                    if (n3 > 0) {
                        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
                    }
                    Object object2 = Array.newInstance(classArray[n3].getComponentType(), n - n2 + 1);
                    System.arraycopy(objectArray, n3, object2, 0, n - n2 + 1);
                    objectArray2[n3] = object2;
                    if (n3 < n2 - 1) {
                        System.arraycopy(objectArray, n - n2 + n3 + 1, objectArray2, n3 + 1, n2 - n3 - 1);
                    }
                }
            } else {
                objectArray2 = null;
            }
        } else {
            if (n <= 0) {
                return null;
            }
            object = objectArray[0];
            if (n > 1) {
                if (n3 < 0) {
                    objectArray2 = new Object[n - 1];
                    System.arraycopy(objectArray, 1, objectArray2, 0, n - 1);
                } else {
                    objectArray2 = new Object[n2];
                    if (n3 > 0) {
                        System.arraycopy(objectArray, 1, objectArray2, 0, n3);
                    }
                    Object object3 = Array.newInstance(classArray[n3].getComponentType(), n - n2);
                    System.arraycopy(objectArray, n3 + 1, object3, 0, n - n2);
                    objectArray2[n3 + 1] = object3;
                    if (n3 < n2 - 1) {
                        System.arraycopy(objectArray, n - n2 + n3 + 1, objectArray2, n3 + 1, n2 - n3 - 1);
                    }
                }
            } else {
                objectArray2 = null;
            }
        }
        return method.invoke(object, objectArray2);
    }
}

