/*
 * Decompiled with CFR 0.152.
 */
package visad.formula;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.Thing;
import visad.ThingReference;
import visad.VisADException;
import visad.formula.FormulaException;
import visad.formula.FormulaUtil;
import visad.formula.FormulaVar;

public class FormulaManager {
    String[] bOps;
    int[] bPrec;
    Method[] bMethods;
    String[] uOps;
    int[] uPrec;
    Method[] uMethods;
    String[] funcs;
    Method[] fMethods;
    int iPrec;
    Method[] iMethods;
    Method ppMethod;
    private Vector Vars = new Vector();

    public void createVar(String string, ThingReference thingReference) throws VisADException {
        FormulaVar formulaVar;
        try {
            formulaVar = this.getVarByName(string);
        }
        catch (FormulaException formulaException) {
            formulaVar = null;
        }
        if (formulaVar != null) {
            throw new FormulaException("The variable " + string + " already exists.");
        }
        this.Vars.add(new FormulaVar(string, this, thingReference));
    }

    public void assignFormula(String string, String string2) throws VisADException {
        FormulaVar formulaVar = this.getVarByNameOrCreate(string);
        formulaVar.setFormula(string2);
    }

    public void waitForFormula(String string) throws VisADException {
        FormulaVar formulaVar = this.getVarByName(string);
        formulaVar.waitForFormula();
    }

    public void setTextRef(String string, ThingReference thingReference) throws VisADException, RemoteException {
        FormulaVar formulaVar = this.getVarByNameOrCreate(string);
        formulaVar.setTextRef(thingReference);
    }

    public String[] getErrors(String string) {
        try {
            FormulaVar formulaVar = this.getVarByNameOrCreate(string);
            String[] stringArray = formulaVar.getErrors();
            formulaVar.clearErrors();
            return stringArray;
        }
        catch (FormulaException formulaException) {
            return null;
        }
        catch (VisADException visADException) {
            return null;
        }
    }

    public boolean canBeRemoved(String string) throws FormulaException {
        FormulaVar formulaVar = this.getVarByName(string);
        return !formulaVar.othersDepend();
    }

    public boolean exists(String string) {
        boolean bl = false;
        try {
            FormulaVar formulaVar = this.getVarByName(string);
            bl = true;
        }
        catch (FormulaException formulaException) {
            // empty catch block
        }
        return bl;
    }

    public void remove(String string) throws FormulaException {
        if (!this.canBeRemoved(string)) {
            throw new FormulaException("Cannot remove variable " + string + " " + "because other variables depend on it!");
        }
        this.Vars.remove(this.getVarByName(string));
    }

    public void setThing(String string, Thing thing) throws VisADException, RemoteException {
        FormulaVar formulaVar = this.getVarByNameOrCreate(string);
        formulaVar.setThing(thing);
    }

    public void setReference(String string, ThingReference thingReference) throws VisADException {
        FormulaVar formulaVar = this.getVarByNameOrCreate(string);
        formulaVar.setReference(thingReference);
    }

    public Thing getThing(String string) throws FormulaException {
        FormulaVar formulaVar = this.getVarByName(string);
        return formulaVar.getThing();
    }

    public ThingReference getReference(String string) throws FormulaException {
        FormulaVar formulaVar = this.getVarByName(string);
        return formulaVar.getReference();
    }

    public String getFormula(String string) throws FormulaException {
        FormulaVar formulaVar = this.getVarByName(string);
        return formulaVar.getFormula();
    }

    FormulaVar getVarByName(String string) throws FormulaException {
        int n = 0;
        while (n < this.Vars.size()) {
            FormulaVar formulaVar = (FormulaVar)this.Vars.elementAt(n);
            if (formulaVar.name.equalsIgnoreCase(string)) {
                return formulaVar;
            }
            ++n;
        }
        throw new FormulaException("The variable " + string + " does not exist.");
    }

    FormulaVar getVarByNameOrCreate(String string) throws VisADException {
        FormulaVar formulaVar;
        try {
            formulaVar = this.getVarByName(string);
        }
        catch (FormulaException formulaException) {
            formulaVar = new FormulaVar(string, this);
            this.Vars.add(formulaVar);
        }
        return formulaVar;
    }

    boolean isUnaryOp(String string) {
        int n = 0;
        while (n < this.uOps.length) {
            if (this.uOps[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isBinaryOp(String string) {
        int n = 0;
        while (n < this.bOps.length) {
            if (this.bOps[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isFunction(String string) {
        int n = 0;
        while (n < this.funcs.length) {
            if (this.funcs[n].equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    int getUnaryPrec(String string) {
        int n = 0;
        while (n < this.uOps.length) {
            if (this.uOps[n].equals(string)) {
                return this.uPrec[n];
            }
            ++n;
        }
        return -1;
    }

    int getBinaryPrec(String string) {
        if (string.equals("(")) {
            return Integer.MAX_VALUE;
        }
        if (string.equals(",")) {
            return 0x7FFFFFFE;
        }
        int n = 0;
        while (n < this.bOps.length) {
            if (this.bOps[n].equals(string)) {
                return this.bPrec[n];
            }
            ++n;
        }
        return -1;
    }

    public FormulaManager(String[] stringArray, int[] nArray, String[] stringArray2, String[] stringArray3, int[] nArray2, String[] stringArray4, String[] stringArray5, String[] stringArray6, int n, String[] stringArray7, String string) throws FormulaException {
        int n2;
        char c;
        this.bOps = stringArray;
        this.bPrec = nArray;
        this.bMethods = FormulaUtil.stringsToMethods(stringArray2);
        this.uOps = stringArray3;
        this.uPrec = nArray2;
        this.uMethods = FormulaUtil.stringsToMethods(stringArray4);
        this.funcs = stringArray5;
        this.fMethods = FormulaUtil.stringsToMethods(stringArray6);
        this.iPrec = n;
        this.iMethods = FormulaUtil.stringsToMethods(stringArray7);
        String[] stringArray8 = new String[1];
        if (string == null) {
            this.ppMethod = null;
        } else {
            String[] stringArray9 = new String[]{string};
            Method[] methodArray = FormulaUtil.stringsToMethods(stringArray9);
            this.ppMethod = methodArray[0];
        }
        int n3 = this.bOps.length;
        int n4 = this.bPrec.length;
        int n5 = this.bMethods.length;
        if (n3 != n4 || n3 != n5) {
            throw new FormulaException("Binary arrays must have equal lengths");
        }
        n3 = this.uOps.length;
        n4 = this.uPrec.length;
        n5 = this.uMethods.length;
        if (n3 != n4 || n3 != n5) {
            throw new FormulaException("Unary arrays must have equal lengths");
        }
        n3 = this.funcs.length;
        n4 = this.fMethods.length;
        if (n3 != n4) {
            throw new FormulaException("Function arrays must have equal lengths");
        }
        int n6 = 0;
        while (n6 < this.bOps.length) {
            if (this.bOps[n6].length() > 1) {
                throw new FormulaException("All operators must be one character in length");
            }
            c = this.bOps[n6].charAt(0);
            if (c == '(' || c == ')' || c == ',' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                throw new FormulaException("The character \"" + c + "\" cannot be " + "used as an operator");
            }
            n2 = n6 + 1;
            while (n2 < this.bOps.length) {
                if (this.bOps[n6].charAt(0) == this.bOps[n2].charAt(0) && this.bPrec[n6] != this.bPrec[n2]) {
                    throw new FormulaException("Duplicate operators must have equal operator precedences");
                }
                ++n2;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.uOps.length) {
            if (this.uOps[n6].length() > 1) {
                throw new FormulaException("All operators must be one character in length");
            }
            c = this.uOps[n6].charAt(0);
            if (c == '(' || c == ')' || c == ',' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                throw new FormulaException("The character \"" + c + "\" cannot be " + "used as an operator");
            }
            n2 = n6 + 1;
            while (n2 < this.uOps.length) {
                if (this.uOps[n6].charAt(0) == this.uOps[n2].charAt(0) && this.uPrec[n6] != this.uPrec[n2]) {
                    throw new FormulaException("Duplicate operators must have equal operator precedences");
                }
                ++n2;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < stringArray5.length) {
            c = stringArray5[n6].charAt(0);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                throw new FormulaException("All functions must begin with a letter");
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.bMethods.length) {
            if (this.bMethods[n6] == null) {
                throw new FormulaException("The method \"" + stringArray2[n6] + "\" is not valid");
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.uMethods.length) {
            if (this.uMethods[n6] == null) {
                throw new FormulaException("The method \"" + stringArray4[n6] + "\" is not valid");
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.fMethods.length) {
            if (this.fMethods[n6] == null) {
                throw new FormulaException("The method \"" + stringArray6[n6] + "\" is not valid");
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.iMethods.length) {
            if (this.iMethods[n6] == null) {
                throw new FormulaException("The method \"" + stringArray7[n6] + "\" is not valid");
            }
            ++n6;
        }
    }
}

