/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.BaseUnit;
import visad.CommonUnit;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryString;

public class BinaryUnit
implements BinaryObject {
    public static final int computeBytes(Unit unit) {
        return 4 + BinaryString.computeBytes(unit.getIdentifier()) + BinaryString.computeBytes(unit.getDefinition().trim()) + 1;
    }

    public static final int computeBytes(Unit[] unitArray) {
        return BinaryIntegerArray.computeBytes(unitArray);
    }

    public static final int[] lookupList(BinaryObjectCache binaryObjectCache, Unit[] unitArray) {
        boolean bl = true;
        int n = 0;
        while (n < unitArray.length) {
            if (unitArray[n] != null) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        int[] nArray = new int[unitArray.length];
        int n2 = 0;
        while (n2 < unitArray.length) {
            nArray[n2] = unitArray[n2] == null ? -1 : binaryObjectCache.getIndex(unitArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public static final Unit read(BinaryReader binaryReader) throws IOException, VisADException {
        Unit unit;
        BinaryObjectCache binaryObjectCache = binaryReader.getUnitCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        String string = BinaryString.read(binaryReader);
        String string2 = BinaryString.read(binaryReader);
        byte by = dataInput.readByte();
        if (by != 80) {
            throw new IOException("Corrupted file (no Unit end-marker)");
        }
        if (string2.equals("promiscuous")) {
            unit = CommonUnit.promiscuous;
        } else {
            try {
                unit = Parser.parse(string2);
            }
            catch (Exception exception) {
                throw new VisADException("Couldn't parse Unit specification \"" + string2 + "\"");
            }
            if (!(unit instanceof BaseUnit)) {
                try {
                    Unit unit2;
                    unit = unit2 = unit.clone(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        binaryObjectCache.add(n2, unit);
        return unit;
    }

    public static final Unit[] readList(BinaryReader binaryReader) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryReader.getUnitCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 1) {
            throw new IOException("Corrupted file (bad Unit array length " + n + ")");
        }
        Unit[] unitArray = new Unit[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readInt();
            unitArray[n2] = n3 < 0 ? null : (Unit)binaryObjectCache.get(n3);
            ++n2;
        }
        return unitArray;
    }

    public static final int write(BinaryWriter binaryWriter, Unit unit, Object object) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryWriter.getUnitCache();
        int n = binaryObjectCache.getIndex(unit);
        if (n >= 0) {
            return n;
        }
        String string = unit.getDefinition().trim();
        String string2 = unit.getIdentifier();
        n = binaryObjectCache.add(unit);
        if (n < 0) {
            throw new IOException("Couldn't cache Unit " + unit);
        }
        int n2 = BinaryUnit.computeBytes(unit);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(7);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n);
        BinaryString.write(binaryWriter, string2, object);
        BinaryString.write(binaryWriter, string, object);
        dataOutputStream.writeByte(80);
        return n;
    }

    public static final int[] writeList(BinaryWriter binaryWriter, Unit[] unitArray, Object object) throws IOException {
        boolean bl = true;
        int n = 0;
        while (n < unitArray.length) {
            if (unitArray[n] != null) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        int[] nArray = new int[unitArray.length];
        int n2 = 0;
        while (n2 < unitArray.length) {
            nArray[n2] = unitArray[n2] == null ? -1 : BinaryUnit.write(binaryWriter, unitArray[n2], object);
            ++n2;
        }
        return nArray;
    }
}

