/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.MathType;
import visad.SampledSet;
import visad.SetType;
import visad.UnionSet;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySampledSet;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnknown;

public class BinaryUnionSet
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$UnionSet;

    public static final int computeBytes(SampledSet[] sampledSetArray) {
        int n = 5;
        int n2 = 0;
        while (n2 < sampledSetArray.length) {
            int n3 = BinaryGeneric.computeBytes(sampledSetArray[n2]);
            if (n3 < 0) {
                return -1;
            }
            n += n3;
            ++n2;
        }
        return 10 + BinarySampledSet.computeBytes(sampledSetArray) + 1;
    }

    public static final UnionSet read(BinaryReader binaryReader) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        SetType setType = (SetType)binaryObjectCache.get(n);
        SampledSet[] sampledSetArray = null;
        boolean bl = true;
        while (bl) {
            byte by;
            try {
                by = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (by) {
                case 11: {
                    sampledSetArray = BinarySampledSet.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown UnionSet directive " + by);
                }
            }
        }
        if (setType == null) {
            throw new IOException("No SetType found for UnionSet");
        }
        if (sampledSetArray == null) {
            throw new IOException("No sets found for UnionSet");
        }
        return new UnionSet((MathType)setType, sampledSetArray);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, SetType setType, SampledSet[] sampledSetArray, UnionSet unionSet, Object object) throws IOException {
        if (!(unionSet.getClass().equals(class$Lvisad$UnionSet != null ? class$Lvisad$UnionSet : (class$Lvisad$UnionSet = BinaryUnionSet.class$("visad.UnionSet"))) || unionSet instanceof UnionSet && unionSet instanceof Saveable)) {
            return;
        }
        Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
        BinarySetType.write(binaryWriter, setType, unionSet, BinaryObject.SAVE_DATA);
        if (sampledSetArray != null) {
            int n = 0;
            while (n < sampledSetArray.length) {
                BinaryGeneric.write(binaryWriter, sampledSetArray[n], object2);
                ++n;
            }
        }
    }

    public static final void write(BinaryWriter binaryWriter, SetType setType, SampledSet[] sampledSetArray, UnionSet unionSet, Object object) throws IOException {
        BinaryUnionSet.writeDependentData(binaryWriter, setType, sampledSetArray, unionSet, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(unionSet.getClass().equals(class$Lvisad$UnionSet != null ? class$Lvisad$UnionSet : (class$Lvisad$UnionSet = BinaryUnionSet.class$("visad.UnionSet"))) || unionSet instanceof UnionSet && unionSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, unionSet, object);
            return;
        }
        int n = binaryWriter.getTypeCache().getIndex(setType);
        if (n < 0) {
            throw new IOException("SetType " + setType + " not cached");
        }
        int n2 = BinaryUnionSet.computeBytes(sampledSetArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(37);
        dataOutputStream.writeInt(n);
        BinarySampledSet.writeList(binaryWriter, sampledSetArray, object);
        dataOutputStream.writeByte(80);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

