/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.MathType;
import visad.RealTupleType;
import visad.TupleType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryTupleType
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$TupleType;

    public static final int computeBytes(TupleType tupleType) {
        return 5 + tupleType.getDimension() * 4 + 1;
    }

    public static final TupleType read(BinaryReader binaryReader, int n, int n2) throws IOException, VisADException {
        MathType[] mathTypeArray = BinaryMathType.readList(binaryReader, (n2 - 1) / 4);
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        byte by = dataInput.readByte();
        if (by != 80) {
            throw new IOException("Corrupted file (no TupleType end-marker)");
        }
        TupleType tupleType = new TupleType(mathTypeArray);
        binaryObjectCache.add(n, tupleType);
        return tupleType;
    }

    public static final int write(BinaryWriter binaryWriter, TupleType tupleType, Object object) throws IOException {
        if (tupleType instanceof RealTupleType) {
            return BinaryRealTupleType.write(binaryWriter, (RealTupleType)tupleType, object);
        }
        int n = tupleType.getDimension();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            MathType mathType;
            try {
                mathType = tupleType.getComponent(n2);
            }
            catch (VisADException visADException) {
                throw new IOException("Couldn't get TupleType component #" + n2 + ": " + visADException.getMessage());
            }
            nArray[n2] = BinaryMathType.write(binaryWriter, mathType, object);
            ++n2;
        }
        BinaryObjectCache binaryObjectCache = binaryWriter.getTypeCache();
        int n3 = binaryObjectCache.getIndex(tupleType);
        if (n3 < 0) {
            n3 = binaryObjectCache.add(tupleType);
            if (n3 < 0) {
                throw new IOException("Couldn't cache TupleType " + tupleType);
            }
            if (!(tupleType.getClass().equals(class$Lvisad$TupleType != null ? class$Lvisad$TupleType : (class$Lvisad$TupleType = BinaryTupleType.class$("visad.TupleType"))) || tupleType instanceof TupleType && tupleType instanceof Saveable)) {
                BinarySerializedObject.write(binaryWriter, (byte)6, tupleType, object);
                return n3;
            }
            int n4 = BinaryTupleType.computeBytes(tupleType);
            DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
            dataOutputStream.writeByte(5);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeByte(6);
            int n5 = 0;
            while (n5 < n) {
                dataOutputStream.writeInt(nArray[n5]);
                ++n5;
            }
            dataOutputStream.writeByte(80);
        }
        return n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

