/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.Data;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryDataArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryTupleType;
import visad.data.visad.object.BinaryUnknown;

public class BinaryTuple
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$Tuple;

    public static final int computeBytes(Data[] dataArray) {
        int n = dataArray == null ? 0 : 1 + BinaryDataArray.computeBytes(dataArray);
        return 10 + n + 1;
    }

    public static final Tuple read(BinaryReader binaryReader) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        TupleType tupleType = (TupleType)binaryObjectCache.get(n);
        Data[] dataArray = null;
        boolean bl = true;
        while (bl) {
            byte by;
            try {
                by = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (by) {
                case 8: {
                    dataArray = BinaryDataArray.read(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown Tuple directive " + by);
                }
            }
        }
        return new Tuple(tupleType, dataArray);
    }

    private static final void writeDependentData(BinaryWriter binaryWriter, TupleType tupleType, Data[] dataArray, Tuple tuple, Object object) throws IOException {
        if (!(tuple.getClass().equals(class$Lvisad$Tuple != null ? class$Lvisad$Tuple : (class$Lvisad$Tuple = BinaryTuple.class$("visad.Tuple"))) || tuple instanceof Tuple && tuple instanceof Saveable)) {
            return;
        }
        Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
        BinaryTupleType.write(binaryWriter, tupleType, BinaryObject.SAVE_DATA);
        if (dataArray != null) {
            BinaryDataArray.write(binaryWriter, dataArray, object2);
        }
    }

    public static final void write(BinaryWriter binaryWriter, TupleType tupleType, Data[] dataArray, Tuple tuple, Object object) throws IOException {
        BinaryTuple.writeDependentData(binaryWriter, tupleType, dataArray, tuple, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(tuple.getClass().equals(class$Lvisad$Tuple != null ? class$Lvisad$Tuple : (class$Lvisad$Tuple = BinaryTuple.class$("visad.Tuple"))) || tuple instanceof Tuple && tuple instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, tuple, object);
            return;
        }
        int n = binaryWriter.getTypeCache().getIndex(tupleType);
        if (n < 0) {
            throw new IOException("TupleType " + tupleType + " not cached");
        }
        int n2 = BinaryTuple.computeBytes(dataArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(10);
        dataOutputStream.writeInt(n);
        if (dataArray != null) {
            dataOutputStream.writeByte(8);
            BinaryDataArray.write(binaryWriter, dataArray, object);
        }
        dataOutputStream.writeByte(80);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

