/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.TextType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinaryString;

public class BinaryTextType
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$TextType;

    public static final int computeBytes(TextType textType) {
        return 5 + BinaryString.computeBytes(textType.getName()) + 1;
    }

    public static final TextType read(BinaryReader binaryReader, int n) throws IOException, VisADException {
        String string = BinaryString.read(binaryReader);
        DataInput dataInput = binaryReader.getInput();
        byte by = dataInput.readByte();
        if (by != 80) {
            throw new IOException("Corrupted file (no TextType end-marker)");
        }
        TextType textType = TextType.getTextType(string);
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        binaryObjectCache.add(n, textType);
        return textType;
    }

    public static final int write(BinaryWriter binaryWriter, TextType textType, Object object) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryWriter.getTypeCache();
        int n = binaryObjectCache.getIndex(textType);
        if (n < 0) {
            n = binaryObjectCache.add(textType);
            if (n < 0) {
                throw new IOException("Couldn't cache TextType " + textType);
            }
            if (!(textType.getClass().equals(class$Lvisad$TextType != null ? class$Lvisad$TextType : (class$Lvisad$TextType = BinaryTextType.class$("visad.TextType"))) || textType instanceof TextType && textType instanceof Saveable)) {
                BinarySerializedObject.write(binaryWriter, (byte)6, textType, object);
                return n;
            }
            String string = textType.getName();
            int n2 = BinaryTextType.computeBytes(textType);
            DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
            dataOutputStream.writeByte(5);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeByte(5);
            BinaryString.write(binaryWriter, string, object);
            dataOutputStream.writeByte(80);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

