/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.Text;
import visad.TextType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryString;
import visad.data.visad.object.BinaryTextType;

public class BinaryText
implements BinaryObject {
    public static final int computeBytes(String string) {
        return 10 + BinaryString.computeBytes(string) + 1;
    }

    public static final Text read(BinaryReader binaryReader) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        TextType textType = (TextType)binaryObjectCache.get(n);
        String string = BinaryString.read(binaryReader);
        byte by = dataInput.readByte();
        if (by != 80) {
            throw new IOException("Corrupted file (no Text end-marker)");
        }
        return new Text(textType, string);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, TextType textType, Object object) throws IOException {
        BinaryTextType.write(binaryWriter, textType, BinaryObject.SAVE_DATA);
    }

    public static final void write(BinaryWriter binaryWriter, TextType textType, String string, boolean bl, Text text, Object object) throws IOException {
        BinaryText.writeDependentData(binaryWriter, textType, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        int n = binaryWriter.getTypeCache().getIndex(textType);
        if (n < 0) {
            throw new IOException("TextType " + textType + " not cached");
        }
        int n2 = BinaryText.computeBytes(string);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n);
        BinaryString.write(binaryWriter, string, object);
        dataOutputStream.writeByte(80);
    }
}

