/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.Data;
import visad.ErrorEstimate;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealTuple;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinarySingletonSet
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$SingletonSet;

    public static final int computeBytes(RealTupleType realTupleType, Real[] realArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) {
        boolean bl = BinaryRealTuple.isTrivialTuple(realTupleType, realArray);
        int n = BinaryUnit.computeBytes(unitArray);
        int n2 = BinaryErrorEstimate.computeBytes(errorEstimateArray);
        return 7 + BinaryRealTuple.computeBytes(realArray, coordinateSystem, bl) + (coordinateSystem == null ? 0 : 5) + (n == 0 ? 0 : n + 1) + (n2 == 0 ? 0 : n2 + 1) + 1;
    }

    public static final Real[] getSampleReals(RealTuple realTuple) {
        Data[] dataArray = realTuple.getComponents();
        if (dataArray == null) {
            return null;
        }
        Real[] realArray = new Real[dataArray.length];
        int n = 0;
        while (n < dataArray.length) {
            realArray[n] = (Real)dataArray[n];
            ++n;
        }
        return realArray;
    }

    public static SingletonSet read(BinaryReader binaryReader) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        DataInput dataInput = binaryReader.getInput();
        RealTuple realTuple = null;
        CoordinateSystem coordinateSystem = null;
        Unit[] unitArray = null;
        ErrorEstimate[] errorEstimateArray = null;
        boolean bl = true;
        while (bl) {
            byte by;
            try {
                by = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (by) {
                case 5: {
                    realTuple = (RealTuple)BinaryGeneric.read(binaryReader);
                    break;
                }
                case 32: {
                    int n = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 41: {
                    errorEstimateArray = BinaryErrorEstimate.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown SingletonSet directive " + by);
                }
            }
        }
        if (realTuple == null) {
            throw new IOException("No sample found for SingletonSet");
        }
        return new SingletonSet(realTuple, coordinateSystem, unitArray, errorEstimateArray);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, RealTuple realTuple, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, SingletonSet singletonSet, Object object) throws IOException {
        if (!(singletonSet.getClass().equals(class$Lvisad$SingletonSet != null ? class$Lvisad$SingletonSet : (class$Lvisad$SingletonSet = BinarySingletonSet.class$("visad.SingletonSet"))) || singletonSet instanceof SingletonSet && singletonSet instanceof Saveable)) {
            return;
        }
        Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
        if (errorEstimateArray != null) {
            BinaryErrorEstimate.writeList(binaryWriter, errorEstimateArray, BinaryObject.SAVE_DATA);
        }
        BinaryGeneric.write(binaryWriter, realTuple, object2);
    }

    public static final void write(BinaryWriter binaryWriter, RealTuple realTuple, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, SingletonSet singletonSet, Object object) throws IOException {
        BinarySingletonSet.writeDependentData(binaryWriter, realTuple, coordinateSystem, unitArray, errorEstimateArray, singletonSet, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(singletonSet.getClass().equals(class$Lvisad$SingletonSet != null ? class$Lvisad$SingletonSet : (class$Lvisad$SingletonSet = BinarySingletonSet.class$("visad.SingletonSet"))) || singletonSet instanceof SingletonSet && singletonSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, singletonSet, object);
            return;
        }
        if (realTuple == null) {
            throw new IOException("Null SingletonSet sample");
        }
        int n = -1;
        if (coordinateSystem != null && (n = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray = null;
        if (unitArray != null) {
            nArray = BinaryUnit.lookupList(binaryWriter.getUnitCache(), unitArray);
        }
        int[] nArray2 = null;
        if (errorEstimateArray != null) {
            nArray2 = BinaryErrorEstimate.lookupList(binaryWriter.getErrorEstimateCache(), errorEstimateArray);
        }
        RealTupleType realTupleType = (RealTupleType)realTuple.getType();
        Real[] realArray = BinarySingletonSet.getSampleReals(realTuple);
        int n2 = BinarySingletonSet.computeBytes(realTupleType, realArray, coordinateSystem, unitArray, errorEstimateArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(36);
        dataOutputStream.writeByte(5);
        BinaryRealTuple.write(binaryWriter, realTupleType, realArray, realTuple.getCoordinateSystem(), realTuple, object);
        if (n >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n);
        }
        if (nArray != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray, object);
        }
        if (nArray2 != null) {
            dataOutputStream.writeByte(41);
            BinaryIntegerArray.write(binaryWriter, nArray2, object);
        }
        dataOutputStream.writeByte(80);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

