/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.DoubleSet;
import visad.FloatSet;
import visad.SetType;
import visad.SimpleSet;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinarySimpleSet
implements BinaryObject {
    public static final int computeBytes(CoordinateSystem coordinateSystem, Unit[] unitArray) {
        int n = BinaryUnit.computeBytes(unitArray);
        return 10 + (coordinateSystem == null ? 0 : 5) + (n == 0 ? 0 : n + 1) + 1;
    }

    public static final SimpleSet read(BinaryReader binaryReader, byte by) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getCoordinateSystemCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        SetType setType = (SetType)binaryObjectCache.get(n);
        CoordinateSystem coordinateSystem = null;
        Unit[] unitArray = null;
        boolean bl = true;
        while (bl) {
            byte by2;
            try {
                by2 = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (by2) {
                case 32: {
                    int n2 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache2.get(n2);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown SimpleSet directive " + by2);
                }
            }
        }
        if (setType == null) {
            throw new IOException("No SetType found for SimpleSet");
        }
        switch (by) {
            case 33: {
                return new FloatSet(setType, coordinateSystem, unitArray);
            }
            case 32: {
                return new DoubleSet(setType, coordinateSystem, unitArray);
            }
        }
        throw new IOException("Unknown SimpleSet type " + by);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, SimpleSet simpleSet, Class clazz, Object object) throws IOException {
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        if (!(simpleSet.getClass().equals(clazz) || simpleSet instanceof SimpleSet && simpleSet instanceof Saveable)) {
            return;
        }
        BinarySetType.write(binaryWriter, setType, simpleSet, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter binaryWriter, SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, SimpleSet simpleSet, Class clazz, byte by, Object object) throws IOException {
        BinarySimpleSet.writeDependentData(binaryWriter, setType, coordinateSystem, unitArray, simpleSet, clazz, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(simpleSet.getClass().equals(clazz) || simpleSet instanceof SimpleSet && simpleSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, simpleSet, object);
            return;
        }
        int n = binaryWriter.getTypeCache().getIndex(setType);
        if (n < 0) {
            throw new IOException("SetType " + setType + " not cached");
        }
        int n2 = -1;
        if (coordinateSystem != null && (n2 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray = null;
        if (unitArray != null) {
            nArray = BinaryUnit.lookupList(binaryWriter.getCoordinateSystemCache(), unitArray);
        }
        int n3 = BinarySimpleSet.computeBytes(coordinateSystem, unitArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeInt(n);
        if (n2 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n2);
        }
        if (nArray != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray, object);
        }
        dataOutputStream.writeByte(80);
    }
}

