/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinarySerializedObject
implements BinaryObject {
    public static final int computeBytes(Object object) {
        byte[] byArray;
        try {
            byArray = BinarySerializedObject.getBytes(object);
        }
        catch (IOException iOException) {
            return 0;
        }
        return 5 + byArray.length + 1;
    }

    public static byte[] getBytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static final Object read(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        return BinarySerializedObject.read(dataInput, n);
    }

    public static final Object read(DataInput dataInput, int n) throws IOException {
        Object object;
        if (n <= 1) {
            throw new IOException("Corrupted file (bad serialized object length)");
        }
        byte[] byArray = new byte[n - 1];
        dataInput.readFully(byArray);
        byte by = dataInput.readByte();
        if (by != 80) {
            throw new IOException("Corrupted file (no serialized object end-marker)");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        try {
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Couldn't read serialized object: " + classNotFoundException.getMessage());
        }
        objectInputStream.close();
        return object;
    }

    public static final void write(BinaryWriter binaryWriter, byte by, Object object, Object object2) throws IOException {
        byte[] byArray = BinarySerializedObject.getBytes(object);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(by);
        dataOutputStream.writeInt(byArray.length + 1);
        dataOutputStream.write(byArray);
        dataOutputStream.writeByte(80);
    }
}

