/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.IOException;
import visad.RealType;
import visad.ScalarType;
import visad.TextType;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinaryTextType;

public class BinaryScalarType
implements BinaryObject {
    public static final int computeBytes(ScalarType scalarType) {
        if (scalarType instanceof RealType) {
            return BinaryRealType.computeBytes((RealType)scalarType);
        }
        if (scalarType instanceof TextType) {
            return BinaryTextType.computeBytes((TextType)scalarType);
        }
        return BinarySerializedObject.computeBytes(scalarType);
    }

    public static final int write(BinaryWriter binaryWriter, ScalarType scalarType, Object object) throws IOException {
        if (scalarType instanceof RealType) {
            return BinaryRealType.write(binaryWriter, (RealType)scalarType, object);
        }
        if (scalarType instanceof TextType) {
            return BinaryTextType.write(binaryWriter, (TextType)scalarType, object);
        }
        BinaryObjectCache binaryObjectCache = binaryWriter.getTypeCache();
        int n = binaryObjectCache.getIndex(scalarType);
        if (n < 0) {
            n = binaryObjectCache.add(scalarType);
            if (n < 0) {
                throw new IOException("Couldn't cache ScalarType " + scalarType);
            }
            BinarySerializedObject.write(binaryWriter, (byte)6, scalarType, object);
        }
        return n;
    }
}

