/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.DisplayTupleType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.Set;
import visad.TypeException;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDisplayTupleType;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinaryRealVectorType;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryRealTupleType
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$RealTupleType;

    public static final int computeBytes(RealTupleType realTupleType) {
        return 9 + realTupleType.getDimension() * 4 + (realTupleType.getCoordinateSystem() == null ? 0 : 5) + (realTupleType.getDefaultSet() == null ? 0 : 1) + 1;
    }

    public static final RealTupleType read(BinaryReader binaryReader, int n) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n2 = dataInput.readInt();
        MathType[] mathTypeArray = BinaryMathType.readList(binaryReader, n2);
        RealType[] realTypeArray = new RealType[mathTypeArray.length];
        int n3 = 0;
        while (n3 < mathTypeArray.length) {
            realTypeArray[n3] = (RealType)mathTypeArray[n3];
            ++n3;
        }
        CoordinateSystem coordinateSystem = null;
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            byte by;
            try {
                by = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (by) {
                case 32: {
                    int n4 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n4);
                    break;
                }
                case 70: {
                    bl = true;
                    break;
                }
                case 80: {
                    bl2 = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown RealTupleType directive " + by);
                }
            }
        }
        RealTupleType realTupleType = new RealTupleType(realTypeArray, coordinateSystem, null);
        binaryObjectCache2.add(n, realTupleType);
        if (bl) {
            Set set = (Set)BinaryGeneric.read(binaryReader);
            try {
                realTupleType.setDefaultSet(set);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return realTupleType;
    }

    public static final int write(BinaryWriter binaryWriter, RealTupleType realTupleType, Object object) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryWriter.getTypeCache();
        if (realTupleType instanceof DisplayTupleType) {
            return BinaryDisplayTupleType.write(binaryWriter, (DisplayTupleType)realTupleType, object);
        }
        if (realTupleType instanceof RealVectorType) {
            return BinaryRealVectorType.write(binaryWriter, (RealVectorType)realTupleType, object);
        }
        int n = binaryObjectCache.getIndex(realTupleType);
        if (n < 0) {
            n = binaryObjectCache.add(realTupleType);
            if (n < 0) {
                throw new IOException("Couldn't cache RealTupleType " + realTupleType);
            }
            if (!(realTupleType.getClass().equals(class$Lvisad$RealTupleType != null ? class$Lvisad$RealTupleType : (class$Lvisad$RealTupleType = BinaryRealTupleType.class$("visad.RealTupleType"))) || realTupleType instanceof RealTupleType && realTupleType instanceof Saveable)) {
                BinarySerializedObject.write(binaryWriter, (byte)6, realTupleType, object);
                return n;
            }
            int n2 = realTupleType.getDimension();
            Set set = realTupleType.getDefaultSet();
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < n2) {
                RealType realType;
                try {
                    realType = (RealType)realTupleType.getComponent(n3);
                }
                catch (VisADException visADException) {
                    throw new IOException("Couldn't get RealTupleType component #" + n3 + ": " + visADException.getMessage());
                }
                nArray[n3] = BinaryRealType.write(binaryWriter, realType, object);
                ++n3;
            }
            CoordinateSystem coordinateSystem = realTupleType.getCoordinateSystem();
            int n4 = -1;
            if (coordinateSystem != null) {
                n4 = BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, object);
            }
            int n5 = BinaryRealTupleType.computeBytes(realTupleType);
            DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
            dataOutputStream.writeByte(5);
            dataOutputStream.writeInt(n5);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeByte(3);
            dataOutputStream.writeInt(n2);
            int n6 = 0;
            while (n6 < n2) {
                dataOutputStream.writeInt(nArray[n6]);
                ++n6;
            }
            if (n4 >= 0) {
                dataOutputStream.writeByte(32);
                dataOutputStream.writeInt(n4);
            }
            if (set != null) {
                dataOutputStream.writeByte(70);
            }
            dataOutputStream.writeByte(80);
            if (set != null) {
                Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
                BinaryGeneric.write(binaryWriter, set, object2);
                BinaryGeneric.write(binaryWriter, set, BinaryObject.SAVE_DATA);
            }
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

