/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDoubleArray;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinaryUnknown;

public class BinaryRealTuple
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$RealTuple;

    public static final int computeBytes(Real[] realArray, CoordinateSystem coordinateSystem, boolean bl) {
        int n;
        if (realArray == null) {
            n = 0;
        } else if (bl) {
            n = 5 + realArray.length * 8;
        } else {
            n = 5;
            int n2 = 0;
            while (n2 < realArray.length) {
                n += BinaryReal.computeBytes(realArray[n2].getUnit(), realArray[n2].getError());
                ++n2;
            }
        }
        return 10 + n + (coordinateSystem == null ? 0 : 5) + 1;
    }

    public static final boolean isTrivialTuple(RealTupleType realTupleType, Real[] realArray) {
        if (realArray == null) {
            return true;
        }
        int n = 0;
        while (n < realArray.length) {
            if (realArray[n] != null) {
                MathType mathType;
                try {
                    mathType = realTupleType.getComponent(n);
                }
                catch (VisADException visADException) {
                    return false;
                }
                if (!mathType.equals(realArray[n].getType()) || realArray[n].getUnit() != null || realArray[n].getError() != null) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public static final RealTuple read(BinaryReader binaryReader) throws IOException, VisADException {
        int n;
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n2 = dataInput.readInt();
        RealTupleType realTupleType = (RealTupleType)binaryObjectCache2.get(n2);
        Real[] realArray = null;
        double[] dArray = null;
        CoordinateSystem coordinateSystem = null;
        boolean bl = true;
        while (bl) {
            try {
                n = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (n) {
                case 32: {
                    int n3 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n3);
                    break;
                }
                case 9: {
                    realArray = BinaryRealTuple.readRealArray(binaryReader);
                    break;
                }
                case 10: {
                    dArray = BinaryDoubleArray.read(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown RealTuple directive " + n);
                }
            }
        }
        if (realArray != null && dArray != null) {
            throw new IOException("Found both RealTuple Real[] and double[] values");
        }
        if (dArray != null) {
            if (coordinateSystem == null) {
                return new RealTuple(realTupleType, dArray);
            }
            realArray = new Real[dArray.length];
            n = 0;
            while (n < dArray.length) {
                realArray[n] = new Real((RealType)realTupleType.getComponent(n), dArray[n], null, null);
                ++n;
            }
        }
        return new RealTuple(realTupleType, realArray, coordinateSystem);
    }

    private static final Real[] readRealArray(BinaryReader binaryReader) throws IOException, VisADException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 1) {
            throw new IOException("Corrupted file (bad Real array length " + n + ")");
        }
        long l = 0L;
        Real[] realArray = new Real[n];
        int n2 = 0;
        while (n2 < n) {
            realArray[n2] = (Real)BinaryGeneric.read(binaryReader);
            ++n2;
        }
        return realArray;
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, RealTupleType realTupleType, Real[] realArray, CoordinateSystem coordinateSystem, RealTuple realTuple, Object object) throws IOException {
        if (!(realTuple.getClass().equals(class$Lvisad$RealTuple != null ? class$Lvisad$RealTuple : (class$Lvisad$RealTuple = BinaryRealTuple.class$("visad.RealTuple"))) || realTuple instanceof RealTuple && realTuple instanceof Saveable)) {
            return;
        }
        Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
        BinaryRealTupleType.write(binaryWriter, realTupleType, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (realArray != null) {
            int n = 0;
            while (n < realArray.length) {
                BinaryGeneric.write(binaryWriter, realArray[n], object2);
                ++n;
            }
        }
    }

    public static final void write(BinaryWriter binaryWriter, RealTupleType realTupleType, Real[] realArray, CoordinateSystem coordinateSystem, RealTuple realTuple, Object object) throws IOException {
        BinaryRealTuple.writeDependentData(binaryWriter, realTupleType, realArray, coordinateSystem, realTuple, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(realTuple.getClass().equals(class$Lvisad$RealTuple != null ? class$Lvisad$RealTuple : (class$Lvisad$RealTuple = BinaryRealTuple.class$("visad.RealTuple"))) || realTuple instanceof RealTuple && realTuple instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, realTuple, object);
            return;
        }
        int n = binaryWriter.getTypeCache().getIndex(realTupleType);
        if (n < 0) {
            throw new IOException("RealTupleType " + realTupleType + " not cached");
        }
        int n2 = -1;
        if (coordinateSystem != null && (n2 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        boolean bl = BinaryRealTuple.isTrivialTuple(realTupleType, realArray);
        int n3 = BinaryRealTuple.computeBytes(realArray, coordinateSystem, bl);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeByte(11);
        dataOutputStream.writeInt(n);
        if (realArray != null) {
            if (bl) {
                dataOutputStream.writeByte(10);
                dataOutputStream.writeInt(realArray.length);
                int n4 = 0;
                while (n4 < realArray.length) {
                    dataOutputStream.writeDouble(realArray[n4].getValue());
                    ++n4;
                }
            } else {
                dataOutputStream.writeByte(9);
                dataOutputStream.writeInt(realArray.length);
                int n5 = 0;
                while (n5 < realArray.length) {
                    BinaryReal.write(binaryWriter, (RealType)realArray[n5].getType(), realArray[n5].getValue(), realArray[n5].getUnit(), realArray[n5].getError(), realArray[n5], object);
                    ++n5;
                }
            }
        }
        if (n2 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n2);
        }
        dataOutputStream.writeByte(80);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

